/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ReposFreezeAction;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Revision;

public class SVNReposTests
extends SVNTests {
    public SVNReposTests() {
    }

    public SVNReposTests(String string) {
        super(string);
    }

    public void testCreate() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        SVNReposTests.assertTrue((String)"repository exists", (boolean)oneTest.getRepository().exists());
    }

    public void testSetRevProp() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        this.admin.setRevProp(oneTest.getRepository(), Revision.getInstance(0L), "svn:log", "Initial repository creation", false, false);
        Map<String, byte[]> map = this.client.revProperties(this.makeReposUrl(oneTest.getRepository()).toString(), Revision.getInstance(0L));
        SVNReposTests.assertNotNull((Object)"expect non null rev props");
        String string = new String(map.get("svn:log"));
        SVNReposTests.assertEquals((String)"expect rev prop change to take effect", (String)"Initial repository creation", (String)string);
    }

    public void testVerify() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        this.admin.verify(oneTest.getRepository(), Revision.getInstance(0L), Revision.HEAD, null);
    }

    public void testUpgrade() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        this.admin.upgrade(oneTest.getRepository(), null);
    }

    public void testPack() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        this.admin.pack(oneTest.getRepository(), null);
    }

    public void testFreeze() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        FreezeAction freezeAction = new FreezeAction();
        this.admin.freeze(freezeAction, oneTest.getRepository());
        SVNReposTests.assertEquals((String)"expect freeze callback to be invoked once", (int)1, (int)freezeAction.invoked);
    }

    public void testLoadRepo() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = (SVNTests)this.new SVNTests.OneTest(false, false);
        URI uRI = this.makeReposUrl(oneTest.getRepository());
        final Info[] infoArray = new Info[1];
        InfoCallback infoCallback = new InfoCallback(){

            @Override
            public void singleInfo(Info info) {
                infoArray[0] = info;
            }
        };
        this.client.info2(uRI.toString(), Revision.HEAD, Revision.HEAD, Depth.immediates, null, infoCallback);
        SVNReposTests.assertNotNull((String)"expect info callback", (Object)infoArray[0]);
        SVNReposTests.assertEquals((String)"expect zero revisions in new repository", (long)0L, (long)infoArray[0].getLastChangedRev());
        String string = System.getProperty("test.srcdir", "subversion/bindings/javahl");
        File file = new File(string, "tests/data/issue2979.dump");
        FileInputStream fileInputStream = new FileInputStream(file);
        this.admin.load(oneTest.getRepository(), fileInputStream, true, true, false, false, null, null);
        infoArray[0] = null;
        this.client.info2(uRI.toString(), Revision.HEAD, Revision.HEAD, Depth.immediates, null, infoCallback);
        SVNReposTests.assertEquals((String)"expect two revisions after load()", (long)2L, (long)infoArray[0].getLastChangedRev());
        SVNReposTests.assertEquals((String)"expect 'svn4ant' as author of r2", (String)"svn4ant", (String)infoArray[0].getLastChangedAuthor());
    }

    private class FreezeAction
    implements ReposFreezeAction {
        int invoked = 0;

        private FreezeAction() {
        }

        @Override
        public void invoke() {
            ++this.invoked;
        }
    }
}

