#if HAS_TFT // VIEW_480x320

#include "graphics/view/TFT/TFTView_480x320.h"
#include "graphics/common/ViewController.h"
#include "graphics/driver/DisplayDriverFactory.h"
#include "ui.h" // this is the ui generated by lvgl / squareline editor
#include "util/ILog.h"
#include <cstdio>
#include <ctime>
#include <functional>

TFTView_480x320 *TFTView_480x320::gui = nullptr;

TFTView_480x320 *TFTView_480x320::instance(void)
{
    if (!gui)
        gui = new TFTView_480x320(nullptr, DisplayDriverFactory::create(480, 320));
    return gui;
}

TFTView_480x320 *TFTView_480x320::instance(const DisplayDriverConfig &cfg)
{
    if (!gui)
        gui = new TFTView_480x320(&cfg, DisplayDriverFactory::create(cfg));
    return gui;
}

TFTView_480x320::TFTView_480x320(const DisplayDriverConfig *cfg, DisplayDriver *driver)
    : MeshtasticView(cfg, driver, new ViewController)
{
}

void TFTView_480x320::init(IClientBase *client)
{
    ILOG_DEBUG("TFTView_480x320 init...");
    MeshtasticView::init(client);
}

void TFTView_480x320::task_handler(void)
{
    MeshtasticView::task_handler();
}

#endif