
# Mbed OS: framework for [PlatformIO](https://platformio.org)

Arm Mbed OS is a platform operating system designed for the internet of things

* [Home](https://platformio.org/frameworks/mbed) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/mbed.html)

# Examples

- [Freescale Kinetis](https://github.com/platformio/platform-freescalekinetis)
  * [mbed-legacy-examples](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-legacy-examples)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-ethernet-tls](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-ethernet-tls)
  * [mbed-rtos-kvstore](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-kvstore)
  * [mbed-rtos-psa](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-psa)
  * [mbed-rtos-usb-msd](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/mbed-rtos-usb-msd)
  * [zephyr-blink](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/zephyr-blink)
  * [zephyr-net-telnet](https://github.com/platformio/platform-freescalekinetis/tree/master/examples/zephyr-net-telnet)

- [Maxim 32](https://github.com/platformio/platform-maxim32)
  * [mbed-legacy-examples](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-legacy-examples)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-mutex](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-rtos-mutex)
  * [mbed-rtos-sysinfo](https://github.com/platformio/platform-maxim32/tree/master/examples/mbed-rtos-sysinfo)

- [Nordic nRF52](https://github.com/platformio/platform-nordicnrf52)
  * [arduino-ble-led](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-ble-led)
  * [arduino-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-blink)
  * [arduino-bluefruit-bleuart](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-bluefruit-bleuart)
  * [arduino-nina-b1-generic-example](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-nina-b1-generic-example)
  * [arduino-serial-plotter](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/arduino-serial-plotter)
  * [mbed-rtos-ble-thermometer](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-rtos-ble-thermometer)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-nfc](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/mbed-rtos-nfc)
  * [zephyr-ble-beacon](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-ble-beacon)
  * [zephyr-blink](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-blink)
  * [zephyr-net-echo-client](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-net-echo-client)
  * [zephyr-subsys-nvs](https://github.com/platformio/platform-nordicnrf52/tree/master/examples/zephyr-subsys-nvs)

- [NXP i.MX RT](https://github.com/platformio/platform-nxpimxrt)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-cellular](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/mbed-rtos-cellular)
  * [mbed-rtos-ethernet-tls](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/mbed-rtos-ethernet-tls)
  * [zephyr-blink](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/zephyr-blink)
  * [zephyr-synchronization](https://github.com/platformio/platform-nxpimxrt/tree/master/examples/zephyr-synchronization)

- [NXP LPC](https://github.com/platformio/platform-nxplpc)
  * [mbed-legacy-examples](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-legacy-examples)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-blockdevice](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos-blockdevice)
  * [mbed-rtos-thread-statistics](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos-thread-statistics)
  * [zephyr-blink](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-blink)
  * [zephyr-custom-board](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-custom-board)
  * [zephyr-synchronization](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-synchronization)

- [RISC-V GAP](https://github.com/platformio/platform-riscv_gap)
  * [gapuino-mbed-autotiler-cifar10](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-autotiler-cifar10)
  * [gapuino-mbed-driver-cpp-raw-serial](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-cpp-raw-serial)
  * [gapuino-mbed-driver-hyper-flash](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-hyper-flash)
  * [gapuino-mbed-driver-hyper-rtc-alarm](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-driver-hyper-rtc-alarm)
  * [gapuino-mbed-events-queue](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-events-queue)
  * [gapuino-mbed-features-cluster-dma](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-features-cluster-dma)
  * [gapuino-mbed-features-filesystem](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-features-filesystem)
  * [gapuino-mbed-fft2d](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-fft2d)
  * [gapuino-mbed-matadd](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-matadd)
  * [gapuino-mbed-os-irq](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-os-irq)
  * [gapuino-mbed-os-memory-pool](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-mbed-os-memory-pool)
  * [gapuino-pulp-os-autotiler-bilinear-resize](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-autotiler-bilinear-resize)
  * [gapuino-pulp-os-autotiler-cifar10](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-autotiler-cifar10)
  * [gapuino-pulp-os-filesystem](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-filesystem)
  * [gapuino-pulp-os-hello-world](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-hello-world)
  * [gapuino-pulp-os-i2c-eeprom](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-i2c-eeprom)
  * [gapuino-pulp-os-kernel-dma](https://github.com/platformio/platform-riscv_gap/tree/master/examples/gapuino-pulp-os-kernel-dma)

- [Silicon Labs EFM32](https://github.com/platformio/platform-siliconlabsefm32)
  * [mbed-legacy-examples](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-legacy-examples)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-semaphore](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-rtos-semaphore)
  * [mbed-rtos-usb-cdc](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/mbed-rtos-usb-cdc)
  * [zephyr-blink](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/zephyr-blink)
  * [zephyr-custom-module](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/zephyr-custom-module)
  * [zephyr-subsys-console-getline](https://github.com/platformio/platform-siliconlabsefm32/tree/master/examples/zephyr-subsys-console-getline)

- [ST STM32](https://github.com/platformio/platform-ststm32)
  * [arduino-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-internal-libs)
  * [arduino-mbed-doom](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mbed-doom)
  * [arduino-mbed-rpc](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mbed-rpc)
  * [arduino-mxchip-azureiot](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-azureiot)
  * [arduino-mxchip-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-filesystem)
  * [arduino-mxchip-sensors](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-sensors)
  * [arduino-mxchip-wifiscan](https://github.com/platformio/platform-ststm32/tree/master/examples/arduino-mxchip-wifiscan)
  * [cmsis-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/cmsis-blink)
  * [libopencm3-1bitsy](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-1bitsy)
  * [libopencm3-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-blink)
  * [libopencm3-usb-cdcacm](https://github.com/platformio/platform-ststm32/tree/master/examples/libopencm3-usb-cdcacm)
  * [mbed-rtos-blink-baremetal](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-blink-baremetal)
  * [mbed-rtos-custom-target](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-custom-target)
  * [mbed-rtos-ethernet-tls](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-ethernet-tls)
  * [mbed-rtos-events](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-events)
  * [mbed-rtos-filesystem](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-filesystem)
  * [mbed-rtos-mesh-minimal](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-mesh-minimal)
  * [mbed-rtos-serial](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-serial)
  * [mbed-rtos-usb-keyboard](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-usb-keyboard)
  * [mbed-rtos-wifi](https://github.com/platformio/platform-ststm32/tree/master/examples/mbed-rtos-wifi)
  * [spl-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/spl-blink)
  * [stm32cube-hal-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-blink)
  * [stm32cube-hal-eeprom-emulation](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-eeprom-emulation)
  * [stm32cube-hal-extmem-boot](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-extmem-boot)
  * [stm32cube-hal-iap](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-iap)
  * [stm32cube-hal-lcd](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-lcd)
  * [stm32cube-hal-usb-device-dfu](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-usb-device-dfu)
  * [stm32cube-hal-wifi-client](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-hal-wifi-client)
  * [stm32cube-ll-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/stm32cube-ll-blink)
  * [zephyr-blink](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-blink)
  * [zephyr-cpp-synchronization](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-cpp-synchronization)
  * [zephyr-drivers-can](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-drivers-can)
  * [zephyr-net-civetweb](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-net-civetweb)
  * [zephyr-net-https-client](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-net-https-client)
  * [zephyr-subsys-usb-hid-mouse](https://github.com/platformio/platform-ststm32/tree/master/examples/zephyr-subsys-usb-hid-mouse)

- [Teensy](https://github.com/platformio/platform-teensy)
  * [arduino-blink](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-blink)
  * [arduino-hid-usb-mouse](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-hid-usb-mouse)
  * [arduino-internal-libs](https://github.com/platformio/platform-teensy/tree/master/examples/arduino-internal-libs)
  * [mbed-blink](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-teensy/tree/master/examples/mbed-serial)
  * [zephyr-blink](https://github.com/platformio/platform-teensy/tree/master/examples/zephyr-blink)
  * [zephyr-synchronization](https://github.com/platformio/platform-teensy/tree/master/examples/zephyr-synchronization)

