
# Simba: framework for [PlatformIO](https://platformio.org)

Simba is an RTOS and build framework with aims to make embedded programming easy and portable

* [Home](https://platformio.org/frameworks/simba) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/frameworks/simba.html)

# Examples

- [Atmel AVR](https://github.com/platformio/platform-atmelavr)
  * [arduino-blink](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-blink)
  * [arduino-external-libs](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-internal-libs)
  * [arduino-own-src_dir](https://github.com/platformio/platform-atmelavr/tree/master/examples/arduino-own-src_dir)
  * [digitstump-mouse](https://github.com/platformio/platform-atmelavr/tree/master/examples/digitstump-mouse)
  * [engduino-magnetometer](https://github.com/platformio/platform-atmelavr/tree/master/examples/engduino-magnetometer)
  * [native-blink](https://github.com/platformio/platform-atmelavr/tree/master/examples/native-blink)
  * [simba-blink](https://github.com/platformio/platform-atmelavr/tree/master/examples/simba-blink)

- [Atmel SAM](https://github.com/platformio/platform-atmelsam)
  * [arduino-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-blink)
  * [arduino-briki-internal-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-briki-internal-libs)
  * [arduino-external-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-external-libs)
  * [arduino-internal-libs](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-internal-libs)
  * [arduino-web-thing-led](https://github.com/platformio/platform-atmelsam/tree/master/examples/arduino-web-thing-led)
  * [mbed-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-blink)
  * [mbed-dsp](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-dsp)
  * [mbed-events](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-events)
  * [mbed-serial](https://github.com/platformio/platform-atmelsam/tree/master/examples/mbed-serial)
  * [simba-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/simba-blink)
  * [zephyr-blink](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-blink)
  * [zephyr-drivers-lcd-hd44780](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-drivers-lcd-hd44780)
  * [zephyr-subsys-logger](https://github.com/platformio/platform-atmelsam/tree/master/examples/zephyr-subsys-logger)

- [Espressif 32](https://github.com/platformio/platform-espressif32)
  * [arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-blink)
  * [arduino-briki-internal-libs](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-briki-internal-libs)
  * [arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-wifiscan)
  * [espidf-arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-blink)
  * [espidf-arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-wifiscan)
  * [espidf-aws-iot](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-aws-iot)
  * [espidf-ble-eddystone](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ble-eddystone)
  * [espidf-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-blink)
  * [espidf-coap-server](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-coap-server)
  * [espidf-exceptions](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-exceptions)
  * [espidf-hello-world](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-hello-world)
  * [espidf-http-request](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-http-request)
  * [espidf-peripherals-uart](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-peripherals-uart)
  * [espidf-peripherals-usb](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-peripherals-usb)
  * [espidf-storage-sdcard](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-storage-sdcard)
  * [espidf-storage-spiffs](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-storage-spiffs)
  * [espidf-ulp-adc](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-adc)
  * [espidf-ulp-pulse](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-pulse)
  * [pumbaa-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/pumbaa-blink)
  * [simba-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/simba-blink)

- [Espressif 8266](https://github.com/platformio/platform-espressif8266)
  * [arduino-asyncudp](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-asyncudp)
  * [arduino-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-blink)
  * [arduino-webserver](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-webserver)
  * [arduino-wifiscan](https://github.com/platformio/platform-espressif8266/tree/master/examples/arduino-wifiscan)
  * [esp8266-nonos-sdk-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/esp8266-nonos-sdk-blink)
  * [esp8266-rtos-sdk-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/esp8266-rtos-sdk-blink)
  * [simba-blink](https://github.com/platformio/platform-espressif8266/tree/master/examples/simba-blink)

