/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;

public final class MatchedQueriesPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) throws IOException {
        HashMap<String, Query> namedQueries = new HashMap<String, Query>();
        if (context.parsedQuery() != null) {
            namedQueries.putAll(context.parsedQuery().namedFilters());
        }
        if (context.parsedPostFilter() != null) {
            namedQueries.putAll(context.parsedPostFilter().namedFilters());
        }
        if (namedQueries.isEmpty()) {
            return null;
        }
        Map<String, Weight> weights = this.prepareWeights(context, namedQueries);
        return context.includeNamedQueriesScore() ? this.createScoringProcessor(weights) : this.createNonScoringProcessor(weights);
    }

    private Map<String, Weight> prepareWeights(FetchContext context, Map<String, Query> namedQueries) throws IOException {
        HashMap<String, Weight> weights = new HashMap<String, Weight>();
        ScoreMode scoreMode = context.includeNamedQueriesScore() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        for (Map.Entry<String, Query> entry : namedQueries.entrySet()) {
            weights.put(entry.getKey(), context.searcher().createWeight(context.searcher().rewrite(entry.getValue()), scoreMode, 1.0f));
        }
        return weights;
    }

    private FetchSubPhaseProcessor createScoringProcessor(final Map<String, Weight> weights) {
        return new FetchSubPhaseProcessor(){
            final Map<String, Scorer> matchingScorers = new HashMap<String, Scorer>();

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                this.matchingScorers.clear();
                for (Map.Entry entry : weights.entrySet()) {
                    Scorer scorer;
                    ScorerSupplier scorerSupplier = ((Weight)entry.getValue()).scorerSupplier(readerContext);
                    if (scorerSupplier == null || (scorer = scorerSupplier.get(0L)) == null) continue;
                    this.matchingScorers.put((String)entry.getKey(), scorer);
                }
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                LinkedHashMap<String, Float> matches = new LinkedHashMap<String, Float>();
                int docId = hitContext.docId();
                for (Map.Entry<String, Scorer> entry : this.matchingScorers.entrySet()) {
                    Scorer scorer = entry.getValue();
                    if (scorer.iterator().docID() < docId) {
                        scorer.iterator().advance(docId);
                    }
                    if (scorer.iterator().docID() != docId) continue;
                    matches.put(entry.getKey(), Float.valueOf(scorer.score()));
                }
                hitContext.hit().matchedQueriesWithScores(matches);
            }
        };
    }

    private FetchSubPhaseProcessor createNonScoringProcessor(final Map<String, Weight> weights) {
        return new FetchSubPhaseProcessor(){
            final Map<String, Bits> matchingBits = new HashMap<String, Bits>();

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                this.matchingBits.clear();
                for (Map.Entry entry : weights.entrySet()) {
                    ScorerSupplier scorerSupplier = ((Weight)entry.getValue()).scorerSupplier(readerContext);
                    if (scorerSupplier == null) continue;
                    Bits bits = Lucene.asSequentialAccessBits(readerContext.reader().maxDoc(), scorerSupplier);
                    this.matchingBits.put((String)entry.getKey(), bits);
                }
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                ArrayList<String> matches = new ArrayList<String>();
                int docId = hitContext.docId();
                for (Map.Entry<String, Bits> entry : this.matchingBits.entrySet()) {
                    if (!entry.getValue().get(docId)) continue;
                    matches.add(entry.getKey());
                }
                hitContext.hit().matchedQueries(matches.toArray(new String[0]));
            }
        };
    }
}

