/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kmssdkv2;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.internal.AwsKmsCmkArnInfo;
import com.amazonaws.encryptionsdk.internal.VersionInfo;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;

public final class AwsKmsMrkAwareMasterKey
extends MasterKey<AwsKmsMrkAwareMasterKey>
implements KmsMethods {
    static final ApiName API_NAME = ApiName.builder().name(VersionInfo.apiName()).version(VersionInfo.versionNumber()).build();
    private static final Consumer<AwsRequestOverrideConfiguration.Builder> API_NAME_INTERCEPTOR = builder -> builder.addApiName(API_NAME);
    private final KmsClient kmsClient_;
    private final List<String> grantTokens_ = new ArrayList<String>();
    private final String awsKmsIdentifier_;
    private final MasterKeyProvider<AwsKmsMrkAwareMasterKey> sourceProvider_;

    static AwsKmsMrkAwareMasterKey getInstance(KmsClient kms, String awsKmsIdentifier, MasterKeyProvider<AwsKmsMrkAwareMasterKey> provider) {
        return new AwsKmsMrkAwareMasterKey(awsKmsIdentifier, kms, provider);
    }

    private AwsKmsMrkAwareMasterKey(String awsKmsIdentifier, KmsClient kmsClient, MasterKeyProvider<AwsKmsMrkAwareMasterKey> provider) {
        AwsKmsCmkArnInfo.validAwsKmsIdentifier(awsKmsIdentifier);
        if (kmsClient == null) {
            throw new IllegalArgumentException("AwsKmsMrkAwareMasterKey must be configured with an AWS KMS client.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("AwsKmsMrkAwareMasterKey must be configured with a source provider.");
        }
        this.kmsClient_ = kmsClient;
        this.awsKmsIdentifier_ = awsKmsIdentifier;
        this.sourceProvider_ = provider;
    }

    @Override
    public String getProviderId() {
        return this.sourceProvider_.getDefaultProviderId();
    }

    @Override
    public String getKeyId() {
        return this.awsKmsIdentifier_;
    }

    @Override
    public void setGrantTokens(List<String> grantTokens) {
        this.grantTokens_.clear();
        this.grantTokens_.addAll(grantTokens);
    }

    @Override
    public List<String> getGrantTokens() {
        return this.grantTokens_;
    }

    @Override
    public void addGrantToken(String grantToken) {
        this.grantTokens_.add(grantToken);
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> generateDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        GenerateDataKeyResponse gdkResponse = this.kmsClient_.generateDataKey((GenerateDataKeyRequest)GenerateDataKeyRequest.builder().overrideConfiguration(API_NAME_INTERCEPTOR).keyId(this.awsKmsIdentifier_).numberOfBytes(Integer.valueOf(algorithm.getDataKeyLength())).encryptionContext(encryptionContext).grantTokens(this.grantTokens_).build());
        ByteBuffer plaintextBuffer = gdkResponse.plaintext().asByteBuffer();
        if (plaintextBuffer.limit() != algorithm.getDataKeyLength()) {
            throw new IllegalStateException("Received an unexpected number of bytes from KMS");
        }
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        plaintextBuffer.get(rawKey);
        String gdkResponseKeyId = gdkResponse.keyId();
        if (AwsKmsCmkArnInfo.parseInfoFromKeyArn(gdkResponseKeyId) == null) {
            throw new IllegalStateException("Received an empty or invalid keyId from KMS");
        }
        ByteBuffer ciphertextBlobBuffer = gdkResponse.ciphertextBlob().asByteBuffer();
        byte[] encryptedKey = new byte[ciphertextBlobBuffer.remaining()];
        ciphertextBlobBuffer.get(encryptedKey);
        SecretKeySpec key = new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo());
        return new DataKey<AwsKmsMrkAwareMasterKey>(key, encryptedKey, gdkResponseKeyId.getBytes(StandardCharsets.UTF_8), this);
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> encryptDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, DataKey<?> dataKey) {
        SecretKey key = dataKey.getKey();
        if (!key.getFormat().equals("RAW")) {
            throw new IllegalArgumentException("Only RAW encoded keys are supported");
        }
        try {
            EncryptResponse encryptResponse = this.kmsClient_.encrypt((EncryptRequest)EncryptRequest.builder().overrideConfiguration(API_NAME_INTERCEPTOR).keyId(this.awsKmsIdentifier_).plaintext(SdkBytes.fromByteArray((byte[])key.getEncoded())).encryptionContext(encryptionContext).grantTokens(this.grantTokens_).build());
            ByteBuffer ciphertextBlobBuffer = encryptResponse.ciphertextBlob().asByteBuffer();
            byte[] edk = new byte[ciphertextBlobBuffer.remaining()];
            ciphertextBlobBuffer.get(edk);
            String encryptResultKeyId = encryptResponse.keyId();
            if (AwsKmsCmkArnInfo.parseInfoFromKeyArn(encryptResultKeyId) == null) {
                throw new IllegalStateException("Received an empty or invalid keyId from KMS");
            }
            return new DataKey<AwsKmsMrkAwareMasterKey>(dataKey.getKey(), edk, encryptResultKeyId.getBytes(StandardCharsets.UTF_8), this);
        }
        catch (AwsServiceException asex) {
            throw new AwsCryptoException(asex);
        }
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList exceptions = new ArrayList();
        String providerId = this.getProviderId();
        return encryptedDataKeys.stream().filter(edk -> AwsKmsMrkAwareMasterKey.filterEncryptedDataKeys(providerId, this.awsKmsIdentifier_, edk)).map(edk -> {
            try {
                return AwsKmsMrkAwareMasterKey.decryptSingleEncryptedDataKey(this, this.kmsClient_, this.awsKmsIdentifier_, this.grantTokens_, algorithm, edk, encryptionContext);
            }
            catch (AwsServiceException amazonServiceException) {
                exceptions.add(amazonServiceException);
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> this.buildCannotDecryptDksException(exceptions));
    }

    static DataKey<AwsKmsMrkAwareMasterKey> decryptSingleEncryptedDataKey(AwsKmsMrkAwareMasterKey masterKey, KmsClient client, String awsKmsIdentifier, List<String> grantTokens, CryptoAlgorithm algorithm, EncryptedDataKey edk, Map<String, String> encryptionContext) {
        DecryptResponse decryptResponse = client.decrypt((DecryptRequest)DecryptRequest.builder().overrideConfiguration(API_NAME_INTERCEPTOR).ciphertextBlob(SdkBytes.fromByteArray((byte[])edk.getEncryptedDataKey())).encryptionContext(encryptionContext).grantTokens(grantTokens).keyId(awsKmsIdentifier).build());
        String decryptResponseKeyId = decryptResponse.keyId();
        if (decryptResponseKeyId == null) {
            throw new IllegalStateException("Received an empty keyId from KMS");
        }
        if (!awsKmsIdentifier.equals(decryptResponseKeyId)) {
            throw new IllegalStateException("Received an invalid response from KMS Decrypt call: Unexpected keyId.");
        }
        ByteBuffer plaintextBuffer = decryptResponse.plaintext().asByteBuffer();
        if (plaintextBuffer.limit() != algorithm.getDataKeyLength()) {
            throw new IllegalStateException("Received an unexpected number of bytes from KMS");
        }
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        plaintextBuffer.get(rawKey);
        return new DataKey<AwsKmsMrkAwareMasterKey>(new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo()), edk.getEncryptedDataKey(), edk.getProviderInformation(), masterKey);
    }

    static boolean filterEncryptedDataKeys(String providerId, String awsKmsIdentifier_, EncryptedDataKey edk) {
        String edkKeyId = new String(edk.getProviderInformation(), StandardCharsets.UTF_8);
        AwsKmsCmkArnInfo providerArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(edkKeyId);
        if (providerArnInfo == null || !"key".equals(providerArnInfo.getResourceType())) {
            throw new IllegalStateException("Invalid provider info in message.");
        }
        return edk.getProviderId().equals(providerId) && AwsKmsCmkArnInfo.awsKmsArnMatchForDecrypt(awsKmsIdentifier_, edkKeyId);
    }
}

