/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListDirectoryBucketsResponse;

public class ListDirectoryBucketsIterable
implements SdkIterable<ListDirectoryBucketsResponse> {
    private final S3Client client;
    private final ListDirectoryBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDirectoryBucketsIterable(S3Client client, ListDirectoryBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDirectoryBucketsResponseFetcher();
    }

    public Iterator<ListDirectoryBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Bucket> buckets() {
        Function<ListDirectoryBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.buckets() != null) {
                return response.buckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDirectoryBucketsResponseFetcher
    implements SyncPageFetcher<ListDirectoryBucketsResponse> {
        private ListDirectoryBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoryBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public ListDirectoryBucketsResponse nextPage(ListDirectoryBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoryBucketsIterable.this.client.listDirectoryBuckets(ListDirectoryBucketsIterable.this.firstRequest);
            }
            return ListDirectoryBucketsIterable.this.client.listDirectoryBuckets((ListDirectoryBucketsRequest)((Object)ListDirectoryBucketsIterable.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

