/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.autoupdate.services.MessageValidator;

public class MessageMultiValidator {
    private final List<MessageValidator> validators;

    public MessageMultiValidator(List<MessageValidator> list) {
        this.validators = list;
    }

    public MessageMultiValidator(MessageValidator ... messageValidatorArray) {
        this.validators = Arrays.asList(messageValidatorArray);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.validators.stream().forEach(messageValidator -> messageValidator.update(byArray, n, n2));
    }

    public void update(byte[] byArray) {
        this.validators.stream().forEach(messageValidator -> messageValidator.update(byArray));
    }

    public void update(byte by) {
        this.validators.stream().forEach(messageValidator -> messageValidator.update(by));
    }

    public void reset() {
        this.validators.stream().forEach(messageValidator -> messageValidator.reset());
    }

    public boolean isValid() {
        return this.validators.stream().map(messageValidator -> messageValidator.isValid()).reduce(Boolean::logicalAnd).orElse(true);
    }

    public Collection<MessageValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }
}

