/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results;

import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public abstract class CCTNode
implements TreeNode {
    private boolean filtered;

    public abstract CCTNode getChild(int var1);

    public abstract CCTNode[] getChildren();

    public abstract int getIndexOfChild(Object var1);

    public abstract int getNChildren();

    @Override
    public abstract CCTNode getParent();

    public CCTNode createFilteredNode() {
        return null;
    }

    protected void setFilteredNode() {
        this.filtered = true;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void merge(CCTNode node) {
    }

    public Enumeration<CCTNode> children() {
        int _childrenCount;
        final CCTNode[] _children = this.getChildren();
        int n = _childrenCount = _children == null ? 0 : _children.length;
        if (_childrenCount == 0) {
            return Collections.emptyEnumeration();
        }
        return new Enumeration<CCTNode>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < _childrenCount;
            }

            @Override
            public CCTNode nextElement() {
                return _children[this.index++];
            }
        };
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getIndexOfChild(node);
    }

    @Override
    public int getChildCount() {
        return this.getNChildren();
    }

    @Override
    public TreeNode getChildAt(int index) {
        return this.getChild(index);
    }

    public static interface DoNotSortChildren {
    }

    public static interface AlwaysLast
    extends FixedPosition {
    }

    public static interface AlwaysFirst
    extends FixedPosition {
    }

    public static interface FixedPosition {
    }
}

