--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)

procedure first_prep is -- main program setup
	--rcd : string(1..80);
	linestr: string(1..9);
	last,last2: natural;
	hiResDesired: boolean := false; --default
begin

---------- prep transient sounds ----------------------------------------

	snd4ada_hpp.initSnds;

	laser := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/laser-gun2.wav"),90);

	stone := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/concrete.wav"),99);

	xport := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/sci-fi2.wav"),80);

	wormx := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/worm8s2.wav"),80);

	kick := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/soccer-kick.wav"),99);

	beachkick := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/beachZpm.wav"),99);

	qport := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/quick_portal2.wav"),90);

	shriek := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/medusa.wav"),99);

	kwush := snd4ada_hpp.initSnd( --9
		Interfaces.C.Strings.New_String("data/4sec_Kawoosh2.wav"),90);

------- now for the soundLoops --------------------------------------


	chatter := snd4ada_hpp.initLoop(  --10
		Interfaces.C.Strings.New_String("data/chimp-chatter-loop2.wav"),5.01,80);

	kbub := snd4ada_hpp.initLoop(  --11
		Interfaces.C.Strings.New_String("data/longlava.wav"), 10.00,90); --stargate


	swimsplash := snd4ada_hpp.initLoop(  --12(L)
		Interfaces.C.Strings.New_String("data/swimLoop3.wav"), 5.10,90);

	treadsplash := snd4ada_hpp.initLoop(  --13
		Interfaces.C.Strings.New_String("data/treadsplash.wav"), 5.48, 90);

	water := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/water2.wav"), 7.80,70);
		--Interfaces.C.Strings.New_String("data/water.wav"), 10.30,70);

	lava := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/bubble.wav"), 13.30,70);

	hum := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/hum2.wav"), 10.70,90);

	beach := snd4ada_hpp.initLoop(  --17(p)
		Interfaces.C.Strings.New_String("data/beach00.wav"), 63.09,99);

	falls := snd4ada_hpp.initLoop( --level 1
		Interfaces.C.Strings.New_String("data/falls2.wav"), 21.13,90);

	dark := snd4ada_hpp.initLoop( -- level 2
		Interfaces.C.Strings.New_String("data/dark-metal-electronic-loop2.wav"), 48.10,90);

	gothic := snd4ada_hpp.initLoop( -- level 3
		Interfaces.C.Strings.New_String("data/sports_card_loop.wav"),77.00,80); --more like "dark"
		--Interfaces.C.Strings.New_String("data/gdTrance.wav"),27.48,80); --in your face
		--Interfaces.C.Strings.New_String("data/Opium-Loop2.wav"), 14.41,90); --more subtle

	neptune := snd4ada_hpp.initLoop( -- level 4
		Interfaces.C.Strings.New_String("data/portals-to-neptune_loop2.wav"), 29.54,90);

	choir := snd4ada_hpp.initLoop(  -- level 5
		Interfaces.C.Strings.New_String("data/briefChurchChoir2.wav"), 10.82,90);

	if 
		laser<0 or stone<0 or xport<0 or wormx<0 or kick<0 
		or beachkick<0 or qport<0 or shriek<0 or kwush<0 or chatter<0 
		or kbub<0 or swimsplash<0 or treadsplash<0 or water<0 or lava<0 
		or hum<0 or beach<0 or falls<0 or dark<0 or gothic<0 
		or neptune<0 or choir<0 
	then
		put_line("snd4ada_hpp initializer error !");
		raise program_error;
	end if;



	-- assume level=0 => beach prologue...


	-- set default starting level, which will be overridden if
	-- there is a command line parm, or a non-empty restore file:
	level:= 0;

	if ada.directories.Exists(resfile) then 
	-- takes precedence over defaults
		put_line("Resume file found");
		text_io.open(tfile, in_file, resfile);
			linestr:=(others=>' ');
		text_io.get_line(tfile,linestr,last);
		myint_io.get(linestr(1..last),dod,last2); --30oct19
		myassert( dod>=1, 1012 );  
		myassert( dod<=5, 1013 );

		for i in 1..mxlev loop
			--myint_io.get(tfile,good); FAILS on DOS file
			linestr:=(others=>' ');
			text_io.get_line(tfile,linestr,last);
			myint_io.get(linestr(1..last),good,last2); --30oct19
			myassert( (good=0) or (good=1), 1014 );
			if (good=1) then
				solved(i):=true;
			else
				solved(i):=false;
			end if;
		end loop;
		text_io.close(tfile);
	else
		put_line("No resume file found");
	end if;


-- insert here attempt to read "settings.txt" file
	if ada.directories.Exists(setfile) then 
		put("settings file found...");

		declare
			xfspd, xmslu, xkslu, xgslu, xjslu: float;
		begin

			text_io.open(tfile, in_file, setfile);

			text_io.get_line(tfile,linestr,last); --handles DOSfmt too!
			myfloat_io.get(linestr(1..last),xfspd,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xmslu,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xkslu,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xgslu,last2);

			text_io.get_line(tfile,linestr,last);
			myfloat_io.get(linestr(1..last),xjslu,last2);

			text_io.close(tfile);

			fspd:=xfspd;
			mslu:=xmslu;
			kslu:=xkslu;
			gslu:=xgslu;
			jslu:=xjslu;
			put_line("and used.");

		 exception
			when others =>
				put_line("...problem reading settings file...using defaults.");
				text_io.close(tfile);

		end; --declare

	else
		put_line("No settings file found; using defaults.");
	end if;





	-- before we call readPuzzle we should set "dod" [DegreeOfDifficulty] 
	-- as 1(easy), 2(medium), 3(hard), 4(harder), 5(advanced)
	-- but only in DEBUG mode, which is indicated by 2 cmdline args:

	dbug:=false;
	bkgd:=0;

	--debug mode only:
   if Ada.Command_Line.Argument_Count = 2 then 

		-- DEBUG-MODE: we ignore any resume file values:
		for i in 1..mxlev loop
			solved(i):=false; -- 9mar18
		end loop;
		dod:=1;
		level:=0;
		solved(0):=true;
		solved(5):=false;


	--  First flag: dflg in {-4..+5}:
	--  1..5 => level of difficulty (puzzles)
	--  0=> skip flyover,  
	-- -1=>dbug mode adobe
	-- -2=>dbug mode wood
	-- -3=>dbug mode brick
	-- -4=>dbug mode granite 
	--
	-- Second flag: bkgd or DPI in {-2..+4} ONLY if 1st flag=0
	-- -2=>allowHiDpi, -1=>forceLowDpi
	-- [ 0..4 => skybox#, 0=>sunny ... 4=>night ]
	--
	-- EG1: normal debug beach day(sky0):  "adagate_gnu 0 0"
	-- EG2: normal debug beach night(sky4):  "adagate_gnu 0 4"
	-- EG3: normal debug brick:  "adagate_gnu -3 0"
	-- EG4: debug @ LoDpi: "adagate_osx 0 -1"
	-- EG4: debug @ HiDpi: "adagate_osx 0 -2"
  
  		levdebug:=0;
     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--dod level
       bstr : string := Ada.Command_Line.Argument(2);--bkgd
		 dflg : integer;
     begin
       myint_io.get(dstr,dflg,lst); -- overrides both previous, default
       myint_io.get(bstr,bkgd,lst); -- overrides both previous, default

		 myassert( dflg >= -4, 771 );
		 myassert( dflg <= +5, 772 );

		 myassert( bkgd >= -2, 773 );
		 myassert( bkgd <= +4, 774 );


		if bkgd=-2 and dflg=0 then --debug; allow hiDpi
			hiResDesired:=true;
			dbug:=true;
			skipflyover:=true;
			bkgd:=0;
			put_line("debug @ HiRes");

		elsif bkgd=-1 and dflg=0 then --debug; force loDpi
			hiResDesired:=false;
			dbug:=true;
			skipflyover:=true;
			bkgd:=0;
			put_line("debug @ LoRes");

		elsif dflg<0 and dflg>-5 then --debug; jump to a dungeon
			levdebug:=-dflg;
			for i in 1..4 loop solved(i):=false; end loop;
			dbug:=true;
			skipflyover:=true;
			bkgd:=0;
			put_line("debug Lev "&integer'image(levdebug));

		elsif dflg=0 then -- debug using indicated background
		 	skipflyover:=true; --skip flyover
			dbug:=true;
			dod:=1;
			myassert( 0<=bkgd, 551 );
			myassert( bkgd<=4, 552 );
			put_line("debug w/bkgd="&integer'image(bkgd));

		elsif dflg<=5 then -- use indicated difficulty
		 	skipflyover:=true; --skip flyover
			dbug:=true;
			dod:=dflg;
			--bkgd:=0; use indicated sky bkgd

		else
			put_line("invalid DOD value...ignoring CmdLineParms");
		end if;

		 exception
			when others =>
				put_line("...2 integers were expected...");
				put_line("  3 x => debug @ difficulty LOD = 3");
				put_line(" -3 0 => debug level 3");
				put_line("  0 2 => debug using skybox2");
				raise;

     end; --declare
  

	--ONE CmdLineArg => hiResDesired flag (as of 1dec19):
   elsif Ada.Command_Line.Argument_Count = 1 then


		--iflg in {0,1}, 1=>HiDpi; 0=>forceLoDpi
     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--level
		 iflg : integer;
     begin
       myint_io.get(dstr,iflg,lst); -- overrides both previous, default
		 if iflg>0 then
		 	hiResDesired:=true;
		 end if;

		 exception
			when others =>
				put_line("...a single integer was expected...1=>HiRes");
				raise;

     end; --declare
   

   elsif Ada.Command_Line.Argument_Count > 2 then --TOO MANY ARGS...ABORT

	--DOD in {-4..+5}:
	--  0=> skip flyover,  
	-- -1=>dbug mode adobe
	-- -2=>dbug mode wood
	-- -3=>dbug mode brick
	-- -4=>dbug mode granite 
	--
	--bkgd in {0..4} [ 4=>night ]
 
		new_line;
     	put_line("Expect at most 2 command line parms:");
		put_line("DoD  in {-4...+5} (-4=>dbgGranite, 0=>skipFlyover)");
		put_line("beachBkgd in {0..4}");

     raise program_error;

   end if;


	if dbug then

		if ada.directories.Exists(resfile) then
			--delete it 4apr18
			ada.directories.Delete_File(resfile);
		end if;

	else
		put_line(" Puzzle Difficulty = " & integer'image(dod) );
	end if;



	InitGlfw("AdaGate",hiResDesired);


	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	-- from the literature it seems I might not have to
	-- call this explicitly because the first texture
	-- unit is the active texture unit, by default.
	-- And I have no multi-texturing needs yet,
	-- like a tarnish on top of an existing texture.
	-- Update: see adagate-drawisland-rustyzpm.adb
	-- where I need 5 active texture units in order to
	-- draw rusty metal.
	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)


	glgenbuffers(1, normbuff'address);
	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);




	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );


	-- 6nov14  allow antialiasing if supported:
	glEnable(GL_MULTISAMPLE); -- default setting anyway!



	--minimal error test
	nerr:=dumpGLerrorQueue("first_prep_2");



	level:=0;
	solved(0):=true;
	solved(5):=false;




end first_prep;




