
--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;
with ada.finalization;
with unchecked_deallocation;


generic
	n : integer;

package circsurfobj is 
-- for circular body of reflective water 
-- truncated rectangular gridding


type circsurf is tagged private;


procedure setRound( cs: circsurf;  xc,zc,rr : float );

procedure draw( cs: circsurf;  vertbuff : gl.gluint );


private

--n : constant integer := 100; -- 400 made new macbook jerky on beach
fn : constant float := float(n);
nsq : constant integer := n*n;
nvert : constant integer := 18*nsq; -- # vertices if region were square
nv : integer := 0; --actual # vertices since region is circular

type varray is array(1..nvert) of float;
type vap is access varray;


type circsurf is new ada.finalization.controlled with record
vert: vap;
end record;


procedure initialize( cs: in out circsurf );
procedure finalize( cs: in out circsurf );



end circsurfobj;
