#version 330 core

//
// Opacity that was determined purely from LOS-slant-range
// thru the water failed during my flyover cutscene.
//
// I am now leaning toward more simplistic opacity
// algorithm based on AOI.
//
// Also, I was unhappy with formal fresnel formula.  A
// simplified version seems better to me.
//

in float depth; // depth>=0 (input from vert.shader)

in float wlev;

in vec2 waveDirection;
in vec3 position;
in vec3 waveNormal;

in vec4 aPos;
in vec4 eyeSpacePos;



out vec4 color;


uniform vec3 eyePos; // virtual (pos wrt island sand)

uniform samplerCube envMap;

uniform int level;



////////////// begin insert /////////////////

uniform float mytime;


float fizz( vec2 p, vec2 t ) {

	float time = mytime*2.0;
	float phase = 2.0*t.x + 2.0*t.y; //definite improvement...phase-offset

	float col = 0.0;
	float c=0.0;
	c+=cos(p.x*80.0+time*3.0)*cos(p.y*60.0+cos(time*p.x*0.6+time*2.0)+time*3.0);
	c+=cos(p.y*70.0+time*1.2)*cos(p.x*70.0+cos(time*p.y*0.4+time*1.2)+time*1.5);
	c+=cos(p.y*90.0+time*2.0)*cos(p.y*50.0+cos(time*p.x*0.3+time*1.2)+time*2.5);
	col = cos(c+time+phase);

	col = 0.25*col + 0.75;

	return col;

} // end fizz


const float maxamp=0.04; //  0.03 ~= sum_ampl. of waterwaves

////////////// end insert /////////////////









const float fStart=0.0;
const float fEnd=16.0; // normal fog
const float sEnd= 8.0; // heavy fog
const float xEnd= 4.0; // extreme fog

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white/gray
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //normal dark/gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brownish soot
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purplish fog

//const int level=0;

float getFogFactor(float rng)
{
	float fResult = 0.0;

	if(level==3) // extreme fog
		fResult = (xEnd-rng)/(xEnd-fStart);

	else if(level==2) // heavy fog
		fResult = (sEnd-rng)/(sEnd-fStart);

	else if(level==1) // normal fog
		fResult = (fEnd-rng)/(fEnd-fStart);
	else
		fResult=1.0;
	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}












void main(){

	vec2 uv = vec2( position.x, position.z );
	float radius = length(uv); // r1=5, lagoonRad=3
	vec2 UV = fract( uv ); // now, both in [0..1)


	// set variable threshold for deep water foam:
	float dfoam = wlev + 2.0*maxamp; // deep water foam above this Ypos
	//float bfoam = wlev + maxamp/10.0; // breaker foam
	float bfoam = wlev;

	vec3 wavdir = vec3( waveDirection.x, 0, waveDirection.y );
	float dprod = dot( waveNormal, wavdir ); // negative dprod => back of wave

   vec3 eyeraw = (position-eyePos);
   vec3 eye = normalize(eyeraw);
   vec3 r = reflect(eye, waveNormal);
  	vec4 precolor = texture(envMap, r);


///////// opacity below here /////////////////////////////////////////
// Note:  only for ocean (radius in [7..20]):
//
// @r=20 (max radius) Ysand=-1.43, depth=1.04
// @r=10              Ysand=-0.63, depth=0.24
// @r= 7              Ysand=-0.39, depth=0.00, MSL=-0.39
//

	// new Opacity strategy base upon AngleOfIncidence [AOI]
	const float halfpi = 2.0*atan(1.0,1.0);
	const float aoimax=halfpi;
	const float opmax=0.0; // minOpacity

	const float aoimin=aoimax*0.05; // 4.5 deg
	const float opmin = 0.99;  // maxOpacity

	// AOI versus water normal vector
	float Naoi = halfpi - acos( dot(waveNormal, -eye) );
	float tto = (Naoi-aoimin)/(aoimax-aoimin);
	float opac = opmin + tto*(opmax-opmin);

	// finally, ensure transparent shallows
	if( depth<0.1 ) opac *= 10.0*depth;

	opac = clamp(opac, 0.0, 1.0);

///////// opacity above here /////////////////////////////////////////


////////// hue adjustment below ////////////////////////////////////////

	// fine hue adjustment to add green near shallows...

	// weight=1.0; => all blue  ...  weight=0.0; => all green
	float weight = 0.5 + radius/20; // all blue beyond rad=10
	if( weight<0.85 ) weight=0.85;
	if ( weight > 1.0 ) weight = 1.0;
	vec4 green=vec4(0.4, 0.9, 0.4, 1.0);
	vec4 watercolor = mix( green, precolor, weight ); // wt = amt of precolor

	color = watercolor;
	color.rgb *= 0.8; // subdue the somewhat oversaturated colors

	// increase opacity in lagoon to enhance apparent depth:
	//float tt = max(0, (radius-3.5)/3.5);
	//if( radius<7 ) opac = (1-tt)*0.95 + tt*opac;
	float tt = max(0, (radius-4.8)/(6.8-4.8));
	if( radius<6.8 ) opac = (1-tt)*0.95 + tt*opac;


	// finally, set opacity curve: //////////////////////////
  	color.a = opac;



// define foam below here ///////////////////////////////////////////////////
if( radius > 6 ) // rmax=20, r2=7@ surfline, r1=5@ maxht, lagoonRad=3..3.5
{

	if( depth <= 0.0002 ) // remember, depth might be negative
	{  
		// coarser shoreline foam
		float fuv = fizz(UV*2.0, uv); // 1.0 makes bigger bubbles
		float alpha=0.9;
		vec4 fcolor = vec4( vec3( fuv ), alpha );
		if( fuv>0.9 ) color = fcolor;
	}

	
	else

	if( 
		(position.y>dfoam)  // deep water foam
			||  
		((dprod>0.02) && (position.y>bfoam)) // breakers
	)
	{  
		// finer wave foam
		float fuv = fizz(UV*4.0, uv); // 4.0 makes finer bubbles
		float alpha=0.9;
		vec4 fcolor = vec4( vec3(fuv), alpha ); // foam color
		if( fuv > 0.9 ) color = fcolor;
	}

} // end if radius>6




//////////////// begin insert /////////////////////////////////////////////
	if( level>0 ) {
		const float yc=0.0;
		float dist = exp(-0.9*abs(aPos.y-yc)) * length( eyeSpacePos );
		color = mix(color, vFogColor, getFogFactor(dist)); //lighterFog
		//color = mix(color, vDfogColor, getFogFactor(dist)); //darkerFog
	}
//////////////// end insert /////////////////////////////////////////////



}

// this version has foam and AOI-related opacity;
// plus depth-related greenish color
// plus wave-peak foam

//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

