#version 330 core

in vec2 UV;
in vec4 aPos;
in vec4 eyeSpacePos;

out vec4 color;

uniform sampler2D myTextureSampler;
uniform int level; // 0=>noFog, 1=>darkFog, 2=>whiteFog
uniform int darkness; // 0...4=darkest (bkgd)
const vec4 night = vec4(0.0,0.0,0.0,1.0);






const float fStart=0.0;
const float fEnd=12.0; // normal fog

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal white/gray
const vec4 vDfogColor=vec4(0.7,0.7,0.7,1.0); //normal white/gray


float getFogFactor(float rng)
{

	float fResult = (fEnd-rng)/(fEnd-fStart);
	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}



// this is primarily for sandy island atoll


void main(){
	color = texture( myTextureSampler, UV).rgba;
	if( color.a < 0.1 ) discard;

	float df=0;
	if( darkness < 1 ) df=0.2;
	else if( darkness==1 ) df=0.4;
	else if( darkness==2 ) df=0.5;
	else if( darkness==3 ) df=0.6;
	else if( darkness>3 ) df=0.7;
	float asave=color.a;
	color = mix(color, night, df);

	if(level>0) {
		const float yc=-1.0;
		float dist = exp(-1.0*abs(aPos.y-yc)) * length( eyeSpacePos );
		color = mix(color, vFogColor, getFogFactor(dist));
	}

	color.a = asave;

}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

