#version 330 core

// fragment shader

in vec3 position;    // water pos from vert.shader
in vec3 worldNormal; // water nrm from vert.shader

in vec4 vEyeSpacePos;
in vec4 aPos;

out vec4 color;

uniform vec3 eyePos;

uniform samplerCube envMap;

const float pi = 3.14159;





const float fStart=0.0;
const float fEnd=30.0;

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0);

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}

const float yc=-2.85;




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 ME;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////




void main(){
	float rx = eyePos.x/8;
	float rz = eyePos.z/20;
	float rxz = sqrt( rx*rx + rz*rz );

   vec3 eye = normalize(position-eyePos);
   vec3 r = reflect(eye, worldNormal);

	r.y=r.y*3.0; //adjust reflection depth
	r.x = r.x * 0.8*(1+rxz); //adjust reflection width
	r.x = r.x + eyePos.x/10; //translate reflection
	//note:  reflection accuracy can be checked by setting
	//wave amplitude to zero, and opacity to one.

   color = texture(envMap, r);
   //color.a = 0.7;
   //color.a = 0.3; //18dec15 : show off piranha
	color.a = 0.4; //16jan17

	float dist2 = pow(vEyeSpacePos.x,2) + pow(vEyeSpacePos.z,2);
	float fFogCoord = abs( sqrt(dist2)/vEyeSpacePos.w );
	color = mix(color, vFogColor, getFogFactor(fFogCoord));

	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - ME;
	vec3 cP2 =  port2 - ME;
	vec3 vP0 = aPos.xyz - ME;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}

}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

