#version 330 core

uniform float mytime;
in vec2 UV;

out vec4 fragColor;


#define MAX_ITER 8



void main( void ) {


	vec2 sp = vec2( 2*UV.x-1, 2*UV.y-1 );
	vec2 p = sp*5.0 - vec2(10.0);
	vec2 i = p;
	float c = 1.0;
	
	float inten = .1;

	for (int n = 0; n < MAX_ITER; n++) 
	{
		float t = mytime * (1.0 - (3.0 / float(n+1)));
		i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(t + i.x));
		c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));
	}
	c /= float(MAX_ITER);
	c = 1.5-sqrt(c);
	fragColor = vec4(vec3(c*c*c*c), 999.0) + vec4(0.0, 0.3, 0.5, 1.0);
	fragColor.a = 0.6; // 18dec15 ...show piranha

}

