#version 330 core

uniform float mytime;
uniform vec2 resolution;

#define OCTAVES 5

// Squish and strech the tunnel
#define STRETCH 10.0
#define SQUISH 1.0

const float speed=0.5;

float rand(vec2 n) { 
	return fract(sin(dot(n, vec2(13, 5))) * 43758.5453);
}

float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
	vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return mix(mix(rand(b), rand(b + d.yx), f.x), mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}

float fbm(vec2 n) {
	float total = 0.0, amplitude = 1.0;
	for (int i = 0; i < OCTAVES; i++) {
		total += noise(n) * amplitude;
		n += n;
		amplitude *= 0.5;
	}
	return total;
}

vec3 tex(vec2 pos) {
	const vec3 c1 = vec3(.3,.1,.4);
	const vec3 c2 = vec3(.4,.3,.4);
	const vec3 c3 = vec3(.4,.2,.3);
	const vec3 c4 = vec3(.7,.7,.6);
	const vec3 c5 = vec3(.1);
	const vec3 c6 = vec3(.9);
	vec2 p = pos;
	float q = fbm(p - speed*mytime * -0.1);
	vec2 r = vec2(fbm(p + q + speed*mytime - p.x - p.y), fbm(p + q + speed*mytime));
	vec3 c = mix(c1, c2, fbm(p + r)) + mix(c3, c4, r.x) - mix(c5, c6, r.y);
	return c;
}

in vec2 UV;
out vec4 fragColor;
void main(void) {
    const float PI = 3.14159265358979;
    vec2 p = (UV.xy - vec2(.5)) * vec2(resolution.x/resolution.y, 1.);

    float r = length(p);
    float a = atan(p.y, p.x);

    vec2 uv = vec2(sin(a), cos(a))/pow(r, 1.+.5*sin(mytime));
    
    vec3 col = tex(uv);
    fragColor = vec4(col*length(p),0.9);
}

