#version 330 core

uniform samplerCube CubeMap;

uniform int level;  // foglevel (here just off=0 or on>0)

in vec3 texcoord;

in vec4 aPos;

out vec4 fragColor;



const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white/gray
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //normal white/gray


void main()
{
   fragColor = texture(CubeMap, texcoord);

	if( level>0 ) {
		float angl = atan( aPos.y, length(aPos.xz) );
		clamp(angl, 0.0, 1.0 ); // 1 radian =~ 57deg
		float dist = 1.0 - angl;
		clamp(dist, 0.0, 1.0);
		fragColor = mix(fragColor, vFogColor, dist);//whiterFog
		//fragColor = mix(fragColor, vDfogColor, dist);//darkerFog
	}

}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

