#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
out vec4 aPos;
out vec4 eyeSpacePos;


uniform mat4 MVP;
uniform mat4 MV;

uniform vec3 wPos;
uniform vec3 wRad;

// this variation [rocko] of rock-vertex-shader [rocky] 
// is intended for a lean-to shelter, which is a 
// flat [roof2] rectangular texture at an
// Oblique angle...40degrees from horizontal
// perhaps leaning on tree or rock.

void main(){

	aPos = vec4( vertexPos, 1.0 );
	eyeSpacePos = MV*aPos;


	float hrad2= ( wRad.x*wRad.x + wRad.z*wRad.z );
	float hrad = sqrt( hrad2 );

	vec3 pos = vertexPos;

	pos.x *= wRad.x;
	pos.y *= wRad.y;
	pos.z *= wRad.z;
	// we assume original setup with unitary radii

	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z; 
	// we assume original setup @ origin


	float 
		rx=(pos.x-wPos.x), 
		ry=(pos.y-wPos.y), 
		rz=(pos.z-wPos.z);

	float rxy = sqrt( hrad2 - ( rx*rx+ry*ry ) );
	float ryz = sqrt( hrad2 - ( ry*ry+rz*rz ) );


	// rounded corners
	pos.x = ryz/wRad.x*rx + wPos.x;
	pos.z = rxy/wRad.z*rz + wPos.z;


	rx=pos.x-wPos.x;
	rz=pos.z-wPos.z;

	pos.y += 0.4*rx;
	if( rx>0 ) pos.y -= 3*rz*rz*rx; //high corners sagging



	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

