
separate (adagate.drawroom)

procedure drawLev3 is
begin

----------- fireball begin --------------------------------------------


	glUseProgram(pidfire01); --====================================
	glUniform1i(samp01, 0);
	glUniform1f(opac01, 0.9);

	glUniform1f(irad01, glfloat(fballrad));

	--window-discard:
	glUniform1i(side01, glint(numport) );
	--glUniform1i(fbunifside, 0 ); --13apr18

	glUniform3f(ieye01, glfloat(xeye),glfloat(yeye),glfloat(zeye));

	glUniform3f(lprt01,glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1)); 
	glUniform3f(rprt01,glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2)); 

	glBindTexture(GL_TEXTURE_2D, ball_texid);


-- define trajectory of fireball before the following code to move it
-- want circum = 1.0 = 2piR => R=1/twopi
-- Appx:  z=2, y=rad, x in (-8..+8), @ 2 unit per second => 8 sec per dir
-- make 200 time slices, 100 each way
--

	-- begin fireball roll --------------------------------------
	BMVP := MVP;

-----------------------------------------------------------------------
	--getFireBallPos(xxfb,yyfb,zzfb);
-----------------------------------------------------------------------

	axis:=zaxis;

	bmm:=identity;
	translate(bmm, -xxfb,-yyfb,-zzfb ); --Xlate to origin
	barangle := -twopi*xxfb/(twopi*fballrad) *rad2deg;
	degRotate(bmm, barangle, axis(1), axis(2), axis(3) ); --rotate
	translate(bmm, xxfb,yyfb,zzfb ); --Xlate back
	bmvp := bmm;
	matXmat( bmvp, viewMatrix );
	matXmat( bmvp, projMatrix );


	-- we have to register bmvp AFTER it is redefined:
	gluniformmatrix4fv( imvp01, 1, gl_false, BMVP(1,1)'address );

	glUniform3f(icen01,  --send current centroid to shaders
		glfloat(xxfb),glfloat(yyfb),glfloat(zzfb) );

	glUniform1f(time01, glfloat(currenttime));

	fireballobj.draw(fireball,vertbuff,elembuff);

	if sqrt( sqr(xxfb-xme)+sqr(yyfb-yme)+sqr(zzfb-zme) ) < fballrad+margin then
		fireballdead:=true;
	end if;

	-- end fireball roll ----------------------------------------






------------------ turtle begin ---------------------------------------

	glUseProgram( pidpgm17 ); --===================================

	--portal-exterior-discard uniforms
	glUniform1i(side17, glint(numport));

	glUniform3f(ieye17, glfloat(xeye),glfloat(yeye),glfloat(zeye));


	glUniform3f(lprt17,glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1)); 
	glUniform3f(rprt17,glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2)); 

	gluniformmatrix4fv( imvp17, 1, gl_false, mvp(1,1)'address );
	gluniform1i(samp17,0);

	-- Fog flag
	gluniform1i(flev17, 2 );
	gluniform1i(fcol17, 2 );

	-- Lighting Effects uniforms:

	gluniform1i(flag17, 1); -- 1=> lightingEffects;  0=> none


	-- color
	gluniform3f( lcol17, 
		254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange


	--NOTE: for turtle, we need top well lit from 3 light positions
	-- we neglect the changing ModelMatrix for turtle as she moves!
	-- Anyway, the ambient is accentuated for looks.
	gluniform3f(posa17,
		glfloat(xpcen-xprad/2.0),
		glfloat(2.0),glfloat(zpcen-zprad/2.0) );
	gluniform3f(posb17,
		glfloat(xpcen+xprad/2.0),
		glfloat(2.0),glfloat(zpcen+zprad/2.0) );
	gluniform3f(posc17,
		glfloat(xpcen          ),glfloat(2.0),glfloat(zpcen) );
	--1 light source @ fireball center:
	--gluniform3f(posc17,glfloat(xxfb),glfloat(yyfb),glfloat(zzfb));

	-- color of light
	gluniform3f( lcol17, 
		254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange




	-- ferry-capable lava turtle
	if not insidePortal then
		updateFerryPos(currentTime,
			xtur,ytur,ztur,angltur, xturh,yturh,zturh,anglturh );
	end if;


	-- body positioning, orientation via uniforms (turtle.vs)
	gluniform3f(icen17,glfloat(xtur),glfloat(ytur),glfloat(ztur));
	glUniform1f(angl17,glfloat(angltur) );


	glbindtexture(gl_texture_2d, turtle_texid);
	turtleobj.ldraw(turtle,vertbuff,uvbuff,normbuff,elembuff);

	-- head positioning, orientation via uniforms 
	gluniform3f(icen17,glfloat(xturh),glfloat(yturh),glfloat(zturh));
	glUniform1f( angl17, glfloat(anglturh) );

	glbindtexture(gl_texture_2d, turhead_texid);
	turtleobj.ldraw(turhead,vertbuff,uvbuff,normbuff,elembuff);


------------------ turtle end ---------------------------------------


---------------- begin lava pool --------------------------------------



	-- fancy fragshader draws lava in level 3
	glUseProgram( pidpool15 ); --=====================================

	glUniform1i(side15, glint(numport) );

	glUniform3f(ieye15, glfloat(xeye),glfloat(yeye),glfloat(zeye));


	glUniform3f(lprt15,glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1)); 
	glUniform3f(rprt15,glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2)); 

	gluniformmatrix4fv( imvp15, 1, gl_false, mvp(1,1)'address );

	gluniform2f(ires15, glfloat(winwidth), glfloat(winheight) );
	gluniform1f(time15, glfloat(currentTime) );

	gluniform3f(icen15,glfloat(xpcen),glfloat(ypcen),glfloat(zpcen));
	gluniform3f(irad15,glfloat(xprad),glfloat(yprad),glfloat(zprad));
	gluniform1f(wlev15, glfloat(waterlevel) );

	lavasurf.draw(fso,vertbuff);



	--DaliClock
	glUseProgram( pidpic06 ); --==============================

	glUniform1i(side06, glint(numport) );

	glUniform3f(ieye06, glfloat(xeye),glfloat(yeye),glfloat(zeye));

	glUniform3f(lprt06,glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1)); 
	--center p1 (left)

	glUniform3f(rprt06,glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2)); 
	--center p2 (right)

	gluniformmatrix4fv( imvp06, 1, gl_false, mvp(1,1)'address );
	gluniform1f(time06, glfloat(-currentTime) );
	gluniform2f(icen06, glfloat(x3picx), glfloat(x3picy) );
	gluniform2f(irad06, glfloat(x3picws/2.0), glfloat(x3pichs/2.0) );
	gluniform2f(ires06, glfloat(winwidth), glfloat(winheight) );
	rectxobj.draw(pox,vertbuff,elembuff);




	--redPlanet
	glUseProgram( pidpic07 ); --==================================

	glUniform1i(side07, glint(numport) );

	glUniform3f(ieye07, glfloat(xeye),glfloat(yeye),glfloat(zeye));

	glUniform3f(lprt07,glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1)); 
	glUniform3f(rprt07,glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2)); 

	gluniformmatrix4fv( imvp07, 1, gl_false, mvp(1,1)'address );
	gluniform1f(time07, glfloat(currentTime) );
	gluniform2f(icen07, glfloat(x3picx), glfloat(x3picy) );
	gluniform2f(irad07, glfloat(x3picwb/2.0), glfloat(x3pichb/2.0) );
	gluniform2f(ires07, glfloat(winwidth), glfloat(winheight) );
	rectxobj.draw(pox2,vertbuff,elembuff);



end drawLev3;

