
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;


package wxtreeobj is
-- Winged implementation for X-shaped trees:
-- each of the 4 wings of the X is drawn separately
-- in sorted order from furthest to nearest.
-- This regimen precludes having to disable depth test
-- or use other tricks to draw a reasonable looking trees.
-- One still must draw individual trees in sorted order
-- from furthest to nearest, as usual.

-- maps texture coordinates UV to cover the full extent of two
-- perpendicular flat rectangles...the whole *.png file is visible


type treeangle is tagged private;

procedure setrect( rect: treeangle );

-- xe=xeye-xtree
-- ze=zeye-ztree
procedure draw( 
	rect: treeangle; 
	vertbuff, uvbuff, elembuff : gluint;
	xe,ze: float
	);



private

-- Z- : 1..24
-- Z+ : 25..48
-- X- : 49..72
-- X+ : 73..96
nvert : constant integer := 96; --48;
nuv   : constant integer := 64; --32;
nelm  : constant integer := 48; --24;

type varray is array(1..nvert/4) of float;
type vap is access varray;

type tarray is array(1..nuv/4) of float;
type tap is access tarray;

type earray is array(1..nelm/4) of glushort;
type eap is access earray;

type treeangle is new ada.finalization.controlled with record
	vertzm,vertzp,vertxm,vertxp : vap;
	txuvzm,txuvzp,txuvxm,txuvxp : tap;
	elemzm,elemzp,elemxm,elemxp : eap;
end record;


procedure initialize(rect: in out treeangle);
procedure finalize(rect: in out treeangle);

end wxtreeobj;

