#version 330 core

layout(location = 0) in vec3 vertexPos;

// note that the default interpolation qualifier is smooth,
// where the choices are a) flat, b) noperspective, c) smooth
// EG:  smooth out vec3 waveNormal

out vec3 position;
out vec3 waveNormal;
out vec2 waveDirection;

////// new insert:
out vec4 aPos;
/////// end new insert


uniform mat4 MVP;

/////////////////////////////// new 21dec14 begin
out float depth;
out float wlev;

uniform float hmax;
uniform float r1;
uniform float r2;
/////////////////////////////// new 21dec14 end

uniform float waterlevel;
uniform float mytime;

uniform vec3 wPos;
uniform vec3 wRad;

const float pi = 3.141592654;
const float twopi = 2.0*pi;



// recall r2 = 7 = radius where sand meets ocean
// recall r1 = 5 = radius @ max height for atoll
// circular waves begin to diminish here:
const float channelRadius = 7.0;

// ...and disappear by here:
const float lagoonRadius = 3.5;


//////////////////////// begin high circular wave insert //////////////////////

const float cspeed=0.3;
const float cAmp=0.02; // CAUTION:  (>.03) => deep sea artifacts

float f(float r) {
	float a = -pi * (mytime*cspeed + r);
	return 0.5 - 0.5*sin(a) - 0.5*sin(2.0*a)/2 - 0.5*sin(3.0*a)/3.0 - 0.5*sin(4.0*a)/4.0;
}

float F(float x, float z) {
	float r = sqrt(x*x+z*z);

		// this looks pretty good!
		float diminish = (r-lagoonRadius)/(channelRadius-lagoonRadius);
		float fact = clamp(diminish,0.5,1.0);

	return fact* cAmp*f(r);
}

float dFdx(float x, float z) {
	float r=sqrt(x*x+z*z);

		// this looks pretty good!
		float diminish = (r-lagoonRadius)/(channelRadius-lagoonRadius);
		float fact = clamp(diminish,0.5,1.0);

	float a = -pi * (mytime*cspeed + r);
	float drdx = x/(r+1.0); // approx
	float dFdf = cAmp;
	float dfda = -0.5*cos(a)-0.5*cos(2.0*a)-0.5*cos(3.0*a)-0.5*cos(4.0*a);
	float dadr = -pi;
	return fact* dFdf*dfda*dadr*drdx;
}

float dFdz(float x, float z) {
	float r=sqrt(x*x+z*z);

		// this looks pretty good!
		float diminish = (r-lagoonRadius)/(channelRadius-lagoonRadius);
		float fact = clamp(diminish,0.5,1.0);

	float a = -pi * (mytime*cspeed + r);
	float drdz = z/(r+1.0); // approx
	float dFdf = cAmp;
	float dfda = -0.5*cos(a)-0.5*cos(2.0*a)-0.5*cos(3.0*a)-0.5*cos(4.0*a);
	float dadr = -pi;
	return fact* dFdf*dfda*dadr*drdz;
}

///////////////////////// end high circular wave insert /////////////////////////





/////////////////////////////////////////////////////////////////////

// WARNING:  this must closely match function in gameutils.adb
// r2 = 7 = radius where sand meets ocean
// r1 = 5 = radius @ max height for atoll
// waterlevel = -0.39
//       hmax = +0.16
//
float sandht( float x, float z ) {
	float ht, htx;
	float r = sqrt( x*x + z*z );
	float slope = hmax/(r1-r2);
	float wid =  pi/8;
	float cen = -pi/4;

	if( r < r1 )  
		ht = -0.9*cos(pi*r/r1) + r/r1*(waterlevel+hmax-0.9);
		// fudge here...for reduced depth @ lagoon center
		// ht = -0.5*cos(pi*r/r1) + r/r1*(waterlevel+hmax-0.5);
	else          
		ht=waterlevel + slope*(r-r2);

	if( r>1 ) 
	{
		float ang = atan(z,x);
		if( abs(ang-cen)<wid ) 
		{
			float tt= abs(ang-cen)/wid;
			htx=waterlevel-0.35;
			if( htx<ht ) 
			{
				ht=(1-tt)*htx + tt*ht;
			}
		}
	}

	return ht;

} // f(0)=-0.9,  f(5)=-0.23=max,  f(10)=-0.63,  f(20)=-1.43=min
//depth(0)=0.51                   d(10)=0.24    d(20)=1.04

/////////////////////////////////////////////////////////////////////



//////////////// begin rect waves insert //////////////////////////////

const int numWaves=4;

const float iamplitude[4] = float[4]( 0.0002, 0.0003, 0.0004, 0.0005 );
const float iwavelength[4]= float[4]( 0.32, 0.56, 0.64, 0.40 );
const float ispeed[4]     = float[4]( 0.14, 0.08, 0.10, 0.16 );

const float idir[4] = float[4]( -pi/3, -pi/6, 13*pi/10, pi/2 );

const float idiry[4] = float[4]( sin(idir[0]), sin(idir[1]), sin(idir[2]), sin(idir[3]) );
const float idirx[4] = float[4]( cos(idir[0]), cos(idir[1]), cos(idir[2]), cos(idir[3]) );


float iwave(int i, float x, float y) {
    float frequency = 2*pi/iwavelength[i];
    float phase = ispeed[i] * frequency;
    float theta = dot( vec2( idirx[i], idiry[i] ), vec2(x, y));
    return iamplitude[i] * sin(theta*frequency+mytime*phase);
}

float iwaveHeight(float x, float y) {
	float height = 0.0;

		for (int i = 0; i < numWaves; ++i)
			 height += iwave(i, x, y);

   return height;
}

float idWavedx(int i, float x, float y) {
    float frequency = 2*pi/iwavelength[i];
    float phase = ispeed[i] * frequency;
    float theta = dot( vec2( idirx[i], idiry[i]), vec2(x, y));
    float A = iamplitude[i] * idirx[i] * frequency;
    return A * cos(theta * frequency + mytime * phase);
}

float idWavedy(int i, float x, float y) {
    float frequency = 2*pi/iwavelength[i];
    float phase = ispeed[i] * frequency;
    float theta = dot( vec2( idirx[i], idiry[i]), vec2(x, y));
    float A = iamplitude[i] * idiry[i] * frequency;
    return A * cos(theta * frequency + mytime * phase);
}

vec3 iwaveNormal(float x, float y) {
    float dx = 0.0;
    float dy = 0.0;


    for (int i = 0; i < numWaves; ++i) {
        dx += idWavedx(i, x, y);
        dy += idWavedy(i, x, y);
    }


	 dx += dFdx(x,y); // addenda for circular waves
	 dy += dFdz(x,y);


    vec3 n = vec3(-dx, 1.0, -dy); //my Y plays roll of Conrod's Z
    return normalize(n);
}



//////////////// end rect waves insert //////////////////////////////







void main(){

	vec4 pos = vec4(vertexPos,1);

	//aPos = pos;

	float radii=sqrt(pos.x*pos.x+pos.z*pos.z);


	//used only for foam on circular waves
	waveDirection=vec2(0,0);

	waveDirection += (-pos.x/radii,-pos.z/radii);

	normalize(waveDirection);

  	pos.y = waterlevel + iwaveHeight(pos.x, pos.z); // "rectangular" waves
	pos.y += F(pos.x, pos.z); // add larger circular waves
  	waveNormal = iwaveNormal(pos.x, pos.z); // both rect+circ waves

   position = pos.xyz/pos.w;
	depth = (pos.y - sandht(pos.x,pos.z));
	wlev = waterlevel;
	aPos = pos;
   gl_Position = MVP * pos;


}

// this version calculates water depth and sends to frag-shader
// so it can adjust opacity according to depth,
// and so it can determine the surf line for foam.

//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

