with gl; use gl;

--This package defines a minimalist sound loop capability
--for Linux using the ubiquitous command line sound player
--"aplay" using ALSA sound that handles WAV sound files.
--
--Short & transient sounds are easily handled using a
--"system" shell background command initiator.
--
--Controlling sound loop files, on the other hand,
--requires the ability to interrupt them at odd times, 
--and the ability to replay them indefinitely.
--
--Those interrupts and replays are herein controlled
--using Ada tasking.



package sndloop is

	task type sndtask is
		entry Start(name: string; dur: gldouble; ch: character);
		entry Stop;
	end sndtask;

end sndloop;

