
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;




with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------
with sdl;  use sdl;
---------------------------

with ada.unchecked_conversion;
with ada.text_io; use ada.text_io;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;

----------------------------------------------------------------


with shader;  use shader;

with mroomobj;
with tunnelobj;
with rectobj;
with pictobj;
with twictobj;
with pict1obj;
with xtreeobj;
with zfishobj;
with ztubeobj;
with rectfineobj;
with rectxobj;
with cyl2obj;
with cylobj;

with circsurfobj;

with cubemapobj;
with itemobj;
with rectsurfobj;
with usboxobj;

with text_io;  use text_io;









package gametypes is



	use gl;
	use matutils;
	use type interfaces.c.c_float;




	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;



	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	fourthpi : constant float  := onepi/4.0;
	eighthpi : constant float  := onepi/8.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;




---------- begin game controller ----------------------------------------

cfgfile : string := "./settings.txt";

Lsens, Rsens, Jsens : float := 1.0; -- paddle sensitivities
gshtl,gshtr,gjmp,
jshtl,jshtr,jbak,jfor,jjmp : glint; -- button maps

gamepad, joystik : boolean; --flags presence of game controllers
jsa : access SDL_JoyStick;

axis_lx, axis_ly, axis_rx, axis_ry : sdl.Sint16;

btn_0, btn_1, btn_2, btn_3,
btn_4, btn_5, btn_6, btn_7, btn_8, btn_9: sdl.Uint8;


---------- end game controller ----------------------------------------



	mousex,mousey : aliased interfaces.c.int;

	state, ileft, iright, good : integer;

	dbug, calledonce, toIsland, FromIsland, dungeonLocal: boolean := false;


	oldTimeKb : float := 0.0;
	mousestate : Uint32;
	deltaT : float;

	speed : constant float := 3.0;
	pauseatlevelchange : boolean := false;
	forwardok : boolean := true;



	vertbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;






-- begin string pointers for getUniformLocation:

	pprad : chars_ptr := new_string("prad"&ascii.nul);
	pport1 : chars_ptr := new_string("port1"&ascii.nul);
	pport2 : chars_ptr := new_string("port2"&ascii.nul);


	phmax : chars_ptr := new_string("hmax"&ascii.nul);
	pr1 : chars_ptr := new_string("r1"&ascii.nul);
	pr2 : chars_ptr := new_string("r2"&ascii.nul);

	pmv : chars_ptr := new_string("MV"&ascii.nul);
	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	ptime : chars_ptr := new_string("time"&ascii.nul);
	presol : chars_ptr := new_string("resolution"&ascii.nul);

	pmytime : chars_ptr := new_string("mytime"&ascii.nul);
	pwaterlevel : chars_ptr := new_string("waterlevel"&ascii.nul);
	pwPos : chars_ptr := new_string("wPos"&ascii.nul);
	pwRad : chars_ptr := new_string("wRad"&ascii.nul);
	pangl : chars_ptr := new_string("angl"&ascii.nul);

	prot  : chars_ptr := new_string("RotSense"&ascii.nul);

	prad  : chars_ptr := new_string("rad"&ascii.nul);
	psvel : chars_ptr := new_string("svel"&ascii.nul);
	pwvel : chars_ptr := new_string("wvel"&ascii.nul);
	pwamp : chars_ptr := new_string("wamp"&ascii.nul);

	--pzrad : chars_ptr := new_string("zrad"&ascii.nul);

	pdark : chars_ptr := new_string("darkness"&ascii.nul);

	pmylev : chars_ptr := new_string("level"&ascii.nul);
	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);
	popac : chars_ptr := new_string("NormalOpacity"&ascii.nul);
	pcubemap : chars_ptr := new_string("CubeMap"&ascii.nul);
	penvmap : chars_ptr := new_string("envMap"&ascii.nul);
	peyepos : chars_ptr := new_string("eyePos"&ascii.nul);

	ppid : chars_ptr := new_string("palmID"&ascii.nul);

	psand : chars_ptr := new_string("sandLevel"&ascii.nul);

-- end string pointers for getUniformLocation:







----- time variables ---------------------------------------------------
	portalbtn1time, portalbtn2time, portaltime,
	dBtnTime,
	exitTime, currentTime,
	wormsettime, deltabtntime, lasttime,
	foldtime, boldtime, jumptime, timeofroll : float := -20.0;
----- time variables ---------------------------------------------------


	winwidth, winheight : interfaces.c.int := 500;


-------------- seaweed --------------------------------------------------
	nseaweed : constant integer := 69;
	--nwtex    : constant integer := 2*nseaweed;

	subtype nwrng is integer range 1..nseaweed;
	--subtype nwrng is integer range 1..nwtex;
	type wlimarray is array(nwrng) of float;
	nwx,pwx,nwy,pwy,nwz,pwz : wlimarray := ( others => 0.0 );

	ii : nwrng;
	yysw, rad, ddr, angl, ddxx, ddzz : float;

	--type weedarray is array(nwrng) of pictobj.pictangle;
	--seaweed : weedarray;
	seaweed : xtreeobj.treeangle;

	type wsortarray is array(nwrng) of integer;
	wfar2near : wsortarray;

	weedbase : array(nwrng) of glfloat;


--------------- palm trees begin ---------------------------------------
	npalms : constant integer := 16; 
	-- 2 small, 6 tall, 3 bamboo, 3 grass clumps, 2 tall grass

	npt : integer := 0;
	--nptex  : constant integer := 2*npalms; 
	-- each palm is an "X" of 2 intersecting rectangles
	-- whose top center position varies with the "wind"

	type plant_type is (spalm, tpalm, bamboo, cgrass, tgrass);

	--subtype nprng is integer range 1..nptex; --needed for the sort function
	subtype nprng is integer range 1..npalms; --needed for the sort function

	plant : array(nprng) of plant_type;

	type plimarray is array(nprng) of float;
	nx,px,ny,py,nz,pz : plimarray := ( others => 0.0 );
	pxr,pyr,pzr, pxc,pyc,pzc : plimarray := ( others => 0.0 );

	--type palmarray is array(nprng) of pictobj.pictangle;
	--palm : palmarray;
	palm : xtreeobj.treeangle;

	palmbase : array(nprng) of glfloat;

	type psortarray is array(nprng) of integer;
	far2near : psortarray;
--------------- palm trees end ---------------------------------------


	package myfish is new zfishobj(7);
	mfish,bfish,rfish,sfish, pfish, pdfish : myfish.zfish;

	package longfish is new zfishobj(15);
	serpent : longfish.zfish;

	package longtube is new ztubeobj(25);
	snake : longtube.ztube;

	xbox : twictobj.twictangle;

	--pic2,
	pic, ceil2, floor, bloc2 : pictobj.pictangle;

	ceil1, ledge, bloc, 
	--lportal, rportal,
	  sok1,sok2,sok3,sok4,sok5,sok6 : rectobj.rectangle;

	lportal, rportal : pict1obj.pictangle;



	rmo : mroomobj.room;

	pox2,pox : rectxobj.rectx; -- fancy fragshader pictures

	rox : rectxobj.rectx;

	pxp,pxm, pym, pzp,pzm : rectobj.rectangle; -- brick Linings for pools (1,4)

	mv,mvp, pm, vm, mm, bmm,bmvp, imvp,mmvp,mmv, 
		mviewMatrix, iviewMatrix :  mat44 := identity;

	badhoriang : float:=0.0;
	horiang : float := 0.0; --halfpi; set per p1n,p2n when @ portal
	vertang : float := 0.0; -- NO code changes this yet


	portalEnabled, Xit, exitWait, lport_defined, rport_defined,
	lport_located, rport_located, lport_stable, rport_stable,
	first_worm_active, worm_active, worm_defined : boolean := false;


	worming, portalStatus, Rx, Rz: boolean := false;

	wmo : tunnelobj.room;
	--wto : tunneltexobj.room;
	wormstart, wormangle,
		owxme, owyme, owzme,
		nwxme, nwyme, nwzme : float;



	xme,yme,zme, 
	oxme,oyme,ozme, -- virtual position
		xlook,ylook,zlook : float := 0.0;

	xxlo,xxhi,zzlo,zzhi,
	--xtgt,ytgt,ztgt,
	xtgt1, ytgt1, ztgt1, xtgt2, ytgt2, ztgt2 : float := 0.0;

	-- these are used to predefine pending tgt updates
	-- which cannot be drawn until beam reaches tgt:
	xpre1, ypre1, zpre1, xpre2, ypre2, zpre2 : float := 0.0;

	fovrad : constant float := fourthpi;
	fovdeg : constant float := fourthpi*rad2deg;
	mindot : constant float := cos(fourthpi);
	mindot2: constant float := cos(60.0*deg2rad);


	p1,p2,
	pone, ptwo : integer := 0;

	wormradius : constant float := 1.0;
	margin     : constant float := 0.125; --9nov14
	aheight    : constant float := 0.7;
	shortwall  : constant float := 0.36;
	event_horizon : constant float := 2.0*margin;

	othersrolling, anyrolling, 
	userexit, goforward, gobackward, lavadead : boolean := false;


	-- dungeon parms
	xmax : constant float := 10.0;
	ymax : constant float :=  3.0;
	zmax : constant float := 20.0;


	jumping : boolean := false;
	pyjump : float := -ymax+aheight;
	vyjump : float := 0.0;




	mxlev : constant integer := 4; -- # game levels
	mxdeg : constant integer := 5; -- degrees of difficulty
	type ilevtype is array(1..mxdeg,1..mxlev) of integer;

	solved : array(0..mxlev+1) of boolean := ( others=> false );

	dod : integer := 1; -- DegreeOfDifficulty to use (1,2,3,4,5)


-- sokoban descriptors:
	nrows, ncols : integer;
	mrows : constant integer := 11;
	mcols : constant integer := 10; -- longest line + 1 for EOL

	wall, barl, rcpt : array(1..mrows,1..mcols) of boolean 
		:= (others=>(others=>false));


	pfname : array(1..mxdeg) of string(1..13) :=
	(
		"data/dod1.sok", "data/dod2.sok", "data/dod3.sok", 
		"data/dod4.sok", "data/dod5.sok"
	);


	-- (x,z) origin reference for each puzzle:
	xorigin : array(1..mxlev) of float 
		:= (       0.0,       +5.0, +xmax-2.0, +xmax-2.0 );
	zorigin : array(1..mxlev) of float 
		:= ( +zmax-3.0, -zmax+10.0, -zmax+9.0, +zmax-4.0 );

	sokwall : array(1..mrows,1..mcols) of rectobj.rectangle; --wall
	sokrcpt : array(1..mrows,1..mcols) of pictobj.pictangle; --receptacle

	msokrcpt : pictobj.pictangle; -- single beach receptacle


-- begin barrel data ----------------------------------------------------
	nbarrels : integer := 0;
	mxbarrels : constant integer := 11; --6;
	rolling : array(1..mxbarrels) of boolean := (others=>false);

	seated : array(1..mxbarrels) of boolean := (others=>false);

	barrel : array(1..mxbarrels) of cyl2obj.ball;

	recept, posbar : array(1..mxbarrels) of vec3 := ( others => (0.0,0.0,0.0) );

	--barrel properties:
	barr : constant float := 0.3;
	barrl, nubarrl, olbarrl, incbarrl : vec3;
	rolldist : constant float := onepi*barr;

-- end barrel data ----------------------------------------------------




	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);
	axis : vec3 := ( others => 0.0 );



	-- non-achievable until deliberately defined:
	xboxpos :  vec3 := ( 2.0*xmax,2.0*ymax,2.0*zmax );

	rotx,roty,rotz : float := 0.0;

	maxnko : constant integer := mrows*mcols; --110;
	nko, pko, level, oldlevel : integer := 0;

	koxlo, koxhi, koylo,koyhi, kozlo,kozhi : array(1..maxnko) of float;
	onledge : array(1..maxnko) of boolean;

	pn,
	p1n,p2n : vec3 := (0.0,0.0, -1.0);

	xpt,ypt,zpt : array(1..100) of float;

	rolldir : integer;






------------------------- begin beach types -------------------------------------------

	flyover : boolean := true; --just once @ first startup
	flystart : float; --beginning flytime
	flyduration : constant float := 30.0; --seconds
	yfly : constant float := 3.0; -- altitude

	mystexit : boolean := false;


	-- island specs:

	myrad : constant float := 20.0; -- 1.0; 23dec15 Y-radius
	mrad : constant float := 20.0; 

	eyeht : constant float := 0.23; --on island; dist above sand to eye
	hmax : constant float := 0.16;
	r1 : constant float := 5.0; -- highest ridge on atoll
	r2 : constant float := 7.0; -- radius where sandht = water level
	r3 : constant float := mrad;

	mwaterlevel : constant float := -hmax-eyeht; -- -0.39;

	mxpcen, mypcen, mzpcen : constant float := 0.0;

	radialMax2 : constant float := (0.5*mrad)*(0.5*mrad);
	-- limit distance into surf the viewpoint can travel


	maxyme : constant float := myrad/2.0;
	minyme : constant float := mwaterlevel+0.15; -- -0.24;
	-- don't allow viewpoint to get too close to water surface
	-- taking wave amplitudes into account.

	inwater, moving, splashing : boolean := false;

	mxm : constant float := mxpcen-mrad;
	mxp : constant float := mxpcen+mrad;

	mym : constant float := mypcen-myrad;
	myp : constant float := mypcen+myrad;

	mzm : constant float := mzpcen-mrad;
	mzp : constant float := mzpcen+mrad;

	skybox : cubemapobj.cubemap;

-- Reduce these values if your graphics are jerky...
-- 100 angular partitions, 200 radial partitions:
--package sea is new annusurfobj(100,200); -- prolog ocean
--package sea is new annusurfobj(200,200); -- prolog ocean
--	ocean   : sea.annusurf;
-- moved to gameutils.adb





-- stargate frame
	pillar1, pillar2,  -- frame sides
	pillar3,           -- frame top
	pillar4, pillar5,  -- frame steps
	dhdface, dhdpillar,dhdp1,dhdp2,dhdp3,dhdp4            -- DHD
		: pictobj.pictangle;
	pdx, pdz : constant float := 0.02;
	pdr2 : constant float := 2.0*pdx;
	pdy : constant float := 0.22;
	pbase, pcy : float;

	dhdx,dhdy,dhdz,dhdr,dhdh : float;
	dhdnear : constant float := 0.4;
	dhdstate : integer := 0; -- 0..5 : signals #solved puzzles

	topy, boty : float;

	sosx, sosy, sosz : float;

	gate : pictobj.pictangle; -- stargate
	gdx : constant float := 0.2;
	gdy : constant float := 0.2;
	gdz : constant float := 0.0001;
	gatex : constant float := -4.0;
	gatez : constant float := -4.0;
	gaterad : constant float := 0.2;






-- beach ZPM begin ----------------------------------------

	mbarrel : cyl2obj.ball;


	barad : constant float := 0.07;
	barx  : constant float := gatex+0.9; -- -2.8;
	barz  : constant float := gatez+0.9; -- -2.4;
	bary, bary0  : float;

	mrolldist : constant float := onepi*barad;

	mposbar : vec3;
	mrolling : boolean := false;
	mseated : boolean := false; --whether beach ZPM is on its receptacle

	sign : pictobj.pictangle;










	j1,j2,j3,j4,j5,j6 : float; -- junk...not used


	package myrockobj is new rectfineobj(3);
	rococo : myrockobj.rectfine;

	package mylean2obj is new rectfineobj(7);
	lean2 : mylean2obj.rectfine;



	package ntexsurf is new itemobj(7); --nose
	package ctexsurf is new itemobj(2); --cockpit
	nose : ntexsurf.texsurf;
	cpit : ctexsurf.texsurf;


	package stexsurf is new itemobj(4); --crab, starfish, jar, skull, etc
	item : stexsurf.texsurf;


	-- burnt log
	blrx : constant float := 0.02;
	blry : constant float := 0.04;
	blrz : constant float := 0.05;
	blcx : constant float := 4.3;
	blcz : constant float := 2.7;
	blcy : float;

	--fishbones
	fbrx : constant float := 0.02;
	fbry : constant float := 0.01;
	fbrz : constant float := 0.02;
	fbcx : constant float := 4.2;
	fbcz : constant float := 2.8;
	fbcy : float;



	--arm
	lgrx : constant float := 0.02;
	lgry : constant float := 0.01;
	lgrz : constant float := 0.04;
	lgcx : constant float := 4.0; --3.95;
	lgcz : constant float := 2.8;
	lgcy : float;


	--skull
	skrx : constant float := 0.02;
	skrz : constant float := 0.03;
	skry : constant float := 0.06;
	skcx : constant float := 3.92; --3.95 3.95 3.95 4.0;
	skcz : constant float := 2.8; --2.8
	skcy : float;

	--lean-to
	l2xr : constant float := 0.14;
	l2zr : constant float := 0.28;
	l2yr : constant float := 0.003;
	l2xc : constant float := 3.8;
	l2zc : constant float := 3.0;
	l2yc : float;




	--coconut:
	r1rx, r1ry, r1rz : constant float := 0.01;
	r1cx : constant float := -4.0;
	r1cz : constant float := 3.5;
	r1cy : float;

	ccx,ccy,ccz : array(1..5) of float;

	--smaller rock
	r2cx : constant float := 4.0;
	--r2cy : constant float := sandlevel;
	r2cz : constant float := 3.0;
	r2rx, r2ry, r2rz : constant float := 0.06;
	r2cy : float;

	--larger rock
	r3cx : constant float := 5.0;
	--r3cy : constant float := sandlevel;
	r3cz : constant float := 0.0;
	r3rx, r3ry, r3rz : constant float := 0.09;
	r3cy : float;


	--cockpit/nose:
	r4cxn, r4cyn, r4czn : float;
	r4cx : constant float := -6.0;
	r4cz : constant float := -6.0;
	r4rx, r4rz : constant float := 0.15;
	r4rxn, r4rzn : constant float := 0.15;


	r4cy : constant float := mwaterlevel-1.18;
	r4ry : constant float := 0.3-0.08;

	r4ryn : float := r4ry;


	wood2_texid, wood_texid, woodw_texid, woodt_texid,  brick_texid,
	snake_texid, serpent_texid,
	mfish_texid, bfish_texid, pfish_texid, rfish_texid, sfish_texid,
	gate_texid,	gate0_texid,	pillar1_texid,	pillar2_texid,
	dhd0_texid, dhdo_texid,
	dhd1_texid, dhd2_texid, dhd3_texid, dhd4_texid,
	hand_texid,	island_texid,	rock_texid,	coco_texid,
	gard_texid,	nose_texid,	cpit_texid,	palm_texid,	tpalm_texid,
	bamb_texid,	cgrass_texid,	tgrass_texid,	
	skull_texid, arm_texid, fishbones_texid, log_texid,
	
	tropical_cubemap_texid, --0 soln
	blue_cubemap_texid,     --1 soln
	gray_cubemap_texid,
	moon_cubemap_texid,
	sunset_cubemap_texid,   --4 soln
	rain_cubemap_texid,     --2 soln
	sargas_cubemap_texid,   --3 soln
	mcubemap_texid : gluint := 0;



	gateunifdark, palmunifdark, crabunifdark,noseunifdark,cpitunifdark,

	fishMatrixID, fishuniftex, fishuniftime,
	fishunifrot,
	fishunifrad, fishunifsvel, fishunifwvel, fishunifwamp,
	palmMatrixID, palmuniftex, palmuniftime, palmunifid, 
	--sandunifid,
	palmbaseid,
	palmradid, palmcenid,
	rockMatrixID, cpitMatrixID, noseMatrixID, 
	logMatrixID,loguniftex, logunifdark, logradid,logcenid,
	cpituniftex,noseuniftex, rockuniftex, 
	fcenid, cpradid, cpcenid, nradid, ncenid, rradid,rcenid, nMatrixID,
	gateMatrixID, gateuniftex, mMatrixID, muniftex, munifdark, rockunifdark,
	sbmvpUID, sbmapUID, mvpuid, emuid, mtimeid, hmaxuid,r1uid,r2uid,
	mwlevid, mpradid, mpcenid,mpeyeid : glint;
	

	logTexShadID,
	palmTexShadID,	rockTexShadID,	noseTexShadID,	cpitTexShadID,	fishTexShadID,
	gateTexShadID, mystnonTexShadID, mystpgmTexShadID,	mpidSkyB, mpidSkyW : gluint := 0;

	rr, d2gate, avgdist, dhdrad : float;

	pid,j : integer;


	lean2_texid, lean2TexShadID,	
	pic2_texid,
	sos_texid, frek_texid,pic_texid, crabTexShadID, crab_texid, star_texid : gluint;

	lean2MatrixID, lean2uniftex, lean2unifdark, lean2radid, lean2cenid,
	crabangl,
	crabMatrixID, crabuniftex, cradid, ccenid : glint;

	c1cx,c1cy,c1cz,
	c1rx,c1ry,c1rz,
	s1cx,s1cy,s1cz,
	s1rx,s1ry,s1rz,
	slev,
	mxc,myc,mzc,mxr,myr,mzr : float;

	sxr,syr,szr,sxc,syc,szc: float;

	sos: pictobj.pictangle;


	sharky, fishx,fishy,fishz, fishr, fishs, fdx,fdy,fdz : float;

	fxc,fyc,fzc, fxr,fyr,fzr : float;

	neardhd : boolean := false;

------------------------- end beach types -------------------------------------------


------------------------------ begin stuff from main -----------------------------

	mainWindow : access SDL_Window;
	mainGLContext : SDL_GLContext;


	ib, ir : integer;
	fcol,frow : float;
	ycb,ycw,yrw: float;

	ntex: glint;

	contextFlags : sdl_windowflags;
	current : aliased SDL_DisplayMode;
	should_be_zero : glint;
	cursor : access SDL_Cursor;

	Fwid, Fhit : aliased interfaces.c.int;

	ret : interfaces.c.int;
	numkeys : aliased glint;

	error : interfaces.c.int;


	--subtype keyindex is interfaces.c.int range 0..511;
	--type keyarraytype is array(keyindex) of Uint8;
	key_map : access sdl.keyarraytype;




	package rectsurf is new rectsurfobj(10);  -- water in levels 1,4
	package finesurf is new rectsurfobj(33);  -- lava in level 3
	package reflsurf is new rectsurfobj(180); -- reflective water in level 2
	rso : rectsurf.rectsurf;
	fso : finesurf.rectsurf;
	rfo : reflsurf.rectsurf;


	package circsurf is new circsurfobj(200); -- epilog = level 5
	cir : circsurf.circsurf; -- caution, 400 is graphically too burdensome


	rad5 : constant float := 4.0;

	usb5 : usboxobj.unitsky;


	use gl;
	use matutils;
	use type interfaces.c.c_float;






	tfile: text_io.file_type;
	resfile : string := "./data/resume_ag.txt";

	cubemap_texid, circubemap_texid, sok_texid,
	worm_texid,
	room_texid, xbox1_texid, xbox2_texid, 
	lining_texid, barloc0_texid, barloc1_texid, floor_texid, ceil_texid, 
	clouds_texid, grunge_texid, granite_texid, port_texid,
	bricksw_texid, adobe2_texid, adobe_texid, offport_texid
	: gluint := 0;





	playSecs : float; --glfw.Seconds;

	package myint_io is new text_io.integer_io(integer);

	major, minor, profile, flags :  glint;


	pidskyb, pidskyw, star2shadid,
	nontexshadid, starshadid, poolshadid, dpoolshadid, lpoolshadid,
	  tunshadid1, tunshadid2, tunshadid3,
	  wpgmtexshadid, pgmtexshadid, rpoolshadid
			: gluint;

	x1picshadid,
	x2pic2shadid, x3pic2shadid,
	x2picshadid, x3picshadid, x4picshadid : GLuint; --25feb15 addenda

	x1pictimeid, x1picresid, x1picmatid, x1picradid, x1piccenid,
	x2pic2timeid, x2pic2resid, x2pic2matid, x2pic2radid, x2pic2cenid,
	x2pictimeid, x2picresid, x2picmatid, x2picradid, x2piccenid,
	x3pictimeid, x3picresid, x3picmatid, x3picradid, x3piccenid,
	x3pic2timeid, x3pic2resid, x3pic2matid, x3pic2radid, x3pic2cenid,
	x4pictimeid, x4picresid, x4picmatid, x4picradid, x4piccenid : GLint; --25feb15 addenda


	unifport1, unifport2, unifprad,
	cmvpuid, cemuid, ctimeid, 
	cwlevid,  cpeyeid, 
	envmapid, rpeyeid,
	poolmvid, dpoolmvid, lpoolmvid, mvid, rpoolmvid, wmvid, 
	startimeid, starresid, starmatid, 
	star2timeid, star2resid, star2matid, 
	poolmatid, timeid, wlevid, pradid,pcenid,
	  dpoolmatid, dtimeid, dwlevid, dpradid, dpcenid, 
	  lpoolmatid, lresid, ltimeid, lwlevid, lpradid, lpcenid, ntmatrixid,
	  uniflev, wmatrixid, wuniftex, 
	  tunmatid1, tuntimeid1, tunresid1,
	  tunmatid2, tuntimeid2, tunresid2,
	  tunmatid3, tuntimeid3, tunresid3,
	  matrixid, unifopac,uniftex, rpoolmatid, rtimeid, rwlevid, rpradid, rpcenid
			: glint;



	pzlo, pzhi,
	waterlevel, xpcen,ypcen,zpcen,xprad,yprad,zprad : float;

	xc,yc,zc,xr,yr,zr : float;
	xm,xp,ym,yp,zm,zp : float;

	secperroll : constant float := 1.0;
	barreltime, barangle, tt : float;

	elapsed, dy : float;
	it : integer;


------------------------------ end stuff from main -----------------------------


	type dirtype is (no,so,ea,we, none);


	wal,
	wall1, wall2 : dirtype := none; -- which wall each portal is on

	cyl : cylobj.cylinder;

	dang1, dang2 : float;

	lshooting, rshooting : boolean := false;
	showskulls: boolean := true;

end gametypes;

