#version 330 core


uniform float time;
//uniform vec2 mouse;
vec2 mouse=vec2(0.5,0.5);
//uniform vec2 resolution;
uniform vec2 wPos;
uniform vec2 wRad;

in vec2 mypos;
out vec4 fragColor;

in vec4 aPos;

// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 ME;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////



void main(void){
	
	//vec2 p = gl_FragCoord.xy / resolution;
	vec2 p = +0.5 + 0.5*(mypos-wPos)/wRad; // 0...1
	vec2 q = p - vec2(mouse.x,mouse.y);
	
	vec3 col = mix(
		vec3(1.2*(mouse.y*2.0),0.4*(mouse.y),0.1), 
		vec3(0.9*mouse.y,0.7*mouse.y*1.5,0.2), 
		(p.y));
	
	float r = 0.0;
	r = 0.2*(mouse.y) +.1*mouse.y*cos(atan(q.x,q.y) * 10. 
		+ 20.*-q.x + 3. + time/cos(abs(mouse.x/50.)));
	
	col *= smoothstep(r,r+.01,length(q));
	r = 0.01*mouse.y;
	r += 0.001*cos(220.*q.y);
	r += exp(-100.*p.y - 0.5);
	col *= 1.0 
	- (1.0 - smoothstep(r, r+.005, abs(q.x - 0.25 
	* (mouse.x * 2.0 - 1.)*sin((cos(mouse.y) * 2.0)
	*q.y*2.0*mouse.y)) )) 
	* (1.0 - smoothstep(0.,0.01,q.y));
	
	fragColor = vec4(col,1.0);

	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - ME;
	vec3 cP2 =  port2 - ME;
	vec3 vP0 = aPos.xyz - ME;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}


}				  

