#version 330 core

// frag shader for cubemapped skybox with fog

uniform samplerCube CubeMap;


//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=1; //  0=>noFog, 1=>white, 2=>brownish, 3=>purple, 4=>gray
uniform int foglevl=0; // 0=>noFog, 1=>Fog

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////




in vec3 texcoord;

in vec4 aPos;

out vec4 color;





void main()
{
   color = texture(CubeMap, texcoord);

	if( foglevl>0 ) {
		float angl = atan( aPos.y, length(aPos.xz) );
		clamp(angl, 0.0, 1.0 ); // 1 radian =~ 57deg
		float density = 1.0 - angl;
		clamp(density, 0.0, 1.0);

		if( fogcolr==4 )
			color = mix(color,  vDfogColor, density); //gray
		else if( fogcolr==3 )
			color = mix(color, vMystColor, density); //purple
		else if( fogcolr==2 )
			color = mix(color, vSootColor, density); //brown
		else if( fogcolr==1 )
			color = mix(color, vFogColor, density);//whiterFog
	}

}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

