
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with matutils;  use matutils;
with gametypes;  use gametypes;
with gl;
with text_io;
with sdl; use sdl;



package gameutils is


	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := "");

function odd( i: integer ) return boolean;

function sqr( x: float ) return float;
function min( x,y: float ) return float;
function mini( i,j: integer ) return integer;

function atleftportal return boolean;
function atrightportal return boolean;
function atexit return boolean;

function intersectsko( x0,y0,z0, x1,y1,z1 : float;  k : in out integer ) return boolean;

function inpool( xx,yy,zz : float ) return boolean;

function anybarrelisat( xx,zz : float ) return boolean;

procedure testbarrel(  nbx,nby,nbz: in out float;
	wasmoved, hitko, hitwall : in out boolean );

procedure testPortals;

function ypos( nowtime, yp0, yvinit, deltaSecs : float ) return float;

function distance( x1,y1,z1, x2,y2,z2 : float ) return float;
function hordistance( x1,y1, x2,y2 : float ) return float;

procedure moveforward( currenttime: float );
procedure movebackward( currenttime: float );

procedure shootleft( mbtntime: float );
procedure shootright( mbtntime: float );


procedure updategamestate( currenttime : float );


procedure drawbeams( nowtime : float );


procedure output( a : mat44 );

procedure handle_mouse_move( nowTime : float );

procedure handle_gc_left(gcx,gcy:sdl.sint16);
procedure handle_gc_right(nowTime:float; gcx,gcy:sdl.sint16);

--procedure myst_handle_gc_left(nowTime:float; gcx,gcy:sdl.sint16);
--procedure myst_handle_gc_right(nowTime:float; gcx,gcy:sdl.sint16);

function bitmatch( x,y : integer ) return boolean;

procedure readPuzzle( level: integer );

procedure zeroBtns;
----------------------------------------------------------

procedure island_texture_setup;

function island_ftn( dbkgd: integer:= 0; dbug: boolean := false ) return integer;

procedure prepwormhole( 
	currenttime, oxme,oyme,ozme, nxme,nyme,nzme, fxme,fyme,fzme : float );
procedure worm(currenttime, xme,yme,zme : in out float;worming : in out boolean );


procedure drawWormHole( nowTime: float; lmvp: mat44 );

-- lava turtle:
procedure updateFerryPos( 
	tm: in float; 
	xb,yb,zb,ab, xh,yh,zh,ah: out float );


function dumpGLerrorQueue(id: string) return integer;

---------------------------------------------------------
procedure updateCamera(init: boolean := false);
procedure slewToAv;
procedure slewToAvLook;

procedure drawAvatar( mytime, xme,yme,zme,hang : float );

procedure aim(x,y,z: out float);

procedure updateMVP( wid,hit : float);
procedure updateMVP2( wid,hit, 
	xpos,ypos,zpos,
	cxluk,cyluk,czluk,
	xrt,yrt,zrt : float);

function branchnear( angAva, angCam : float ) return float;

procedure updateVert;

procedure fclamp(x: in out float; a, b : float);



function is_blank( line : string; len:integer ) return boolean;

procedure GetInt( Rcd:string;
						Bgn:in out natural;
						Int: in out gl.glint );

procedure getNbInt(tfile:text_io.file_type; rcd: in out string; k: in out gl.glint);

procedure GetFlt( Rcd:string;
					  Bgn:in out natural;
					  Flt: in out float );

procedure getNbFlt(tfile:text_io.file_type; rcd: in out string; t: in out float);


procedure setup_textures;
procedure release_textures;

function oppo( dir: dirtype ) return dirtype;

end gameutils;
