
--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext,  glext.pointers;

-------------------------------------------------------------

with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;

with ada.text_io; use ada.text_io;

----------------------------------------------------------------

with pngloader;
use  pngloader;




package body utex is


use type interfaces.c.c_float;

	-- additional bias to remove:
	yadj : constant float := -0.01;



function loadtexshaders return interfaces.c.unsigned is separate;



t2dtexid, t2dvbufid, t2duvbufid : gluint;
t2dshadid : interfaces.c.unsigned;
samplerUniformID : glint;
centerUniformID : glint;

Wwid, Whit : glint;


-- original baseline
--procedure printex( text: string; x,y,size: glint) is
procedure printex( text: string; x,y,size: integer) is

use interfaces.c;
use type interfaces.c.int;
use interfaces.c.strings;
use glext;
use gl.binding;
use glext.binding;

	txtlen : constant integer := text'length;
	nverts : constant int := int(6*txtlen);
	ncoords : constant int := int(12*txtlen);
	verts, uvs : array(0..ncoords-1) of glfloat;
	ch : character;
	ux,uy: glfloat;
	aski : integer;
	i : glint;

	-- this elliminates textual artifacts caused by neighboring letters:
	dx : constant glfloat := 0.06/16.0; -- 6% of width reduction is best

begin


	for ii in 0..txtlen-1 loop
		i:=glint(ii)*12;


------------- 1st triangle -------------
		verts(i+0):=glfloat(x+ii*size);
		verts(i+1):=glfloat(y+size);

		verts(i+2):=glfloat(x+ii*size);
		verts(i+3):=glfloat(y);

		verts(i+4):=glfloat(x+ii*size+size);
		verts(i+5):=glfloat(y+size);

------------- 2nd triangle -------------
		verts(i+6):=glfloat(x+ii*size+size);
		verts(i+7):=glfloat(y);

		verts(i+8):=glfloat(x+ii*size+size);
		verts(i+9):=glfloat(y+size);

		verts(i+10):=glfloat(x+ii*size);
		verts(i+11):=glfloat(y);

-------- now for the uvs ----------------------------

		ch := text( integer(ii+1) );

		aski := character'pos(ch);

		ux := glfloat(aski mod 16)/16.0;
		uy := glfloat(aski / 16)/16.0;


---------- 1st tri ------------------
		uvs(i+0):= ux +dx;
		uvs(i+1):= 1.0 - uy;

		uvs(i+2):= ux +dx;
		uvs(i+3):= 1.0 - (uy+1.0/16.0);

		uvs(i+4):= ux + 1.0/16.0 -dx;
		uvs(i+5):= 1.0 - uy;

--------- 2nd tri ---------------

		uvs(i+6):= ux + 1.0/16.0 -dx;
		uvs(i+7):= 1.0 - (uy+1.0/16.0);

		uvs(i+8):= ux + 1.0/16.0 -dx;
		uvs(i+9):= 1.0 - uy;

		uvs(i+10):= ux +dx;
		uvs(i+11):= 1.0 - (uy+1.0/16.0);


	end loop; -- for i


--put_line("tex: nverts="&int'image(nverts)); --60
--put_line("tex: verts'length = "&int'image(verts'length)); --120


	glbindbuffer( glext.gl_array_buffer, t2dvbufid );
	glbufferdata( glext.gl_array_buffer, 
		(float'size/8)*verts'length, verts(0)'address, glext.gl_static_draw);
	glbindbuffer( glext.gl_array_buffer, t2duvbufid );
	glbufferdata( glext.gl_array_buffer, 
		(float'size/8)*uvs'length, uvs(0)'address, glext.gl_static_draw);


	--bind shader
	gluseprogram( t2dshadid );


	-- bind texture
	gl.binding.glactivetexture(gl_texture0);
	gl.binding.glbindtexture(gl_texture_2d, t2dtexid);
	gluniform1i(samplerUniformID, 0);

	gluniform2i( centerUniformID, Wwid/2, Whit/2 );


	-- 1st attribute buffer : vertices
	glenablevertexattribarray(0);
	glbindbuffer(glext.gl_array_buffer, t2dvbufid);
	glvertexattribPointer(
		0,2,gl_float,gl_false,0, system.null_address);


	-- 2nd attribute buffer : UVs
	glenablevertexattribarray(1);
	glbindbuffer(glext.gl_array_buffer, t2duvbufid);
	glvertexattribPointer(
		1,2,gl_float,gl_false,0, system.null_address);


	gl.binding.glenable(gl_blend);
	gl.binding.glblendfunc(gl_src_alpha, gl_one_minus_src_alpha);


	-- draw call
	gl.binding.gldrawarrays( gl_triangles, 0, nverts );


	gl.binding.gldisable(gl_blend);
	gldisablevertexattribarray(0);
	gldisablevertexattribarray(1);


end printex;





procedure inittext2d( fname: string;  swid, shit : integer ) is

use interfaces.c.strings;
use glext.binding;
use gl.binding;

	-- these strings must match exactly the corresponding
	-- names in the shader codes...
	-- "uniform sampler2D" variable name in FS
	-- "uniform ivec2" variable name in VS:
	mysamp :  chars_ptr := new_string("myTextureSampler" & ascii.nul);
	mycen :  chars_ptr := new_string("screenCen" & ascii.nul);

begin

	Wwid := glint(swid);
	Whit := glint(shit);

	--put_line("inittext2d:  (Wwid,Whit) = ("&
	--	glint'image(Wwid)&","&glint'image(Whit)&" )");

	-- lettering file
	t2dtexid:=loadpng(mirror,fname);

	glgenbuffers(1, t2dvbufid'address);
	glgenbuffers(1, t2duvbufid'address);

	t2dshadid := loadtexshaders;

	samplerUniformID := glgetuniformlocation( t2dshadid, mysamp);

	centerUniformID := glgetuniformlocation( t2dshadid, mycen);

	free(mysamp);
	free(mycen);

end inittext2d;







--procedure print2d( text: string;	xcen,ycen: glfloat;	size : glint ) is
procedure print2d( text: string;	xcen,ycen: float;	size: integer ) is

--use type interfaces.c.c_float;

	fwid : float := float(Wwid);
	fhit : float := float(Whit);

	fsize : constant float := float(size);
	hfrac : constant float := 0.5*fsize/fwid;
	vfrac : constant float := 0.5*fsize/fhit;

	xoff : constant float := -hfrac;
	yoff : constant float := -vfrac;

	xfac : constant float :=  1.0;
	yfac : constant float :=  1.0;

	xpos : integer := integer( fwid*(xfac*xcen+xoff) );
	ypos : integer := integer( fhit*(yfac*ycen+yoff+yadj) );

begin
	printex( text, xpos, ypos, size );
end print2d;



procedure cleanuptext is

use gl.binding;
use glext.binding;

begin
	gldeletebuffers(1, t2dvbufid'address);
	gldeletebuffers(1, t2duvbufid'address);
	gldeletetextures(1, t2dtexid'address);
	gldeleteprogram(t2dshadid);
end cleanuptext;





procedure print3d( 
	text: string; 
	ccx,ccy,ccz,ccw: float; 
	isize: integer; 
	distance: float -- median Z-distance
	) is

use interfaces.c;


	fsize : constant float := float(isize)/distance;
	nusize : constant integer := integer( fsize );

	fwid : float := float(Wwid);
	fhit : float := float(Whit);

	hfrac : constant float := 0.5*fsize/fwid;
	vfrac : constant float := 0.5*fsize/fhit;


	xoff : constant float := -hfrac;
	yoff : constant float := -vfrac;

	xfac : constant float := 1.0;
	yfac : constant float := 1.0;


	-- Normalize Device Coords in [-1..1]
	xndc : float := ccx/ccw;
	yndc : float := ccy/ccw;
	zndc : float := ccz/ccw;

	-- coords in [0..1]
	xcen : float := (1.0+xndc)/2.0;
	ycen : float := (1.0+yndc)/2.0;

	xpos : integer := integer( fwid*(xfac*xcen+xoff) );
	ypos : integer := integer( fhit*(yfac*ycen+yoff+yadj) );

	eps : constant float := 0.001;

begin

	-- this form needed for portal gun & connection beam
	printex(text, xpos, ypos, nusize);

	--if( (-1.0<zndc) and (zndc<distance-eps) ) then
	--	printex(text, xpos, ypos, isize);
	--end if;


end print3d;




end utex;
