#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
uniform mat4 MVP;

uniform vec3 wPos;
uniform vec3 wRad;

// this variation is meant for cylindrical shapes like logs

void main(){

	vec3 pos = vertexPos;

	pos.x *= wRad.x;
	pos.y *= wRad.y;
	pos.z *= wRad.z;
	// we assume original setup with unitary radii

	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z; 
	// we assume original setup @ origin




	float 
		rx=(pos.x-wPos.x), 
		ry=(pos.y-wPos.y), 
		rz=(pos.z-wPos.z);


	float rxx = rx*rx;
	float rzz = rz*rz;
	if( ry>0 ) 
	{
		if( wRad.z > wRad.x ) 
			pos.y = wPos.y + ry*exp(-600*rxx); //curve only in short direction
		else
			pos.y = wPos.y + ry*exp(-600*rzz); //curve only in short direction
	}


	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

