#!/bin/sh
#
# Mac OS-X compile script for AdaGate assuming the
# presence of GNAT2018 or newer, as well as
# Xcode and its g++ compiler.
#
# This script uses mostly dynamic [shared] libs,
# static SDL2,
# shared SFML250 libs
# which are included in the AdaGate bundle,
# and frameworks for ogg,vorbis,openAL
#
# ...this script should work on any recent
# standard configuration of OS-X so long as
# the 2018 GNU Ada compiler, gnatmake, is installed.
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#====================================================================



# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


###########################################################
# next block unneccessary if "ocmp0.sh" was called already
###########################################################
# This uses Xcode g++ compiler:
# prepare libsnd4ada.dylib file prior to gnatmake
g++ adabindings/sfmlAudio/snd4ada.cpp \
-c -Werror -fPIC \
-I$PWD/incSFML250 \
-I$PWD/adabindings/sfmlAudio

g++ -shared \
-o $PWD/adagate.app/Contents/Frameworks/libsnd4ada.dylib snd4ada.o \
-lc++ -lm -lz \
$PWD/adagate.app/Contents/Frameworks/libsfml-audio.dylib \
$PWD/adagate.app/Contents/Frameworks/libsfml-system.dylib

##################################################

# Now, we use AdaCore 2018 gnatmake:
export PATH=/Users/rmurufas/opt/GNAT/2018/bin:$PATH

gnatmake  adagate -O3  \
-o adagate_osx_d \
--subdirs=./obj \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/sdl207ada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-largs -lm -lz \
-lc++ \
$PWD/libs/osx/libSDL2-207x.a \
$PWD/libs/osx/libiconv.a \
\
$PWD/adagate.app/Contents/Frameworks/libsnd4ada.dylib \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread \
\
-Xlinker -rpath -Xlinker @loader_path/adagate.app/Contents/Frameworks \
-Xlinker -rpath -Xlinker @loader_path/../Frameworks \
\
-F$PWD/adagate.app/Contents/Frameworks/ \
-framework sfml-audio -framework sfml-system \
-framework FLAC -framework ogg \
-framework vorbis -framework vorbisenc -framework vorbisfile


mv ./obj/adagate_osx_d .
cp adagate_osx_d adagate_osx




# -- Copyright (C) 2018  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.


