#version 330 core

uniform float time;

//uniform vec2 resolution;
uniform vec2 wPos;
uniform vec2 wRad;

in vec2 mypos;
out vec4 fragColor;


float noise2d(vec2 p) {
	return fract(sin(dot(p.xy ,vec2(12.9898,78.233))) * 456367.5453);
}

void main( void ) {

	//vec2 p = ( gl_FragCoord.xy / resolution.xy );
	vec2 p = 0.5*(mypos-wPos)/wRad;
	
	float a = 0.0;
	for (int i = 1; i < 20; i++) {
		float fi = float(i);
		float s = floor(200.*p.x/fi+50.*fi+time);
		if (p.y-fi/100. < noise2d(vec2(s)) - fi*.05) {
			a = float(i)/20.;
		}
	}
	float t = sin(time) + sin(2.0 * time) + sin(3.0 * time);
	if (t < 0.0) t = 0.0;
	if (t > 0.5) t = 0.5;
	fragColor = vec4(vec3(a, a * 0.5, a * 0.2), 1.0 ) * (1.0 - t) + noise2d(p + time) * t;
}

//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

