#version 330 core

// fragment shader
in vec2 UV;
out vec4 color;

uniform sampler2D myTextureSampler;




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside; 
// zero=>no discard, -1=>hangbound=minimum, +1=>hangbound=maximum

uniform float hangbound; // halfspace divider angle
uniform float xme;       // halfspace angle vertex X
uniform float zme;       // halfspace angle vertex Y

// halfspace discard uniforms end /////////////////////////////////

in vec4 aPos;


void main(){

	color = texture( myTextureSampler, UV).rgba;
	if( color.a < 0.1 ) discard;

	// added 21oct16
	// fastrgv:  my halfspace-discard addendum:
	float hang = atan(aPos.x-xme, aPos.z-zme);
	if     ( (iside>0) && (sin(hang-hangbound)>=0.0) ) discard;
	else if( (iside<0) && (sin(hang-hangbound)<=0.0) ) discard;

}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

