#version 330 core
layout(location = 0) in vec3 vertexPos;
out vec2 UV;

out vec4 vEyeSpacePos;
out vec4 aPos;



uniform mat4 MVP;
uniform mat4 MV;
uniform float mytime;

uniform vec3 wPos;
uniform vec3 wRad;

uniform float waterlevel;

const float pi = 3.14159;


const int numWaves=4;


// pretty nice lava:
const float amplitude[4] = float[4]( 0.025, 0.015, 0.025, 0.015 );
const float wavelength[4]= float[4]( 0.4, 0.2, 0.2, 0.3 );
const float speed[4]     = float[4]( 0.05, 0.06, 0.07, 0.08 );
const float dir[4] = float[4]( -1.0*pi, +0.7*pi, -0.5*pi, +0.2*pi );


const float diry[4] = float[4]( sin(dir[0]), sin(dir[1]), sin(dir[2]), sin(dir[3]) );
const float dirx[4] = float[4]( cos(dir[0]), cos(dir[1]), cos(dir[2]), cos(dir[3]) );


float wave(int i, float x, float y) {
    float frequency = 2*pi/wavelength[i];
    float phase = speed[i] * frequency;
    float theta = dot( vec2( dirx[i], diry[i] ), vec2(x, y));
    return amplitude[i] * sin(theta*frequency+mytime*phase);
}

float waveHeight(float x, float y) {
    float height = 0.0;
    for (int i = 0; i < numWaves; ++i)
        height += wave(i, x, y);
    return height;
}


void main(){
	vec3 pos = vertexPos;
	aPos = vec4(pos,1.0);

	float xmin=wPos.x-wRad.x;
	float xmax=wPos.x+wRad.x;
	float zmin=wPos.z-wRad.z;
	float zmax=wPos.z+wRad.z;
	UV = vec2( (pos.x-xmin)/(xmax-xmin), (pos.z-zmin)/(zmax-zmin) );

	if
	( 
		( pos.y  > wPos.y + wRad.y/2 )  //only top surface
	)  
	{
	  pos.y = waterlevel + waveHeight( (vertexPos.x-wPos.x)/wRad.x, (vertexPos.z-wPos.z)/wRad.z);

	  aPos.y = (pos.y - waterlevel)/0.10; // in -1..+1 (sent to lavaFog.fs)
	  aPos.y = 0.5*(1.0+aPos.y); // in [0..1] sent to lavaFog.fs
	}
	
	gl_Position =  MVP * vec4(pos,1.0);
	vEyeSpacePos =  MV * vec4(pos,1.0);
}


//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

