#version 330 core

uniform float time;
uniform vec2 wPos;
uniform vec2 wRad;

in vec2 mypos;
in vec4 vEyeSpacePos;
in vec4 aPos;
out vec4 color;

float iGlobalTime=time;

// Mahmud Yuldashev Red Planet mahmud9935@gmail.com

float noise2D(vec2 uv)
{
	uv = fract(uv)*1e3;
	vec2 f = fract(uv);
	uv = floor(uv);
	float v = uv.x+uv.y*1e3;
	vec4 r = vec4(v, v+1., v+1e3, v+1e3+1.);
	r = fract(1e5*sin(r*1e-2));
	f = f*f*(3.0-2.0*f);
	return (mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y));	
}

float fractal(vec2 p) {
	float v = 0.5;
	v += noise2D(p*16.); v*=.5;
	v += noise2D(p*8.); v*=.5;
	v += noise2D(p*4.); v*=.5;
	v += noise2D(p*2.); v*=.5;
	v += noise2D(p*1.); v*=.5;
	return v;
}

vec3 func( vec2  p) {
	p = p*.1+0.5;
	vec3 c = vec3(.0, .0, .1);
	vec2 d = vec2(iGlobalTime*.0001, 0.);
	c = mix(c, vec3(.8, .1, .1), pow(fractal(p*.20-d), 3.)*2.);
	c = mix(c, vec3(.9, .6, .6), pow(fractal(p.y*p*.10+d)*1.3, 3.));
	c = mix(c, vec3(1., 1., 1.), pow(fractal(p.y*p*.05+d*2.)*1.2, 1.5));
	return c;
}




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside; 
// zero=>no discard, -1=>hangbound=minimum, +1=>hangbound=maximum

uniform float hangbound; // halfspace divider angle
uniform float xme;       // halfspace angle vertex X
uniform float zme;       // halfspace angle vertex Y

// halfspace discard uniforms end /////////////////////////////////


/*
///////// Fog Addendum: /////////////////////////

const int level=3; //make into a uniform if using in other levels

const float fStart=0.0;
const float fEnd=30.0; // normal fog
const float sEnd=20.0; // use this for soot (lava room)

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // lava room
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // granite room

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;

	if(level==2)
		fResult = (sEnd-fFogCoord)/(sEnd-fStart);
	else
		fResult = (fEnd-fFogCoord)/(fEnd-fStart);

	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}


const float yc=-2.85;
*/




void main( void ) {
	vec2 p = 0.5*(mypos-wPos)/wRad;

	float d = length(p);
	p *= (acos(d) - 1.57079632)/d;
	color = vec4(func(p)*max(1.-d*d*d, 0.), 1.0);

/*
// fastrgv:  my Fog addendum...negligible improvement
	float dist = length( vEyeSpacePos.xz );
	float fFogCoord = exp(-0.4*abs(aPos.y-yc)) * dist/vEyeSpacePos.w;

	if( level==3 )
		color = mix(color, vMystColor, getFogFactor(fFogCoord));
	else if( level==2 )
		color = mix(color, vSootColor, getFogFactor(fFogCoord));
	else
		color = mix(color, vFogColor, getFogFactor(fFogCoord));
*/



	// fastrgv:  my halfspace-discard addendum:
	float hang = atan(aPos.x-xme, aPos.z-zme);
	if     ( (iside>0) && (sin(hang-hangbound)>=0.0) ) discard;
	else if( (iside<0) && (sin(hang-hangbound)<=0.0) ) discard;


}

