
--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;


generic
	nang, nrad : integer; -- #angularGrid, #radialGrid


package hemi2obj is -- for upper half of spheroid

type circtex is tagged private;

procedure setround( ct: in out circtex;  rx,ry,rz : float ); --called once

procedure setplace( ct: in out circtex;  cx,cy,cz, ang : float );
-- called many times

procedure draw( ct: circtex;  vertbuff, uvbuff, elembuff : gluint );
procedure ldraw( ct: circtex;  vertbuff, uvbuff, normbuff, elembuff : gluint );


private

nsq : constant integer := nang*nrad;
nvert : constant integer := 12*nsq;
nuv : constant integer := 8*nsq;
nelm : constant integer := 6*nsq; -- 30aug15 corrections


type varray is array(1..nvert) of float;
type vap is access varray;

type tarray is array(1..nuv) of float;
type tap is access tarray;

type earray is array(1..nelm) of glushort;
type eap is access earray;


type circtex is new ada.finalization.controlled with record
	vert, norm: vap;
	txuv: tap;
	elem: eap;
	xcen,ycen,zcen, acen : float;
	nv, tk, ej : integer := 0; -- to hold actual values
end record;



procedure initialize(ct: in out circtex);
procedure finalize(ct: in out circtex);


end hemi2obj;
