#version 330 core
// fragment shader

smooth in vec2 UV;
smooth in vec3 vNormal;
smooth in vec4 vEyeSpacePos;
smooth in vec3 vWorldPos;
smooth in vec4 aPos;

out vec4 color;

uniform sampler2D myTextureSampler; // #1



////// begin lighting uniforms ///////////

uniform int lightFlag = 0; // 0=>no, 1=>yes  #2

/////// begin point-light ///////
uniform vec3 vPtColor; // 254:203:33   #3
uniform vec3 vPos1;          // #4
uniform vec3 vPos2;          // #5
uniform vec3 vPos3;          // #6
//uniform float fPtAmbient;
//uniform float fPtConstantAtt;
//uniform float fPtLinearAtt;
//uniform float fPtQuadAtt;
const float fPtAmbient = 1.0;
const float fPtConstantAtt = 0.0;
const float fPtLinearAtt = 0.3;
const float fPtQuadAtt = 0.0;
////// end point-light //////////////////


////// begin directional-light //////
//uniform vec3 vDirColor;
//uniform vec3 vDirection;
//uniform float fDirAmbient;
//uniform float fDirStrength; // to ignore, set this to zero

const vec3 vDirColor = vec3(1.0,1.0,1.0);
const vec3 vDirection = vec3(0.0,-1.0,0.0);
const float fDirAmbient = 1.0;
const float fDirStrength = 0.0;
//////// end directional-light ////////////


////// end lighting uniforms ///////////




//////// begin lighting ftns /////////////////////////


vec4 getPointLightColor()
{
	vec3 vPosToLight1 = vWorldPos-vPos1;
	float fDist1 = length(vPosToLight1);
	vPosToLight1 = normalize(vPosToLight1);

	vec3 vPosToLight2 = vWorldPos-vPos2;
	float fDist2 = length(vPosToLight2);
	vPosToLight2 = normalize(vPosToLight2);

	vec3 vPosToLight3 = vWorldPos-vPos3;
	float fDist3 = length(vPosToLight3);
	vPosToLight3 = normalize(vPosToLight3);

	float fDist = (fDist1+fDist2+fDist3)/3.0;

	float fDiffuse1 = max(0.0, dot(vNormal, -vPosToLight1));
	float fDiffuse2 = max(0.0, dot(vNormal, -vPosToLight2));
	float fDiffuse3 = max(0.0, dot(vNormal, -vPosToLight3));

	float fAttTotal = 
		fPtConstantAtt 
		+ fPtLinearAtt*fDist 
		+ fPtQuadAtt*fDist*fDist;

	return 
		vec4(vPtColor, 1.0)
		* (fPtAmbient+fDiffuse1+fDiffuse2+fDiffuse3)/fAttTotal;
}


vec4 getDirectionalLightColor()
{
	float fDiffuse = max(0.0, dot(vNormal, -vDirection));
	return vec4(
		vDirColor
		* (fDirAmbient+fDiffuse)
		* fDirStrength, 
		1.0);
}


//////// end lighting ftns /////////////////////////







// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 ME;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////




// fog addendum begin ////////////////////////////

uniform int level=2;  // #11 3=>purple, 2=>brown, 1=>gray, 0=>noFog

const float fStart=0.0;
const float fEnd=30.0; // normal fog
const float sEnd=20.0; // use this for soot (lava room)

const vec4 vFogColor=vec4(0.9,0.9,0.9,1.0); //normal
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // lava room
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // granite room

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;

	if(level==2)
		fResult = (sEnd-fFogCoord)/(sEnd-fStart);
	else
		fResult = (fEnd-fFogCoord)/(fEnd-fStart);

	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return fResult;
}

const float yc=-2.85;

// fog addendum end /////////////////////////////




void main(){

	color = texture( myTextureSampler, UV).rgba;


	// lighting addendum:
	if( lightFlag > 0 ) { // use light effects

		vec4 vTexColor = color;
		vec4 vLightColor = 
			//getDirectionalLightColor() +
			getPointLightColor();
			
		color = vTexColor*vLightColor;

	}


	// fog addendum:
	float dist = length( vEyeSpacePos.xz );
	float fFogCoord = exp(-0.4*abs(aPos.y-yc)) * dist/vEyeSpacePos.w;
	if( level==3 )
		color = mix(color, vMystColor, getFogFactor(fFogCoord));
	else if( level==2 )
		color = mix(color, vSootColor, getFogFactor(fFogCoord));
	else
		color = mix(color, vFogColor, getFogFactor(fFogCoord));


	//if( color.a < 0.1 ) discard; //elliminate transparent parts
	color.a=1.0; //otherwise we see thru to bricks


	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - ME;
	vec3 cP2 =  port2 - ME;
	vec3 vP0 = aPos.xyz - ME;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}

}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

