# Linux
# gnu compile script for adagate
# suitable for gnat from AdaCore 2017 
#
# This script uses only shared libs
# SFML-v2.3.2 and SDL2-v2.0.3
# both included in ./libs/gnu/
#
# this system builds shared libsnd4ada.so file
#
# note: library presence in linux distros:
# 56/77	FLAC   => 73%
# 75/77	ogg
# 22/77	openal => most rare @ 28%
# 76/77	vorbis
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere

#########################################################

# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# this is the typical path of gnat gpl...
# for AdaCore-2017
export PATH=/usr/gnat/bin:$PATH


#########################################################

# This step is not necessary if libsnd4ada.so is already present...
#
# prepares libsnd4ada.so file prior to gnatmake...
# using g++ from GNAT:

#g++ adabindings/sfmlAudio/snd4ada.cpp -c -Werror -fPIC -I./cppinclude

#g++ -shared -o ./libs/gnu/libsnd4ada.so snd4ada.o \
#-L$PWD/libs/gnu -lsfml-audio -lsfml-system

#-I./adabindings/sdl203ada \

#########################################################

gnatmake adagate -o adagate3 \
-O3 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdl203ada \
-I./adabindings/AdaPngLib \
-I./adabindings/sfmlAudio \
-largs \
-lGL -lz -lm -lpthread -lstdc++ \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lsnd4ada \
-lSDL2-203 -lsfml-audio -lsfml-system \
-lopenal -lcrypto -logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC

#NOTE:  final line above has libs that need not be explicitly
#       mentioned, yet are used and may be non-standard



mv ./obj/adagate3 ./adagate_gnu


# -- Copyright (C) 2017  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.



