--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with snd4ada_hpp;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;


----------------------------------------------------------------
with sdl;  use sdl;
----------------------------------------------------------------

with matutils;
with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;

----------------------------------------------------------------


with shader;  use shader;

with mroomobj;
with tunnelobj;
with rectobj;
with pictobj;
with twictobj;
with pict1obj;
with rectxobj;
with rectsurfobj;
with cyl2obj;
with cylobj;
with rectxfineobj;
with frameobj;

with circsurfobj;
with usboxobj;


with text_io;
with pngloader;
with gametypes;
with gameutils;
with matutils;

with ada.calendar;

with avatarobj;



procedure adagate is

	use text_io;
	use pngloader;
	use gametypes;
	use gameutils;
	use matutils;

	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;

	use gametypes.fmath;


	nerr: integer;


	-- this assumes mm=ID [almost] always:
	procedure updateMVP( wid,hit : float) is
		xlk,ylk,zlk,
		xrt,yrt,zrt,
		xpos,ypos,zpos,
		xup,yup,zup : float;
		-- The look vector (xlk,ylk,zlk) is mapped to
		-- the viewport center.  UP does not refer to (0,1,0), 
		-- but a direction perpendicular to the L.O.S. that 
		-- is mapped to the upward direction in the viewport
	begin

		if thirdPerson and not worming then

			xpos:=xcam; ypos:=ycam; zpos:=zcam;

			-- camera look + choriang are already defined

		else -- firstPerson

			xpos:=xme; ypos:=yme; zpos:=zme;

			choriang:=horiang;
			cxlook := fmath.cos(vertang)*fmath.sin(choriang);
			cylook := fmath.sin(vertang);
			czlook := fmath.cos(vertang)*fmath.cos(choriang);

		end if;



		-- Look Vector
		xlk:=xpos+cxlook;
		ylk:=ypos+cylook;
		zlk:=zpos+czlook;

		-- Right unit-Direction
		xrt:= sin(choriang-halfpi);
		yrt:= 0.0;
		zrt:= cos(choriang-halfpi);

		-- calculate UP unit-Direction
		cross( xrt,yrt,zrt, cxlook,cylook,czlook, xup,yup,zup );

		perspective(pm, 45.0, wid/hit,  0.1, 100.0);

		lookat(vm, xpos,ypos,zpos, xlk,ylk,zlk, xup,yup,zup );

		-- note: mm=id
		-- MV = mm*vm = id*vm = vm
		mv:=vm;

		mvp:=mv;
		myMatMult(mvp,pm); -- mvp := mv * pm

		-- For a given modelmatrix (MM: mat44), 
		-- we can get a normalMatrix (NM: mat33) by:
		-- myInvTransp(MM,NM)
		-- However, in this app, MM=ID

	end updateMVP;











procedure InitSDL( width, height : glint;  flags:Uint32;  name: string ) is

	use system;

	profile, compflag,
	ires, jerror, error, cver : interfaces.c.int;
	bresult : SDL_bool;

	compiled, linked : aliased SDL_version;

	pms : char_array := To_C("GL_ARB_multisample");
	psampl : aliased glint;
	--glbp :  glboolean_pointer;

begin
	--glbp := new glboolean;
	--glbp.all := gl_false;

	-- Careful!  Only initialize what we use (otherwise abort possible):
	error := SDL_Init(
		SDL_INIT_TIMER or
		SDL_INIT_EVENTS or 
		SDL_INIT_VIDEO);

if (error /= 0) then
	put_line( value(sdl_geterror) );
end if;

	myassert( error = 0, 1000 );

	jerror := SDL_Init(
		SDL_INIT_GAMECONTROLLER or
		SDL_INIT_JOYSTICK );

	joystik:=false;
	gamepad:=false;
	if  jerror = 0  and then SDL_NumJoysticks>=1  then
		jsa := SDL_JoystickOpen(0);
		gamepad := (sdl_joysticknumaxes(jsa) >= 4);
		joystik := not gamepad;
		put_line("#axes="& glint'image(sdl_joysticknumaxes(jsa)) );
		put_line("#btns="& glint'image(sdl_joysticknumbuttons(jsa)) );
		ires := SDL_JoystickEventState(SDL_QUERY); -- ignore
		SDL_JoystickUpdate;
		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
	end if;

	if gamepad then
		put_line("...#axes>=4 so I'm guessing controller is a gamepad...initialized");
	elsif joystik then
		put_line("...#axes<=3 so I'm guessing controller is a joystick...initialized");
	else
		put_line("...no game controller detected...");
	end if;

---------- begin 14feb15 insert ------------------------------------------------
	SDL_SOURCEVERSION( compiled'access );
	put_line("We compiled against SDL version "
		&Uint8'image(compiled.major)&"."
		&Uint8'image(compiled.minor)&"."
		&Uint8'image(compiled.patch) );
	cver := SDL_COMPILEDVERSION;  
	put_line("SDL_compiledversion="&glint'image(cver));
	SDL_GetVersion( linked'access );
	put_line("We linked against SDL version "
		&Uint8'image(linked.major)&"."
		&Uint8'image(linked.minor)&"."
		&Uint8'image(linked.patch) );
---------- end 14feb15 insert --------------------------------------------------

	bresult := SDL_SetHint( SDL_HINT_RENDER_VSYNC, "1" );
	myassert( bresult = SDL_TRUE, 1001 );
	bresult := SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, "1" );
	myassert( bresult = SDL_TRUE, 1002 );




	--// Turn on double buffering.
	error := SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	myassert( error = 0, 1003 );
	error := SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	myassert( error = 0, 1004 );
	error := SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	myassert( error = 0, 1005 );





	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 3);
	myassert( error = 0, 1006 );
	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	myassert( error = 0, 1007 );




	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_PROFILE_MASK, 
											SDL_GL_CONTEXT_PROFILE_CORE );
	myassert( error = 0, 1008 );

	-- Note that OSX currently requires the forward_compatible flag!
	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_FLAGS, 
											SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG );
	myassert( error = 0, 1009 );




	mainWindow := SDL_CreateWindow( To_C(name,true) , 
			SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
			width, height, flags);

-- At this point we test for GLerrors ###################################

	mainGLContext := SDL_GL_CreateContext(mainWindow);

	error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
	myassert( error = 0, 1010 );


-- This next section is ugly.  If you know a better way
-- then please tell me how,  <fastrgv@gmail.com>
--
-- Note that it seems multisamples are not supported on OSX
-- although the aliasing seems subdued, perhaps due to hiDPI.
--
---------------------------------------------------------------------
	--this FTN must be called AFTER context is created and made current:
	if SDL_TRUE = sdl_gl_extensionsupported(pms) then

		-- kill this window, then recreate with multisamples=4
		SDL_GL_DeleteContext(mainGLContext);
		SDL_DestroyWindow(mainWindow);

		--multisamples are supported so reduce aliasing:

		put_line("MultSample is supported");
		error := SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
		myassert( error = 0 ,1011 );

		mainWindow := SDL_CreateWindow( To_C(name,true) , 
				SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
				width, height, flags);

		mainGLContext := SDL_GL_CreateContext(mainWindow);

		error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
		myassert( error = 0 ,1012 );

---------------------------------------------------------------------
		error := SDL_GL_GetAttribute(SDL_GL_MULTISAMPLESAMPLES,psampl'access);
		myassert( error = 0 ,1013 );
		put_line("psampl="&glint'image(psampl));   -- 4
---------------------------------------------------------------------

	else
		put_line("MultSample is NOT supported");
	end if;


	glgetintegerv(gl_major_version, major'address);
	glgetintegerv(gl_minor_version, minor'address);
	put_line("ogl-version-query:"&glint'image(major)&":"&glint'image(minor));



	glGetIntegerv(GL_CONTEXT_PROFILE_MASK, profile'address);
	if( profile = GL_CONTEXT_CORE_PROFILE_BIT ) then
		put_line("ogl-query:  Core Profile");
	end if;


	-- OSX currently requires the forward_compatible flag!
	glGetIntegerv(GL_CONTEXT_FLAGS, compflag'address);
	if( compflag = GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT ) then
		put_line("ogl-query:  Forward-Compatible bit is set");
	end if;



	--minimal error test
	nerr:=dumpGLerrorQueue("AG.InitSDL");



end InitSDL;





package myfloat_io is new text_io.float_io(float);

package mygint_io is new text_io.integer_io(glint);


--we skip blank lines and comments beginning with "#":
function is_blank( line : string; len:integer ) return boolean is
begin

	if( len < 1 ) then return true; end if;

	if line( line'first )='#' then return true;
	elsif line( line'first ) = ' ' then	return true; end if;

	return false;

end is_blank;






procedure GetInt( Rcd:string;
						Bgn:in out natural;
						Int: in out glint ) is
begin
mygint_io.get( From => Rcd(Bgn..Rcd'last),
					Item => Int,
					Last => Bgn);
Bgn:=Bgn+1;
end GetInt;



procedure getNbInt(tfile:file_type; rcd: in out string; k: in out glint) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;

	GetInt(rcd,bgn,k);

end getNbInt;


procedure GetFlt( Rcd:string;
					  Bgn:in out natural;
					  Flt: in out float ) is
nd: positive;
begin
myfloat_io.get( From => Rcd(Bgn..Rcd'last),
					 Item => Flt,
					 Last => nd);
Bgn := nd+1;
end GetFlt;


procedure getNbFlt(tfile:file_type; rcd: in out string; t: in out float) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;
	GetFlt(rcd,bgn,t);
end getNbFlt;










procedure first_prep is -- main program setup
	rcd : string(1..80);
	ret : glint; --interfaces.c.int;
begin

---------- prep transient sounds ----------------------------------------

	snd4ada_hpp.initSnds;

	laser := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/laser-gun.wav"),50);

	stone := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/concrete.ogg"),99);

	xport := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/sci-fi.ogg"),50);

	kick := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/soccer-kick.wav"),99);

	qport := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/quick_portal.wav"),50);

	shriek := snd4ada_hpp.initSnd(
		Interfaces.C.Strings.New_String("data/medusa.ogg"),99);

------- now for the soundLoops --------------------------------------

	splash := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/splash.wav"),20);

	water := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/lake-waves-01.ogg"),60);

	lava := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/nulava.ogg"),99);

	hum := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/hum.ogg"),99);

	beach := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/beach00.ogg"),99);

	falls := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/falls.ogg"),50);

	dark := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/dark-metal-electronic-loop.ogg"),50);

	gothic := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/gothic-dutch-trance.ogg"),30);

	neptune := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/portals-to-neptune_loop.ogg"),50);

	choir := snd4ada_hpp.initLoop(
		Interfaces.C.Strings.New_String("data/briefChurchChoir.ogg"),50);


	if laser<0 or stone<0 or xport<0 or kick<0 or qport<0 or shriek<0 
		or splash<0 or water<0 or lava<0 or hum<0 or beach<0 
		or falls<0 or dark<0 or gothic<0 or neptune<0 or choir<0 
	then
		put_line("snd4ada_hpp initializer error !");
		raise program_error;
	end if;



	-- assume level=0 => beach prologue...


	-- set default starting level, which will be overridden if
	-- there is a command line parm, or a non-empty restore file:
	level:= 0;

	playSecs := float( sdl_getticks ) / 1000.0;
	lastTime := playSecs;
	portalTime := lastTime-20.0;


	if FileExists(resfile) then -- takes precedence over defaults
		put_line("Resume file found");
		text_io.open(tfile, in_file, resfile);
		myint_io.get(tfile,dod); -- this overrides default
		myassert( dod>=1, 1012 );  myassert( dod<=5, 1013 );

		for i in 1..mxlev loop
			myint_io.get(tfile,good);
			myassert( (good=0) or (good=1), 1014 );
			if (good=1) then
				solved(i):=true;
			else
				solved(i):=false;
			end if;
		end loop;
		text_io.close(tfile);
	else
		put_line("No resume file found");
	end if;




	-- before we call readPuzzle we should set "dod" [DegreeOfDifficulty] 
	-- as 1(easy), 2(medium), 3(hard), 4(harder), 5(advanced)
	-- 0 => debug mode

	dbug:=false;
	bkgd:=0;

   if Ada.Command_Line.Argument_Count > 1 then 
	--DOD in {1..5} [ or 0=> skip flyover ]
	--bkgd in {0..4} [ 4=>night ]
   
     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--level
       bstr : string := Ada.Command_Line.Argument(2);--bkgd
		 idod : integer;
     begin
       myint_io.get(dstr,idod,lst); -- overrides both previous, default
       myint_io.get(bstr,bkgd,lst); -- overrides both previous, default
		if idod<1 then
		 	dbug:=true; --skip flyover
			dod:=1;
			myassert( 0<=bkgd, 551 );
			myassert( bkgd<=4, 552 );

		elsif idod<=5 then
			dod:=idod;
		else
			put_line("invalid DOD value...ignoring");
		end if;
     end; --declare
   
   elsif Ada.Command_Line.Argument_Count = 1 then
	--DOD in {1..5} [ or 0=> skip flyover ]

     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--level
		 idod : integer;
     begin
       myint_io.get(dstr,idod,lst); -- overrides both previous, default
		if idod<1 then
		 	dbug:=true; --skip flyover
			dod:=1;
		elsif idod<=5 then
			dod:=idod;
		else
			put_line("invalid DOD value...ignoring");
		end if;
     end; --declare
   

   elsif Ada.Command_Line.Argument_Count > 2 then

     put_line("I expect at most 2 command line parms:");
	  put_line("1) Degree of Difficulty, 1=easy ... 5=extreme");
	  put_line("2) bkgd 0..4");
     raise program_error;

   end if;


	put_line(" Puzzle Difficulty = " & integer'image(dod) );


------- begin SDL prep ---------------------------------------------------------

	ret := SDL_Init(SDL_INIT_VIDEO); --note this is redone within InitSDL!
	should_be_zero := SDL_GetCurrentDisplayMode(0, current'access);

if (should_be_zero /= 0) then
	put_line( value(sdl_geterror) );
end if;

	myassert( should_be_zero = 0, 577 );

	-- MacOSX:  HDPI is normally controlled in the "properties"
	-- box, but does not work for this app.  If there is jerkiness
	-- on your Retina display, use low dpi, which still looks 
	-- pretty good, albeit with some noticable aliasing.
	contextFlags := 
		SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL or 
		SDL_WINDOW_FULLSCREEN_DESKTOP or SDL_WINDOW_ALLOW_HIGHDPI;

-- Note:  current : aliased SDL_DisplayMode (gametypes)

	InitSDL(current.w, current.h, contextFlags, "AdaGate");
	winwidth:=current.w;
	winheight:=current.h;


	-- this too runs fine...used for testing purposes...
	--contextFlags := SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL;
	--winwidth:=1000; --1400;
	--winheight:=600; --800;
	--InitSDL(winwidth,winheight, contextFlags, "AdaGate");


-- read joystik or gamepad settings here:
	if FileExists(cfgfile) then -- takes precedence over defaults
		put_line("game-controller settings file found");
		text_io.open(tfile, in_file, cfgfile);

		getNbInt(tfile,rcd,gshtl); 
		getNbInt(tfile,rcd,gshtr); 
		getNbInt(tfile,rcd,gjmp); 
		getNbFlt(tfile,rcd,Lsens); 
		getNbFlt(tfile,rcd,Rsens); 

------- end gamepad;  begin joystik --------------------

		getNbInt(tfile,rcd,jbak); 
		getNbInt(tfile,rcd,jfor); 
		getNbInt(tfile,rcd,jshtl); 
		getNbInt(tfile,rcd,jshtr); 
		getNbInt(tfile,rcd,jjmp); 
		getNbFlt(tfile,rcd,Jsens); 

		text_io.close(tfile);

	else
		put(cfgfile & " file not found...");
		put_line("Using default game controller settings");
		gshtl:=4; --shoot left
		gshtr:=5; --shoot right
		gjmp :=8; --jump

		jbak :=0; --moveback
		jfor :=1; --forward
		jshtl:=2; --shoot left
		jshtr:=3; --shoot right
		jjmp :=7; --jump
	end if;

	if joystik then --we actually use only Lsens or Rsens
		Lsens:=Jsens;
		Rsens:=Jsens; -- Jsens is not used
	end if;






	-- if any OGL errors already, spit them out
	-- to avoid misleading messages in utex
	nerr:=dumpGLerrorQueue("first_prep_1"); 

	utex.inittext2d("data/rods3x.png", integer(winwidth),integer(winheight));
	put_line( "Window: wid-X-hit :" 
		& interfaces.c.int'image(winwidth)&" X "
		& interfaces.c.int'image(winheight) );


	error := SDL_SetRelativeMouseMode(SDL_TRUE);
	myassert( error = 0, 1016 );

	SDL_GL_GetDrawableSize( mainWindow, Fwid'access, Fhit'access );
	glViewport(0,0,Fwid,Fhit);

	put_line( "Drawable: Fwid-X-Fhit : "
		&interfaces.c.int'image(Fwid)&" X "
		& interfaces.c.int'image(Fhit) );

	key_map := sdl_getkeyboardstate(numkeys'access);
	--put_line("...numkeys=" & interfaces.c.int'image(numkeys) ); -- 512
	--myassert( sdl.keyrange'last <= numkeys, 1017 );




	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	-- from the literature it seems I might not have to
	-- call this explicitly because the first texture
	-- unit is the active texture unit, by default.
	-- And I have no multi-texturing needs yet,
	-- like a tarnish on top of an existing texture.
	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)

	glgenbuffers(1, normbuff'address);
	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);



	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );




	-- 6nov14  allow antialiasing if supported:
	glEnable(GL_MULTISAMPLE); -- default setting anyway!



	--minimal error test
	nerr:=dumpGLerrorQueue("first_prep_2");



	level:=0;
	solved(0):=true;
	solved(5):=false;


end first_prep;




----------- 25feb15 addenda begin ----------------------------

	-- size & placement of moving wall-pictures controlled by fancy frag shaders:

	x1picX,x1picY,x2picX, x2picY, x3picX,x3picY, x4picX,x4picY 
		: constant float := 0.0;

	--mountainscape size (3x1=>too big for MacBook):
	x2picws : constant float := 2.0; --3.0;
	x2pichs : constant float := 0.5; --1.0;

	x2picwb : constant float := 3.0; --1.5;
	x2pichb : constant float := 1.0; --0.5;


	x4picw : constant float := 1.5; -- 2.5; --3.0; (too heavy 18dec15)
	x4picH : constant float := 1.0; -- 1.5; --2.0; (too heavy 18dec15)

	x1picW, x1picH : constant float := 1.0;

	x3picws, x3pichs : constant float := 2.5;
	x3picwb, x3pichb : constant float := 2.5;


-- note [original intent of] suffix "b" = big version;  "s" = small version;
-- ...where the small version is a response to jitter (heavy graphical burden)






procedure release_textures is -- prepare to close down
begin

	glext.binding.glDeleteBuffers(1, normbuff'address);
	glext.binding.glDeleteBuffers(1, vertbuff'address);
	glext.binding.glDeleteBuffers(1, rgbbuff'address);
	glext.binding.glDeleteBuffers(1, uvbuff'address);
	glext.binding.glDeleteBuffers(1, elembuff'address);

	gldeletetextures(1, ball_texid'address);
	gldeletetextures(1, room_texid'address);
	gldeletetextures(1, pic_texid'address);

	gldeletetextures(1, xbox1_texid'address);
	gldeletetextures(1, xbox2_texid'address);
	gldeletetextures(1, lining_texid'address);
	gldeletetextures(1, barloc0_texid'address);
	gldeletetextures(1, barloc1_texid'address);
	gldeletetextures(1, granite_texid'address);
	gldeletetextures(1, port_texid'address);
	gldeletetextures(1, cubemap_texid'address);
	gldeletetextures(1, circubemap_texid'address);
	gldeletetextures(1, pfish_texid'address);

------- from beach -----------------------------------
	gldeletetextures(1, frek_texid'address);
	gldeletetextures(1, crab_texid'address);
	gldeletetextures(1, star_texid'address);
	gldeletetextures(1, cgrass_texid'address);
	gldeletetextures(1, tgrass_texid'address);
	gldeletetextures(1, bamb_texid'address);
	gldeletetextures(1, palm_texid'address);
	gldeletetextures(1, tpalm_texid'address);
	gldeletetextures(1, pillar1_texid'address);
	gldeletetextures(1, pillar2_texid'address);
	gldeletetextures(1, rock_texid'address);
	gldeletetextures(1, coco_texid'address);
	gldeletetextures(1, arm_texid'address);
	gldeletetextures(1, island_texid'address);
	gldeletetextures(1, gard_texid'address);
	gldeletetextures(1, nose_texid'address);
	gldeletetextures(1, cpit_texid'address);
	gldeletetextures(1, fishbones_texid'address);
	gldeletetextures(1, mfish_texid'address);
	gldeletetextures(1, bfish_texid'address);
	gldeletetextures(1, rfish_texid'address);
	gldeletetextures(1, sfish_texid'address);
	gldeletetextures(1, snake_texid'address);
	gldeletetextures(1, serpent_texid'address);

	gldeletetextures(1, lean2_texid'address);
	gldeletetextures(1, sos_texid'address);
	gldeletetextures(1, gate0_texid'address);
	gldeletetextures(1, gate_texid'address);
	gldeletetextures(1, pillar1_texid'address);
	gldeletetextures(1, pillar2_texid'address);
	gldeletetextures(1, dhdo_texid'address);
	gldeletetextures(1, dhd0_texid'address);
	gldeletetextures(1, dhd1_texid'address);
	gldeletetextures(1, dhd2_texid'address);
	gldeletetextures(1, dhd3_texid'address);
	gldeletetextures(1, dhd4_texid'address);
	gldeletetextures(1, adobe_texid'address);
	gldeletetextures(1, wood_texid'address);
	gldeletetextures(1, wood2_texid'address);
	gldeletetextures(1, woodt_texid'address);
	gldeletetextures(1, woodw_texid'address);
	gldeletetextures(1, brick_texid'address);
	gldeletetextures(1, turtle_texid'address);
	gldeletetextures(1, turhead_texid'address);

	gldeletetextures(1, lava_texid'address);
	gldeletetextures(1, sok_texid'address);
	gldeletetextures(1, opaqueport_texid'address);
	gldeletetextures(1, offport_texid'address);

	gldeletetextures(1, granite_texid'address);
	gldeletetextures(1, grunge_texid'address);
	gldeletetextures(1, bricksw_texid'address);
	gldeletetextures(1, ava_texid'address);

	gldeletetextures(1, tropical_cubemap_texid'address);
	gldeletetextures(1, blue_cubemap_texid'address);
	gldeletetextures(1, moon_cubemap_texid'address);
	gldeletetextures(1, sunset_cubemap_texid'address);
	gldeletetextures(1, sargas_cubemap_texid'address);






	glext.binding.glDeleteProgram( mpidSkyB );
	glext.binding.glDeleteProgram( mpidSkyW );
	glext.binding.glDeleteProgram( fishTexShadID );
	glext.binding.glDeleteProgram( crabTexShadID );

	glext.binding.glDeleteProgram( mystnontexshadid );
	glext.binding.glDeleteProgram( mystpgmtexshadid );
	glext.binding.glDeleteProgram( gatetexshadid );
	glext.binding.glDeleteProgram( rocktexshadid );
	glext.binding.glDeleteProgram( palmtexshadid );
	glext.binding.glDeleteProgram( nosetexshadid );
	glext.binding.glDeleteProgram( cpittexshadid );
---------- end from beach --------------------------------

	glext.binding.glDeleteProgram( pidskyb );
	glext.binding.glDeleteProgram( pidskyw );
	glext.binding.glDeleteProgram( nontexshadid );
	glext.binding.glDeleteProgram( starshadid );
	glext.binding.glDeleteProgram( star2shadid );
	glext.binding.glDeleteProgram( poolshadid );
	glext.binding.glDeleteProgram( dpoolshadid );
	glext.binding.glDeleteProgram( lpoolshadid );
	glext.binding.glDeleteProgram( rpoolshadid );
	glext.binding.glDeleteProgram( pgmtexshadid );
	glext.binding.glDeleteProgram( tpgmtexshadid );
	glext.binding.glDeleteProgram( wpgmtexshadid );

	glext.binding.glDeleteProgram( firetexshadid );
	glext.binding.glDeleteProgram( x1picshadid );
	glext.binding.glDeleteProgram( x2picshadid );
	glext.binding.glDeleteProgram( x2pic2shadid );
	glext.binding.glDeleteProgram( x3picshadid );
	glext.binding.glDeleteProgram( x3pic2shadid );
	glext.binding.glDeleteProgram( x4picshadid );
	glext.binding.glDeleteProgram( tunshadid3 );
	glext.binding.glDeleteProgram( tunshadid2 );
	glext.binding.glDeleteProgram( tunshadid1 );
	glext.binding.glDeleteProgram( fishtexshadid );
	glext.binding.glDeleteProgram( avatexshadid );

	glext.binding.glDeleteVertexArrays(1, vertexarrayid'address);

end release_textures;



procedure setup_textures is  -- prepare dungeon textures
begin 

	--new fireball (level=3):
	firetexshadid := loadshaders("./data/fireball.vs", "./data/fireball.fs");
	fmatrixid := glgetuniformlocation(firetexshadid, pmvp);
	funiftex  := glgetuniformlocation(firetexshadid, pmyts);
	fopacid  := glgetuniformlocation(firetexshadid, pmyopac);
	ftimeid  := glgetuniformlocation(firetexshadid, ptime);
	firecenid  := glgetuniformlocation(firetexshadid, pwPos);

	fbrad := glgetuniformlocation(firetexshadid, pwRad);

	fbunifside:= glgetuniformlocation(firetexshadid, pside);
	fbunifme  := glgetuniformlocation(firetexshadid, pme);
	fbunifport1:=glgetuniformlocation(firetexshadid,pport1);
	fbunifport2:=glgetuniformlocation(firetexshadid,pport2);

	ball_texid:= loadPng(mirror,"data/explosion.png"); --radial color

	fireballobj.setrect(fireball,j1,j2,j3,j4,j5,j6);






	--cartoon palmTree
	x1picshadid := loadshaders("data/picZ.vs", "data/palmTreeWindmill.fs");
	x1pictimeid := glgetuniformlocation(x1picshadid, ptime);
	x1picresid  := glgetuniformlocation(x1picshadid, presol);
	x1picmatid  := glgetuniformlocation(x1picshadid, pmvp);
	x1picradid  := glgetuniformlocation(x1picshadid, pwRad);
	x1piccenid  := glgetuniformlocation(x1picshadid, pwPos);
	--------------------------------------------------------------
	x1unifside := glgetuniformlocation(x1picshadid, pside);
	x1unifme  := glgetuniformlocation(x1picshadid, pme);
	x1unifport1:=glgetuniformlocation(x1picshadid,pport1);
	x1unifport2:=glgetuniformlocation(x1picshadid,pport2);



	--waterworld
	x2picshadid := loadshaders("data/picZ.vs", "data/waterworldCCNCSA3.fs");
	x2pictimeid := glgetuniformlocation(x2picshadid, ptime);
	x2picresid  := glgetuniformlocation(x2picshadid, presol);
	x2picmatid  := glgetuniformlocation(x2picshadid, pmvp);
	x2picradid  := glgetuniformlocation(x2picshadid, pwRad);
	x2piccenid  := glgetuniformlocation(x2picshadid, pwPos);
	--------------------------------------------------------------
	x2unifside := glgetuniformlocation(x2picshadid, pside);
	x2unifme  := glgetuniformlocation(x2picshadid, pme);
	x2unifport1:=glgetuniformlocation(x2picshadid,pport1);
	x2unifport2:=glgetuniformlocation(x2picshadid,pport2);



	--mountainscape
	x2pic2shadid := loadshaders("data/picZ.vs", "data/mountainscape.fs");

	x2pic2timeid := glgetuniformlocation(x2pic2shadid, ptime);
	x2pic2resid  := glgetuniformlocation(x2pic2shadid, presol);
	x2pic2matid  := glgetuniformlocation(x2pic2shadid, pmvp);
	x2pic2radid  := glgetuniformlocation(x2pic2shadid, pwRad);
	x2pic2cenid  := glgetuniformlocation(x2pic2shadid, pwPos);
	--------------------------------------------------------------
	x22unifside := glgetuniformlocation(x2pic2shadid, pside);
	x22unifme  := glgetuniformlocation(x2pic2shadid, pme);
	x22unifport1:=glgetuniformlocation(x2pic2shadid,pport1);
	x22unifport2:=glgetuniformlocation(x2pic2shadid,pport2);



	--DaliClock
	x3picshadid := loadshaders("data/picZfog.vs", "data/bwClock.fs");

	x3pictimeid := glgetuniformlocation(x3picshadid, ptime);
	x3picresid  := glgetuniformlocation(x3picshadid, presol);

	x3picmatid  := glgetuniformlocation(x3picshadid, pmvp);
	x3picmvid  := glgetuniformlocation(x3picshadid, pmv);

	x3picradid  := glgetuniformlocation(x3picshadid, pwRad);
	x3piccenid  := glgetuniformlocation(x3picshadid, pwPos);
	--------------------------------------------------------------
	x3unifside := glgetuniformlocation(x3picshadid, pside);
	x3unifme  := glgetuniformlocation(x3picshadid, pme);
	x3unifport1:=glgetuniformlocation(x3picshadid,pport1);
	x3unifport2:=glgetuniformlocation(x3picshadid,pport2);



	--MagmaPlanet
	x3pic2shadid := loadshaders("data/picZfog.vs", "data/redPlanet.fs");
	x3pic2timeid := glgetuniformlocation(x3pic2shadid, ptime);
	x3pic2resid  := glgetuniformlocation(x3pic2shadid, presol);

	x3pic2matid  := glgetuniformlocation(x3pic2shadid, pmvp);
	x3pic2mvid  := glgetuniformlocation(x3pic2shadid, pmv);

	x3pic2radid  := glgetuniformlocation(x3pic2shadid, pwRad);
	x3pic2cenid  := glgetuniformlocation(x3pic2shadid, pwPos);
	--------------------------------------------------------------
	x32unifside := glgetuniformlocation(x3pic2shadid, pside);
	x32unifme  := glgetuniformlocation(x3pic2shadid, pme);
	x32unifport1:=glgetuniformlocation(x3pic2shadid,pport1);
	x32unifport2:=glgetuniformlocation(x3pic2shadid,pport2);


	--spinning Galaxy
	x4picshadid := loadshaders("data/picZ.vs", "data/blueSpiral.fs");
	x4pictimeid := glgetuniformlocation(x4picshadid, ptime);
	x4picresid  := glgetuniformlocation(x4picshadid, presol);
	x4picmatid  := glgetuniformlocation(x4picshadid, pmvp);
	x4picradid  := glgetuniformlocation(x4picshadid, pwRad);
	x4piccenid  := glgetuniformlocation(x4picshadid, pwPos);
	--------------------------------------------------------------
	x4unifside := glgetuniformlocation(x4picshadid, pside);
	x4unifme  := glgetuniformlocation(x4picshadid, pme);
	x4unifport1:=glgetuniformlocation(x4picshadid,pport1);
	x4unifport2:=glgetuniformlocation(x4picshadid,pport2);


-------------------- 25feb15 addenda end ---------------------------


	nontexshadid := loadshaders("./data/nontex.vs", "./data/nontex.fs");
	ntmatrixid := glgetuniformlocation(nontexshadid, pmvp);


	--to Island:

	-- back to Island:
	tunshadid3 := loadshaders("./data/tunnelstars.vs", "./data/tunnelstars.fs");
	-- great rotating star universe;  a lost-in-space feel (not a wormhole feel).

	-- from Island:
	tunshadid1 := loadshaders("./data/tunnelstars.vs", "./data/mystartunnel.fs");
	-- forward thru a rotating colored star tunnel with wormhole feel.

---------------------------------------------------------------------------------

	-- dungeon local:
	--tunshadid2 := loadshaders("./data/tunnelstars.vs", "./data/myswiss2.fs");
	-- forward thru a rotating swiss cheese cavern
	-- awesome, but graphically heavier than myspiral.fs

	-- dungeon local:
	tunshadid2 := loadshaders("./data/tunnelstars.vs", "./data/myspiral.fs");
	-- very nice too;  great lightweight color spiral (no stars)

---------------------------------------------------------------------------------


	tuntimeid1 := glgetuniformlocation(tunshadid1, ptime); -- need glint
	tunresid1  := glgetuniformlocation(tunshadid1, presol);
	tunmatid1  := glgetuniformlocation(tunshadid1, pmvp);

	tuntimeid2 := glgetuniformlocation(tunshadid2, ptime);
	tunresid2  := glgetuniformlocation(tunshadid2, presol);
	tunmatid2  := glgetuniformlocation(tunshadid2, pmvp);

	tuntimeid3 := glgetuniformlocation(tunshadid3, ptime);
	tunresid3  := glgetuniformlocation(tunshadid3, presol);
	tunmatid3  := glgetuniformlocation(tunshadid3, pmvp);




	--very nice black&white clouds in a black sky (lightweight)
	star2shadid := loadshaders("./data/skyX.vs", "./data/bw2clouds.fs"); --gluint
	star2timeid := glgetuniformlocation(star2shadid, ptime); -- need glint
	star2resid  := glgetuniformlocation(star2shadid, presol);
	star2matid  := glgetuniformlocation(star2shadid, pmvp);

	-- portal-exterior discard uniforms
	sunifside := glgetuniformlocation(star2shadid, pside);
	sunifme  := glgetuniformlocation(star2shadid, pme);
	sunifport1:=glgetuniformlocation(star2shadid,pport1);
	sunifport2:=glgetuniformlocation(star2shadid,pport2);




	--preferred colored stars in moving galaxy clouds
	starshadid := loadshaders("./data/skyX.vs", "./data/starfield3.fs"); --gluint
	startimeid := glgetuniformlocation(starshadid, ptime); -- need glint
	starresid  := glgetuniformlocation(starshadid, presol);
	starmatid  := glgetuniformlocation(starshadid, pmvp);

	-- portal-exterior discard uniforms
	stunifside := glgetuniformlocation(starshadid, pside);
	stunifme  := glgetuniformlocation(starshadid, pme);
	stunifport1:=glgetuniformlocation(starshadid,pport1);
	stunifport2:=glgetuniformlocation(starshadid,pport2);




-- fish begin -------------------------------------------------------------
	fishtexshadid := loadshaders("./data/fishw2.vs","./data/fish.fs");
	fishmatrixid := glgetuniformlocation(fishtexshadid, pmvp);
	fishuniftime := glgetuniformlocation(fishtexshadid, pmytime);
	fcenid       := glgetuniformlocation(fishtexshadid, pwPos);

	fishunifrad  := glGetUniformLocation( fishTexShadID, prad );     
	fishunifsvel := glGetUniformLocation( fishTexShadID, psvel );     
	fishunifwvel := glGetUniformLocation( fishTexShadID, pwvel );     
	fishunifwamp := glGetUniformLocation( fishTexShadID, pwamp );

	fishunifrot := glGetUniformLocation( fishTexShadID, prot ); --28jan17

------ fish.fs:

	fishuniftex  := glgetuniformlocation(fishtexshadid, pmyts);

	-- portal-exterior discard uniforms (fish.fs)
	funifside := glgetuniformlocation(fishtexshadid, pside);
	funifme  := glgetuniformlocation(fishtexshadid, pme);
	funifport1:=glgetuniformlocation(fishtexshadid,pport1);
	funifport2:=glgetuniformlocation(fishtexshadid,pport2);



-- fish end -------------------------------------------------------------



	poolshadid := loadshaders("./data/poolobjFog.vs","./data/myBlueWaterFog.fs");
	poolmvid := glgetuniformlocation(poolshadid, pmv);
	poolmatid := glgetuniformlocation(poolshadid, pmvp);
	timeid    := glgetuniformlocation(poolshadid, pmytime);
	wlevid    := glgetuniformlocation(poolshadid, pwaterlevel);
	pradid    := glgetuniformlocation(poolshadid, pwRad);
	pcenid    := glgetuniformlocation(poolshadid, pwPos);

	bunifside := glgetuniformlocation(poolshadid, pside);
	bunifme  := glgetuniformlocation(poolshadid, pme);
	bunifport1:=glgetuniformlocation(poolshadid,pport1);
	bunifport2:=glgetuniformlocation(poolshadid,pport2);


	dpoolshadid := loadshaders("./data/poolobjFog.vs","./data/darkwater3Fog.fs");
	dpoolmvid := glgetuniformlocation(dpoolshadid, pmv);
	dpoolmatid := glgetuniformlocation(dpoolshadid, pmvp);
	dtimeid    := glgetuniformlocation(dpoolshadid, pmytime);
	dwlevid    := glgetuniformlocation(dpoolshadid, pwaterlevel);
	dpradid    := glgetuniformlocation(dpoolshadid, pwRad);
	dpcenid    := glgetuniformlocation(dpoolshadid, pwPos);

	dunifside := glgetuniformlocation(dpoolshadid, pside);
	dunifme  := glgetuniformlocation(dpoolshadid, pme);
	dunifport1:=glgetuniformlocation(dpoolshadid,pport1);
	dunifport2:=glgetuniformlocation(dpoolshadid,pport2);


	lava_texid := loadPng(mirror,"data/explosion.png");

	-- simpler but still nice wave function with explosion.png mapped colors:
	--lpoolshadid := loadshaders("./data/lavaFog3.vs", "./data/lavaFog.fs");
	-- this is my choice for narbacular drop lava pools !

	-- complex wave ftn with explosion.png mapped colors:
	--lpoolshadid := loadshaders("./data/lavaFog2.vs", "./data/lavaFog.fs");

	-- original circular wave ftn with fancy frag shader:
	lpoolshadid := loadshaders("./data/lavaFog.vs", "./data/volcanoFog.fs");

	lpoolmvid := glgetuniformlocation(lpoolshadid, pmv);
	lpoolmatid := glgetuniformlocation(lpoolshadid, pmvp);
	lresid  := glgetuniformlocation(lpoolshadid, presol);
	ltimeid := glgetuniformlocation(lpoolshadid, pmytime);
	lwlevid := glgetuniformlocation(lpoolshadid, pwaterlevel);
	lpradid := glgetuniformlocation(lpoolshadid, pwRad);
	lpcenid := glgetuniformlocation(lpoolshadid, pwPos);

	lunifside := glgetuniformlocation(lpoolshadid, pside);
	lunifme  := glgetuniformlocation(lpoolshadid, pme);
	lunifport1:=glgetuniformlocation(lpoolshadid,pport1);
	lunifport2:=glgetuniformlocation(lpoolshadid,pport2);



	wpgmtexshadid := loadshaders("./data/texobjFog.vs", "./data/texobjFog.fs");
	wmvid := glgetuniformlocation(wpgmtexshadid, pmv);
	wmatrixid := glgetuniformlocation(wpgmtexshadid, pmvp);
	wuniftex  := glgetuniformlocation(wpgmtexshadid, pmyts);




------- begin typical shaders with lighting ------------------------------------
	--pgmtexshadid := loadshaders("./data/texobjFog.vs", "./data/texobjHalf.fs");
	pgmtexshadid := loadshaders("./data/texobjFog2.vs", "./data/texobjHalf2.fs");
	unifprad:= glgetuniformlocation(pgmtexshadid,pprad); 
	unifisel:= glgetuniformlocation(pgmtexshadid,pisel); 
	unifport1:=glgetuniformlocation(pgmtexshadid,pport1);
	unifport2:=glgetuniformlocation(pgmtexshadid,pport2);
	mvid := glgetuniformlocation(pgmtexshadid, pmv);
	matrixid := glgetuniformlocation(pgmtexshadid, pmvp);
	uniftex  := glgetuniformlocation(pgmtexshadid, pmyts);
	uniflev  := glgetuniformlocation(pgmtexshadid, pmylev);
	unifopac := glgetuniformlocation(pgmtexshadid, popac); --to reduce opacity

	unifside := glgetuniformlocation(pgmtexshadid, pside);
	unifme  := glgetuniformlocation(pgmtexshadid, pme);

	---------------------- begin lighting effects addendum ----------------------
	uniflag := glgetuniformlocation(pgmtexshadid, pflag); --lightingEffects flag
	-- set to zero unless object defines normals

	unifpcol := glgetuniformlocation(pgmtexshadid, ppcolor);
	unifpos1 := glgetuniformlocation(pgmtexshadid, ppos1);
	unifpos2 := glgetuniformlocation(pgmtexshadid, ppos2);
	unifpos3 := glgetuniformlocation(pgmtexshadid, ppos3);


------- end typical lighting shaders -------------------------------------------





------- begin turtle shaders ------------------------------------
	tpgmtexshadid := loadshaders("./data/turtle.vs", "./data/turtle.fs");
	tmvid := glgetuniformlocation(tpgmtexshadid, pmv);      -- vs3
	tmatrixid := glgetuniformlocation(tpgmtexshadid, pmvp); -- vs2
	tuniftex  := glgetuniformlocation(tpgmtexshadid, pmyts); -- fs1

	tfcenid   := glgetuniformlocation(tpgmtexshadid, pwPos); -- vs5
	tfangid   := glgetuniformlocation(tpgmtexshadid, pangl); -- vs6

	tuniflev  := glgetuniformlocation(tpgmtexshadid, pmylev); --FOG fs11

	-- portal-exterior-discard uniforms
	tunifside := glgetuniformlocation(tpgmtexshadid, pside); -- fs7
	tunifme  := glgetuniformlocation(tpgmtexshadid, pme); -- fs10
	tunifport1:=glgetuniformlocation(tpgmtexshadid,pport1);
	tunifport2:=glgetuniformlocation(tpgmtexshadid,pport2);


	---------------------- begin lighting effects addendum ----------------
	tuniflag := glgetuniformlocation(tpgmtexshadid, pflag); -- flag fs2 vs4
	-- set to zero unless object defines normals
	-- and lighting effects are desired

	tunifpcol := glgetuniformlocation(tpgmtexshadid, ppcolor); -- fs3
	tunifpos1 := glgetuniformlocation(tpgmtexshadid, ppos1); -- fs4
	tunifpos2 := glgetuniformlocation(tpgmtexshadid, ppos2); -- fs5
	tunifpos3 := glgetuniformlocation(tpgmtexshadid, ppos3); -- fs6
	---------------------- end lighting effects addendum ----------------

------- end turtle shaders --------------------------------------

	turtle_texid := loadPng(mirror,"data/turtbody2.png"); 
	turhead_texid := loadPng(mirror,"data/turthead4.png"); 

	turtleobj.setround(turtle, 0.4, 0.3, 0.5);
	turtleobj.setround(turhead, 0.1, 0.05, 0.2);

	-- 16 uniforms 11fs, 6vs (1 used twice)












	-- level 2 reflective pool:
	rpoolshadid := loadshaders("./data/lvwater2Fog.vs", "./data/lvwater2Fog.fs");
	envmapid   := glgetuniformlocation(rpoolshadid, penvmap);
	rpeyeid    := glgetuniformlocation(rpoolshadid, peyePos);
	rpoolmvid := glgetuniformlocation(rpoolshadid, pmv);
	rpoolmatid := glgetuniformlocation(rpoolshadid, pmvp);
	rtimeid    := glgetuniformlocation(rpoolshadid, pmytime);
	rwlevid    := glgetuniformlocation(rpoolshadid, pwaterlevel);
	rpradid    := glgetuniformlocation(rpoolshadid, pwRad);
	rpcenid    := glgetuniformlocation(rpoolshadid, pwPos);

	runifside := glgetuniformlocation(rpoolshadid, pside);
	runifme  := glgetuniformlocation(rpoolshadid, pme);
	runifport1:=glgetuniformlocation(rpoolshadid,pport1);
	runifport2:=glgetuniformlocation(rpoolshadid,pport2);


	-- level 2 reflective pool;  
	-- Here, only used as reflective environment, but not drawn.
	-- ...in this case, a close match to actual environment...
	cubemap_texid := loadCubePng(
	"data/woodenceiling2.png",	"data/woodenceiling2.png",
	"data/grungeRGBA.png",	   "data/grungeRGBA.png",
	"data/woodenceiling2.png", "data/grungeRGBA.png");



------ begin level 5 epilog setup ----------------------------------------------

	-- pretty awesome:
	-- used as reflective environment, but also drawn
	circubemap_texid := loadCubePng(
	"data/skyBoxes/totality/ft.png",	"data/skyBoxes/totality/bk.png",
	"data/skyBoxes/totality/upmsg.png",	"data/skyBoxes/totality/dn.png",
	"data/skyBoxes/totality/rt.png",	"data/skyBoxes/totality/lf.png"	);


	pidskyb := loadshaders("./data/osky.vs", "./data/osky.fs");
	sbmvpuid := glgetuniformlocation(pidskyb, pmvp);
	sbmapuid := glgetuniformlocation(pidskyb, pcubemap);

	pidskyw := loadshaders("./data/sundown4.vs", "./data/sundown.fs");
	cmvpuid  := glgetuniformlocation(pidskyw, pmvp);
	ctimeid  := glgetuniformlocation(pidskyw, pmytime);
	cwlevid  := glgetuniformlocation(pidskyw, pwaterlevel);
	cpeyeid  := glgetuniformlocation(pidskyw, peyePos);
	cemuid   := glgetuniformlocation(pidskyw, penvMap);

------ end level 5 epilog setup ------------------------------------------------



-- load textures used in all levels:


	lining_texid := loadPng(mirror,"data/bricksr.png");

	sok_texid := loadPng(mirror,"data/granitergb.png");

	opaqueport_texid := loadPng(mirror,"data/stargate_opaque.png");
	port_texid := loadPng(mirror,"data/stargate_texture.png");
	offport_texid := loadPng(mirror,"data/stargate_off.png");
	xbox1_texid := loadPng(mirror,"data/illusion2.png");
	--xbox2_texid := loadPng(mirror,"data/door.png");
	xbox2_texid := loadPng(mirror,"data/itardis.png");
	barloc0_texid:= loadPng(mirror,"data/stargate_off.png");
	barloc1_texid:= loadPng(mirror,"data/stargate_texture.png");

	granite_texid  := loadPng(mirror,"data/granitergb.png");
	grunge_texid := loadPng(mirror,"data/grungeRGBA.png");

	bricksw_texid  := loadPng(mirror,"data/bricksq.png");
	woodw_texid := loadPng(mirror,"data/woodenceilingW.png");
	woodt_texid := loadPng(mirror,"data/woodenceilingT.png");
	wood2_texid := loadPng(mirror,"data/woodenceiling2.png");


	adobe_texid := loadPng(mirror,"data/wallT.png"); 
	--dark, contrasting adobe

	pfish_texid  := loadPng(mirror,"data/p1.png");

	-- ...and these 3 others are loaded dynamically (per level):
	-- room_texid,  pic_texid, ceil_texid



---- ava begin ----------------------------

	avaTexShadID:=LoadShaders("./data/avatarobj.vs","./data/avatarobj.fs");
	avaunifmat := glGetUniformLocation( avaTexShadID, pmvp );     
	avaunifcen := glGetUniformLocation(avaTexShadID, pwpos); --// vec3
	avaunifang := glgetuniformlocation(avatexshadid, phori); --horiAng
	avauniftime := glGetUniformLocation( avaTexShadID, pmytime );
	avaunifdir := glGetUniformLocation( avaTexShadID, pmydir );
	avaunifade := glGetUniformLocation( avaTexShadID, pmyfade );
	avainterior := glGetUniformLocation( avaTexShadID, pinterior );
	avauniftex := glGetUniformLocation( avaTexShadID, pmyts );
	ava_texid := loadPng(mirror,"data/skin.png"); --very good, dark clothes

	avatarobj.setrect(ava);


end setup_textures; -----------------------------------------------







procedure drawroom(
	numport: integer; -- 0, 1, 2
	insideportal: boolean := false;
	avx,avy,avz,angl : float
) is

	dxp,dzp : float := 0.0;
	isel : glint := 0;

	ballsec: float;
	ibsec,ii,kk: integer;
	nslic: constant integer := 1000; --partitions per direction
	xfb1 : constant float := -xmax+barrad;       -- one end
	xfb2 : constant float := +xmax-barrad;       -- other end
	xx,yy,zz : float;

begin


	-- 5pgs to end if:
	if level<5 then  -- in-a-dungeon with many textured objects in common


		if thirdPerson then
			drawAvatar(currenttime, avx,avy,avz,angl);
		end if;



		if not insideportal then -- typically invisible if insideportal


		--draw barrels
		glUseProgram(nontexshadid);

		for i in 1..nbarrels loop

			bmvp := mvp;

			if rolling(i) then
				barreltime := float(sdl_getticks)/1000.0;
				tt := float( barreltime - timeofroll ) / secperroll;
				barangle := onepi*tt*rad2deg;

				if( tt<1.0 ) then
					posbar(i)(1):=olbarrl(1)+tt*(nubarrl(1)-olbarrl(1));
					posbar(i)(2):=olbarrl(2)+tt*(nubarrl(2)-olbarrl(2));
					posbar(i)(3):=olbarrl(3)+tt*(nubarrl(3)-olbarrl(3));

					if    (rolldir=-1) then axis:=xaxis; barangle:=-barangle;
					elsif (rolldir=+1) then axis:=xaxis;
					elsif (rolldir=+3) then axis:=zaxis; barangle:=-barangle;
					elsif (rolldir=-3) then axis:=zaxis;
					end if;

					cyl2obj.updcyl2(barrel(i), 
						posbar(i)(1),posbar(i)(2),posbar(i)(3));

					bmm:=identity;
					translate(bmm, -posbar(i)(1), -posbar(i)(2), -posbar(i)(3) );
					myrotate(bmm, barangle, axis(1), axis(2), axis(3) );
					translate(bmm, posbar(i)(1), posbar(i)(2), posbar(i)(3) );

					bmvp := bmm;
					mymatmult( bmvp, vm );
					mymatmult( bmvp, pm );

				else
					rolling(i):=false;
					posbar(i):=nubarrl;

					cyl2obj.updcyl2(barrel(i), 
						posbar(i)(1),posbar(i)(2),posbar(i)(3));

				end if; -- tt

			end if; -- rolling

			-- we have to register bmvp for each i AFTER it is redefined:
			gluniformmatrix4fv( ntmatrixid, 1, gl_false, bmvp(1,1)'address );
			cyl2obj.draw(barrel(i),vertbuff,rgbbuff,elembuff, seated(i)); -- 2jul15


		end loop;
		end if; -- not insideportal



	-- begin draw common textured objects-----------------------------------------


	glUseProgram( pgmtexshadid );

		glUniform1i(unifside, glint(numport) );

		if thirdPerson then
			glUniform3f(unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
		else
			glUniform3f(unifme, glfloat(xme),glfloat(yme),glfloat(zme));
		end if;

		--new portal-hole setup: puts hole in wall about size of portal,
		--however, "holes" are actually prolate spheroids of transparency;
		--Be careful because we risk erasing any nearby objects in 3D

		glUniform3f(unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
		--center p1 (left)

		glUniform3f(unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 
		--center p2 (right)


		if 
			(
				worm_active
				or (lshooting and rport_defined)
				or (rshooting and lport_defined)
			)
		then
			glUniform1f(unifprad, glfloat(0.80) ); --radius (show holes, danger)

			if rport_defined and lport_defined then
				glUniform1i(unifisel, 3 ); -- 0=>none, 3=>both, 1=>1, 2=>2
			elsif rport_defined then
				glUniform1i(unifisel, 2 ); -- 0=>none, 3=>both, 1=>1, 2=>2
			elsif lport_defined then
				glUniform1i(unifisel, 1 ); -- 0=>none, 3=>both, 1=>1, 2=>2
			end if;

		else
			glUniform1f(unifprad, glfloat(0.0) ); --radius (hide holes, no danger)
			glUniform1i(unifisel, 0 ); -- 0=>none, 3=>both, 1=>1, 2=>2
		end if;



		gluniformmatrix4fv( mvid, 1, gl_false, mv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, mvp(1,1)'address );
		gluniform1i(uniftex,0);
		gluniform1i(uniflev, interfaces.c.int(level-1) );
		gluniform1i(unifopac, 1); -- 1=>normal opacity

		glbindtexture(gl_texture_2d, room_texid);

		if level=3 then
			--note:  this can remain here IF I can combine rufas-shaders 
			--       with the default shaders for pgmtexshadid  DONE
			gluniform1i(uniflag, 1); -- 1=> lightingEffects;  0=> normal


			--3 light sources within lava pool (?pcen=poolcenter)
			gluniform3f( unifpos1, glfloat(xpcen), glfloat(waterlevel+1.0), glfloat(zpcen) );
			gluniform3f(unifpos2,glfloat(xpcen+xprad/3.0),glfloat(waterlevel+1.0),glfloat(zpcen) );
			gluniform3f(unifpos3,glfloat(xpcen-xprad/3.0),glfloat(waterlevel+1.0),glfloat(zpcen) );

			-- color of light
			gluniform3f( unifpcol, 254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange


			mroomobj.ldraw(rmo,vertbuff,uvbuff,normbuff,elembuff); 
			--textured room with floor-gap AND LightEffects

		else
			gluniform1i(uniflag, 0); -- 1=> lightingEffects;  0=> normal
			mroomobj.draw(rmo,vertbuff,uvbuff,elembuff); --textured room with floor-gap
		end if;

		glUniform1f(unifprad, glfloat(0.0) ); --radius (disable further holes)
		glUniform1i(unifisel, 0 ); -- 0=>none, 3=>both, 1=>1, 2=>2



		if not insideportal then -- typically invisible if insideportal

			if portalEnabled then
				glbindtexture(gl_texture_2d, barloc1_texid);
			else
				glbindtexture(gl_texture_2d, barloc0_texid);
			end if;

			-- draw receptacles (using pgmtexshadid)
			for row in 1..nrows loop
				for col in 1..ncols loop
					if( rcpt(row,col) = true ) then
						pictobj.draw( sokrcpt(row,col), vertbuff, uvbuff, elembuff );
						-- note:  these are out of range of lighting effects in level 3
					end if;
				end loop;
			end loop;

		end if; -- not insideportal









		if level=2 then
			glbindtexture(gl_texture_2d, grunge_texid);
			pictobj.draw(bloc2, vertbuff,uvbuff,elembuff); --block wall divider

			glbindtexture(gl_texture_2d, wood2_texid);
			cylobj.draw(cyl,vertbuff,uvbuff,elembuff); 
			-- new edge of ceiling (normal shader needed)


		elsif level=3 then
			glbindtexture(gl_texture_2d, woodw_texid);
			pictobj.ldraw(bloc2, vertbuff,uvbuff,normbuff,elembuff); --block wall divider
		elsif level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); --  lev1, dark adobe wall
			rectobj.draw(bloc, vertbuff,uvbuff,elembuff); --block wall divider
		elsif level=4 then
			glbindtexture(gl_texture_2d, bricksw_texid); -- for lev 4
			rectobj.draw(bloc, vertbuff,uvbuff,elembuff); --block wall divider
		end if;

		if level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); -- dark adobe for ledge
		else
			glbindtexture(gl_texture_2d, woodw_texid);
		end if;
		if level=3 then
			rectobj.ldraw(ledge,  vertbuff,uvbuff,normbuff,elembuff); -- high ledge platform
		else
			rectobj.draw(ledge,  vertbuff,uvbuff,elembuff); -- high ledge platform
		end if;

		-- level#3: ceil matches walls;   4: special fragshader
		if level=1 then 
			glbindtexture(gl_texture_2d, ceil_texid);
			rectobj.draw(ceil1,  vertbuff,uvbuff,elembuff); -- ceiling
		elsif level=2 then
			glbindtexture(gl_texture_2d, grunge_texid); -- best 4 reflective water
			pictobj.draw(ceil2,  vertbuff,uvbuff,elembuff); -- ceiling
		end if;


		if (level=1) or (level=4) then
			glbindtexture(gl_texture_2d, pic_texid);
			pictobj.draw(pic,  vertbuff,uvbuff,elembuff); -- wall picture
		end if;


		-- Brick Lining of Pool
		glbindtexture(gl_texture_2d, lining_texid);

		if level=3 then
			rectobj.ldraw(pxp, vertbuff,uvbuff,normbuff,elembuff); --@+X
			rectobj.ldraw(pxm, vertbuff,uvbuff,normbuff,elembuff); --@-X
			rectobj.ldraw(pzp, vertbuff,uvbuff,normbuff,elembuff); --@+Z
			rectobj.ldraw(pzm, vertbuff,uvbuff,normbuff,elembuff); --@-Z
			rectobj.ldraw(pym, vertbuff,uvbuff,normbuff,elembuff); --@bottom
		else
			rectobj.draw(pxp, vertbuff,uvbuff,elembuff); --@+X
			rectobj.draw(pxm, vertbuff,uvbuff,elembuff); --@-X
			rectobj.draw(pzp, vertbuff,uvbuff,elembuff); --@+Z
			rectobj.draw(pzm, vertbuff,uvbuff,elembuff); --@-Z
			rectobj.draw(pym, vertbuff,uvbuff,elembuff); --@bottom
		end if;







		if not xit or showskulls then --skull descending
			glbindtexture(gl_texture_2d, xbox1_texid);
			twictobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box
		else -- door ascending
			glbindtexture(gl_texture_2d, xbox2_texid);
			twictobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box
		end if;







		--draw portals
		if lport_located and lport_stable and lport_defined then
			glbindtexture(gl_texture_2d, offport_texid);
			pict1obj.draw(lportal, vertbuff,uvbuff,elembuff);
		end if;
		if rport_located and rport_stable and rport_defined then
			glbindtexture(gl_texture_2d, offport_texid);
			pict1obj.draw(rportal, vertbuff,uvbuff,elembuff);
		end if;




		-- draw sokoban walls here
		if level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); --dark adobe
		elsif level=2 then
			glbindtexture(gl_texture_2d, woodt_texid);
		elsif level=3 then
			glbindtexture(gl_texture_2d, brick_texid);
		else
			glbindtexture(gl_texture_2d, sok_texid);
		end if;

		-- draw walls made up of short cubes (still using pgmtexshadid)
		for row in 1..nrows loop
			for col in 1..ncols loop
				-- if post exists here, draw short cube
				if( wall(row,col) = true ) then
					if level=3 then
						rectobj.ldraw( sokwall(row,col), vertbuff, uvbuff, normbuff, elembuff );
					else
						rectobj.draw( sokwall(row,col), vertbuff, uvbuff, elembuff );
					end if;
				end if;
			end loop;
		end loop;



		-- Window or wall picture frame
		glbindtexture(gl_texture_2d, grunge_texid);
		frameobj.ldraw(nfox,vertbuff,uvbuff,normbuff,elembuff);
		frameobj.ldraw(sfox,vertbuff,uvbuff,normbuff,elembuff);
		-- in case of problem, use ldraw only in level 3


	end if; -- in-a-dungeon (level < 5) (5pgs up)


---------- end draw textured objects common to all levels ---------------




	--draw pools and other objects that use special shaders (from glsl sandbox)

--########################################################################
		if (level=1) then

---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID);

		--portal-exterior discard:
			glUniform1i(funifside, glint(numport) );

			if thirdPerson then
				glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;



			glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			gluniform1i(fishunifrot,1); -- 1=>CW,  -1=>CCW (28jan17)
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------


			-- fancy frag shader draws normal water in level 1
			glUseProgram( poolshadid );

			glUniform1i(bunifside, glint(numport) );


			if thirdPerson then
				glUniform3f(bunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(bunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(bunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(bunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 



			gluniformmatrix4fv( poolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( poolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(timeid, glfloat(currentTime) );
			gluniform3f(pcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(pradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(wlevid, glfloat(waterlevel) );
			rectsurf.draw(rso,vertbuff);



			--PalmTreeWindmill
			glUseProgram( x1picshadid );

			glUniform1i(x1unifside, glint(numport) );

			if thirdPerson then
				glUniform3f(x1unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x1unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x1unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x1unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( x1picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x1pictimeid, glfloat(currentTime) );
			gluniform2f(x1piccenid, glfloat(x1picx), glfloat(x1picy) );
			gluniform2f(x1picradid, glfloat(x1picw/2.0), glfloat(x1pich/2.0) );
			gluniform2f(x1picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);


--########################################################################
		elsif (level=2) then -- reflective water



---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID);

		--portal-exterior discard:
			glUniform1i(funifside, glint(numport) );


			if thirdPerson then
				glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			gluniform1i(fishunifrot,1); -- 1=>CW,  -1=>CCW (28jan17)
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------








			glUseProgram( rpoolshadid );

			glUniform1i(runifside, glint(numport) );

			if thirdPerson then
				glUniform3f(runifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(runifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(runifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(runifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			-- define cubemapped textures to reflect:
			glenable(gl_texture_cube_map_seamless);
			glbindtexture(gl_texture_cube_map, cubemap_texid);
			-- note:  this is essentially a "cheat".  I really want
			--        to use the actual environment!
			gluniform1i(envmapid, 0); -- "envMap" in lvwater.fs
			gluniformmatrix4fv( rpoolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( rpoolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(rtimeid, glfloat(currentTime) );
			gluniform3f(rpeyeid, glfloat(xme), glfloat(yme), glfloat(zme) );
			gluniform3f(rpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(rpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(rwlevid, glfloat(waterlevel) );

			reflsurf.draw(rfo,vertbuff);





			--WaterWorld
			glUseProgram( x2picshadid );

			glUniform1i(x2unifside, glint(numport) );


			if thirdPerson then
				glUniform3f(x2unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x2unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x2unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x2unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( x2picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x2pictimeid, glfloat(currentTime) );
			gluniform2f(x2piccenid, glfloat(x2picx), glfloat(x2picy) );
			gluniform2f(x2picradid, glfloat(x2picwb/2.0), glfloat(x2pichb/2.0) );
			gluniform2f(x2picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);

			--MountainScape
			glUseProgram( x2pic2shadid );

			glUniform1i(x22unifside, glint(numport) ); 

			if thirdPerson then
				glUniform3f(x22unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x22unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x22unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x22unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( x2pic2matid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x2pic2timeid, glfloat(currentTime) );
			gluniform2f(x2pic2cenid, glfloat(x2picx), glfloat(x2picy) );
			gluniform2f(x2pic2radid, glfloat(x2picws/2.0), glfloat(x2pichs/2.0) );
			gluniform2f(x2pic2resid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox2,vertbuff,elembuff);


			-- fancy fragshader draws star ceiling
			glUseProgram( star2shadid );
			gluniformmatrix4fv( star2matid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(star2timeid, glfloat(currentTime) );
			gluniform2f(star2resid, glfloat(winwidth), glfloat(winheight) );

			--window-discard:
			glUniform1i(sunifside, glint(numport) );
			if thirdPerson then
				glUniform3f(sunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(sunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;
			glUniform3f(sunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(sunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			rectxobj.draw(rox,vertbuff,elembuff);





--########################################################################
		elsif (level=3) then  -- volcano

----------- fireball begin --------------------------------------------



			glUseProgram(fireTexShadID);
			glUniform1i(funiftex, 0);
			glUniform1f(fopacid, 0.9);

			glUniform1f(fbrad, glfloat(barrad));

			--window-discard:
			glUniform1i(fbunifside, glint(numport) );

			if thirdPerson then
				glUniform3f(fbunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(fbunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(fbunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(fbunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 



			glBindTexture(GL_TEXTURE_2D, ball_texid);


-- define trajectory of fireball before the following code to move it
-- want circum = 1.0 = 2piR => R=1/twopi
-- Appx:  z=2,  y=rad,   x in (-8..+8),  @ 2 unit per second => 8 sec per dir
-- make 200 time slices, 100 each way
--

			-- begin fireball roll ------------------------------------------------------------
			BMVP := MVP;
			ballsec := 0.06*float(sdl_getticks);
			ibsec := integer( ballsec );
			kk:= ibsec/nslic;
			ii:= 1 + ibsec mod nslic; -- 1..nslic = 1..1000
			if (kk mod 2 = 1) then
				null;
			else
				ii:= 1 + nslic - ii; -- 1001-i = 1..1000
			end if;
			xx := xfb1 + float(ii-1)/float(nslic) * (xfb2-xfb1);
			--xx:=xfb1; --stopped against wall
			barangle := -twopi*xx/(twopi*barrad) *rad2deg;
			yy:= -ymax+barrad;
			zz:= 2.0;

			axis:=zaxis;

			bmm:=identity;
			translate(bmm, -xx,-yy,-zz ); --Xlate to origin
			myrotate(bmm, barangle, axis(1), axis(2), axis(3) ); --rotate
			translate(bmm, xx,yy,zz ); --Xlate back
			bmvp := bmm;
			mymatmult( bmvp, vm ); --ViewMatrix );
			mymatmult( bmvp, pm ); --ProjectionMatrix );


			-- we have to register bmvp AFTER it is redefined:
			gluniformmatrix4fv( fmatrixid, 1, gl_false, BMVP(1,1)'address );

			glUniform3f(firecenid,  --send current centroid to shaders
				glfloat(xx),glfloat(yy),glfloat(zz) );

			glUniform1f(ftimeid, glfloat(currenttime));

			fireballobj.draw(fireball,vertbuff,elembuff);

			if sqrt( sqr(xx-xme)+sqr(yy-yme)+sqr(zz-zme) ) < barrad+margin then
				fireballdead:=true;
			end if;

			-- end fireball roll ------------------------------------------------------------






------------------ turtle begin ---------------------------------------

			glUseProgram( tpgmtexshadid );

			--portal-exterior-discard uniforms
			glUniform1i(tunifside, glint(numport));

			if thirdPerson then
				glUniform3f(tunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(tunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(tunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(tunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv( tmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( tmatrixid, 1, gl_false, mvp(1,1)'address );
			gluniform1i(tuniftex,0);

			-- Fog flag
			gluniform1i(tuniflev, glint(level-1) );

			-- Lighting Effects uniforms:

			gluniform1i(tuniflag, 1); -- 1=> lightingEffects;  0=> none

			--3 light sources within lava pool (?pcen=poolcenter):
			gluniform3f( tunifpos1, 
				glfloat(xpcen), glfloat(waterlevel+0.1), glfloat(zpcen) );
			gluniform3f( tunifpos2, 
				glfloat(xpcen+xprad/2.0), glfloat(waterlevel+0.1), glfloat(zpcen) );
			gluniform3f( tunifpos3, 
				glfloat(xpcen-xprad/2.0), glfloat(waterlevel+0.1), glfloat(zpcen) );

			-- color
			gluniform3f( tunifpcol, 254.0/255.0, 203.0/255.0, 33.0/255.0 ); --orange


			-- ferry-capable lava turtle
			if not insidePortal then
				updateFerryPos(currentTime,
					xtur,ytur,ztur,angltur, xturh,yturh,zturh,anglturh );
			end if;


			-- body positioning, orientation via uniforms (turtle.vs)
			gluniform3f( tfcenid, glfloat(xtur), glfloat(ytur), glfloat(ztur) );
			glUniform1f( tfangid, glfloat(angltur) );


			glbindtexture(gl_texture_2d, turtle_texid);
			turtleobj.ldraw(turtle,vertbuff,uvbuff,normbuff,elembuff);

			-- head positioning, orientation via uniforms 
			gluniform3f( tfcenid, glfloat(xturh), glfloat(yturh), glfloat(zturh) );
			glUniform1f( tfangid, glfloat(anglturh) );

			glbindtexture(gl_texture_2d, turhead_texid);
			turtleobj.ldraw(turhead,vertbuff,uvbuff,normbuff,elembuff);


------------------ turtle end ---------------------------------------






			-- fancy fragshader draws lava in level 3
			glUseProgram( lpoolshadid );

--need this only with DIY lava pool:
--glbindtexture(gl_texture_2d, lava_texid); -- 16jan17


			glUniform1i(lunifside, glint(numport) );

			if thirdPerson then
				glUniform3f(lunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(lunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(lunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(lunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( lpoolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( lpoolmatid, 1, gl_false, mvp(1,1)'address );

			gluniform2f(lresid, glfloat(winwidth), glfloat(winheight) );
			gluniform1f(ltimeid, glfloat(currentTime) );

			gluniform3f(lpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(lpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(lwlevid, glfloat(waterlevel) );

			lavasurf.draw(fso,vertbuff);



			--DaliClock
			glUseProgram( x3picshadid );

			glUniform1i(x3unifside, glint(numport) );

			if thirdPerson then
				glUniform3f(x3unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x3unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x3unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			--center p1 (left)

			glUniform3f(x3unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 
			--center p2 (right)


			gluniformmatrix4fv( x3picmatid, 1, gl_false, mvp(1,1)'address );
			gluniformmatrix4fv( x3picmvid, 1, gl_false, mv(1,1)'address );
			gluniform1f(x3pictimeid, glfloat(-currentTime) );
			gluniform2f(x3piccenid, glfloat(x3picx), glfloat(x3picy) );
			gluniform2f(x3picradid, glfloat(x3picws/2.0), glfloat(x3pichs/2.0) );
			gluniform2f(x3picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);



			--redPlanet
			glUseProgram( x3pic2shadid );

			glUniform1i(x32unifside, glint(numport) );

			if thirdPerson then
				glUniform3f(x32unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x32unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x32unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x32unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv( x3pic2matid, 1, gl_false, mvp(1,1)'address );
			gluniformmatrix4fv( x3pic2mvid, 1, gl_false, mv(1,1)'address );
			gluniform1f(x3pic2timeid, glfloat(currentTime) );
			gluniform2f(x3pic2cenid, glfloat(x3picx), glfloat(x3picy) );
			gluniform2f(x3pic2radid, glfloat(x3picwb/2.0), glfloat(x3pichb/2.0) );
			gluniform2f(x3pic2resid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox2,vertbuff,elembuff);






--########################################################################
		elsif (level=4) then



---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID);

		--portal-exterior discard:
			glUniform1i(funifside, glint(numport) );

			if thirdPerson then
				glUniform3f(funifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(funifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(funifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(funifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			gluniform1i(fishunifrot,1); -- 1=>CW,  -1=>CCW (28jan17)
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------





			-- fancy fragshader draws dark green water in level 4
			glUseProgram( dpoolshadid );

			glUniform1i(dunifside, glint(numport) );

			if thirdPerson then
				glUniform3f(dunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(dunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(dunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(dunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


			gluniformmatrix4fv( dpoolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( dpoolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(dtimeid, glfloat(currentTime) );
			gluniform3f(dpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(dpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(dwlevid, glfloat(waterlevel) );
			rectsurf.draw(rso,vertbuff);

			-- fancy fragshader draws star ceiling
			glUseProgram( starshadid );
			gluniformmatrix4fv( starmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(startimeid, glfloat(currentTime) );
			gluniform2f(starresid, glfloat(winwidth), glfloat(winheight) );

			-- window-discard:
			glUniform1i(stunifside, glint(numport) );
			if thirdPerson then
				glUniform3f(stunifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(stunifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;
			glUniform3f(stunifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(stunifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			rectxobj.draw(rox,vertbuff,elembuff);


			--blueSpiralGalaxy
			glUseProgram( x4picshadid );

			glUniform1i(x4unifside, glint(numport) );


			if thirdPerson then
				glUniform3f(x4unifme, glfloat(xcam),glfloat(ycam),glfloat(zcam));
			else
				glUniform3f(x4unifme, glfloat(xme),glfloat(yme),glfloat(zme));
			end if;

			glUniform3f(x4unifport1, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
			glUniform3f(x4unifport2, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 

			gluniformmatrix4fv( x4picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x4pictimeid, glfloat(currentTime) );
			gluniform2f(x4piccenid, glfloat(x4picx), glfloat(x4picy) );
			gluniform2f(x4picradid, glfloat(x4picw/2.0), glfloat(x4pich/2.0) );
			gluniform2f(x4picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);


--########################################################################
		elsif (level=5) then


			-- draw cube-mapped skybox:
			gluseprogram(pidskyb);
			glenable(gl_texture_cube_map_seamless);
			glbindtexture(gl_texture_cube_map, circubemap_texid);
			gluniform1i(sbmapuid,0);
			gluniformmatrix4fv(sbmvpuid,1,gl_false,mvp(1,1)'address);
			usboxobj.draw(usb5,vertbuff,elembuff);



			-- draw skybox reflections in water:
			gluseprogram(pidskyw);
			gluniform1i(cemuid,0);
			gluniformmatrix4fv(cmvpuid,1,gl_false,mvp(1,1)'address);
			gluniform1f(ctimeid, glfloat(currenttime));
			gluniform3f(cpeyeid, 0.0, 0.0, 0.0 );
			gluniform1f(cwlevid, -0.12);
			circsurf.draw(cir, vertbuff); -- using n=200

			solved(5):=true;

		end if;



end drawroom;




procedure preplevel is
begin

			if( (level>=1) and (level<=mxlev) ) then 
			-- take care of sokwalls, barrels, receptacles here


				readPuzzle(level); --sokoban data


				-- setup sokoban arena:
				ib:=0;
				ir:=0;
				for row in 1..nrows loop
				for col in 1..ncols loop
					fcol:=float(col);
					frow:=float(row);
					
					xc:= xorigin(level)+1.0-2.0*(0.5+fcol)*rolldist*0.5; 
					--ycb:=-ymax+0.05+barr;
					ycb:=-ymax+0.01+barr; -- 22jan17
					yrw:=barr;
					--ycw:=-ymax+0.05+yrw;
					ycw:=-ymax+0.01+yrw; -- 22jan17
					zc:= zorigin(level)+1.0-2.0*(0.5+frow)*rolldist*0.5;

					if( wall(row,col) = true ) then

						nko:=nko+1;
						rectobj.setrect( sokwall(row,col), xc,ycw,zc,
							rolldist*0.5, yrw, rolldist*0.5,      -- xrad,yrad,zrad
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
					end if;

					if( rcpt(row,col) = true ) then
						ir:=ir+1;
						recept(ir)(1):= xc;
						recept(ir)(2):= -ymax;
						recept(ir)(3):= zc;

						pictobj.setrect(sokrcpt(row,col),
							recept(ir)(1), recept(ir)(2), recept(ir)(3),
							barr,0.01,barr,
							xm,xp,ym,yp,zm,zp ); --discard
					end if;

					if( barl(row,col) = true ) then
						ib:=ib+1;
						posbar(ib)(1):= xc;
						posbar(ib)(2):= ycb;
						posbar(ib)(3):= zc;

						cyl2obj.setcyl2(barrel(ib), 
							posbar(ib)(1), posbar(ib)(2), posbar(ib)(3), barr);

					end if;

				end loop;
				end loop;


			end if; -- 1 <= level <= 4



--########################################################################
			if (level=1) then  -- nonreflective blue water


				pzlo:=-16.0; pzhi:=0.0;

				--xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax-margin;
				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax+0.02+margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo, 0.125, 0.125, 0.125,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20
				room_texid := loadPng(mirror,"data/myadobeT.png"); 
				rectsurf.setrect(rso,
					xpcen, zpcen, xprad, zprad); --normal water in gap
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

				fishx:=0.0;             --center of swim circle
				fishy:=waterlevel-0.10; --lower due to big waves...cuts off bottom fish
				fishz:=0.5*(pzlo+pzhi);
				fishr:=0.40*(pzhi-pzlo); --radius of swim circle
				fishs:=1.0;  -- swim speed
				fdx:=0.00001;
				fdy:=0.06;  -- fish size
				fdz:=0.24;
				myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool

				rectobj.setrect(pxp, -- XP
					xmax-2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,      yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm, -- XM
					-xmax+2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,       yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				rectobj.setrect(pzp, -- ZP
						0.0,        ypcen,  pzhi, 
						xprad-0.05, yprad, 2.0*margin, 
						koxlo(nko),koxhi(nko), koylo(nko),
						koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				nko:=nko+1;
				rectobj.setrect(pzm, -- ZM
						0.0,        ypcen,  pzlo, 
						xprad-0.05, yprad, 2.0*margin, 
						koxlo(nko),koxhi(nko), koylo(nko),
						koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				--bottom
				rectobj.setrect(pym,  
					0.0,  -ymax+0.05+0.02,zpcen, 
					xprad-0.05,      0.02, zprad, 
					xm,xp,ym,yp,zm,zp);



				snd4ada_hpp.playLoop(water);
				snd4ada_hpp.playLoop(falls); -- among-the-falls
				snd4ada_hpp.playSnd(xport); --Xport



				-- ledge
				xc:=+0.75*xmax-0.06;
				yc:=-ymax/2.0+0.05;
				zc:=+0.50*zmax;
				xr:=+0.25*xmax;
				yr:=+ymax/2.0;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


-- begin define entry onto ledge ------------------------------------------------
				-- initial position:

				vertang := 0.0;
				horiang:=-halfpi; -- look toward puzzle
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

				updateCamera(true);

				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				-- entry by falling from roof [over ledge] after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;
				--pauseatlevelchange:=true;

-- end define entry onto ledge ------------------------------------------------



				-- ceiling (thatched)
				xc:=0.0;
				yc:=ymax-0.05;
				zc:=0.0;
				xr:=xmax-0.05;
				yr:=0.01;
				zr:=zmax-0.05;
				nko:=nko+1;
				rectobj.setrect(ceil1, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				--ceil_texid := loadPng(mirror,"data/roof1t.png"); 
				ceil_texid := loadPng(mirror,"data/roof1ts.png"); 
				-- great thatched roof!


				-- wall picture (ZPM diagram)
				xc:=0.0;
				yc:=0.0;
				zc:=zmax-0.05;
				xr:=2.0;
				yr:=2.0;
				zr:=0.01;
				nko:=nko+1;
				pictobj.setrect(pic,  xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				--pic_texid := loadPng(mirror,"data/zpmtru.png");
				pic_texid := loadPng(mirror,"data/zpm0.png");

				frameobj.setrect(nfox,xc,yc,zc, xr,yr,zr, 0.3, 1); -- width, 1=North



				rectxobj.setrect(pox,x1picX,x1picY,-zmax+0.05, x1picw,x1pich,0.01); 
				--movingpic (cartoon palm tree)

				frameobj.setrect(sfox,x1picX,x1picY,-zmax+0.05, x1picw,x1pich,0.01, 
					0.3, 3); -- width, 3=South


				xc:=-xmax+2.0;
				yc:=-ymax+1.05;
				zc:=-zmax+2.0;
				xr:=0.7;
				yr:=1.0;
				zr:=0.7;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid


				-- block wall partition
				xc:=-0.5*xmax+0.05;
				yc:=-1.0+0.05;
				zc:=0.0;
				xr:=0.5*xmax;
				yr:=ymax-1.0;
				zr:=0.1;
				nko:=nko+1;
				rectobj.setrect(bloc, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1018 );


--########################################################################
			elsif (level=2) then  -- reflective clear water

				pzlo:= 3.0; pzhi:=zmax-4.0;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax+0.02+margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20
				room_texid := loadPng(mirror,"data/woodenceilingW.png");
				reflsurf.setrect(rfo,
					xpcen, zpcen, xprad, zprad); --reflective water in gap
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

				fishx:=0.0;
				--fishy:=waterlevel-0.06;
				fishy:=waterlevel-0.065; --vertical center lowered for big waves
				-- any lower cuts off bottom fish

				fishz:=0.5*(pzlo+pzhi);
				fishr:=0.40*(pzhi-pzlo); --radius of swim circle
				fishs:=1.0;  -- swim speed
				fdx:=0.00001;
				fdy:=0.06;  -- fish size
				fdz:=0.24;
				myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool

				rectobj.setrect(pxp, --XP
					xmax-2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,      yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm, --XM
					-xmax+2.05*margin,ypcen+0.01,zpcen, 
					2.0*margin,       yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				rectobj.setrect(pzp,  --ZP
					0.0,        ypcen,  pzhi, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;


				nko:=nko+1;
				rectobj.setrect(pzm,  --ZM
					0.0,        ypcen,  pzlo, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;


				rectobj.setrect(pym,  --bottom
					0.0,  -ymax+0.05+0.02, zpcen, 
					xprad-0.05,      0.02, zprad, 
					xm,xp,ym,yp,zm,zp);


				snd4ada_hpp.playLoop(water); --Water;
				snd4ada_hpp.playLoop(dark); --dark-metal
				snd4ada_hpp.playSnd(xport); --Xport

				--ledge
				xc:=+0.5*xmax-0.05;
				yc:=-0.25;
				zc:= 0.0;
				xr:= 0.5*xmax;
				yr:= 0.25;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


-- begin define entry onto ledge -----------------------------------------------

				-- initial position:
				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				horiang:=-halfpi; --twopi;
				vertang := 0.0;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

				updateCamera(true);


							-- entry by falling from roof [over ledge] after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;
				--pauseatlevelchange:=true;

-- end define entry onto ledge ------------------------------------------------


				-- pool wall (+zmax):
				rectxobj.setrect(pox2,
					x2picX,x2picY,+zmax-0.05, x2picws,x2pichs,0.01); 
				--movingpic (pox2=>mountainscape)

				frameobj.setrect(nfox,x2picX,x2picY, +zmax-0.05, 
					x2picws,x2pichs,0.01, 0.3, 1); -- width, 1=no

				-- puzzle wall (-zmax):
				rectxobj.setrect(pox,
					x2picX,x2picY,-zmax+0.05, x2picwb,x2pichb,0.01); 
				--movingpic (pox=>waterworld)

				frameobj.setrect(sfox,x2picX,x2picY, -zmax+0.05, 
					x2picwb,x2pichb,0.01, 0.3, 3); -- width, 3=south



				-- ceiling (bluish grunge to show off water)
				xc:=0.0;
				yc:=ymax-0.05;
				zc:=0.0;
				xr:=xmax-0.05;
				yr:=0.01;
				zr:=zmax-0.05;
				nko:=nko+1;
				pictobj.setrect(ceil2, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


				--12oct16 addendum
				rectxobj.setrect(rox,xc,yc-0.02,-10.0, xr,yr,9.95); --starceilx

				yr:=0.3; -- radius of cylindrical edge to grunge ceiling
				cylobj.setcylx( cyl, xc, yc-yr, zc, xr, yr, j1,j2,j3,j4,j5,j6);


				xc:=+xmax/2.0;
				yc:=-ymax+1.05;
				zc:=+zmax-2.0;
				xr:=0.7;
				yr:=1.0;
				zr:=0.7;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid

				-- partition wall
				xc:=-0.0;
				yc:=-0.5*ymax;
				zc:=+2.0;
				xr:=xmax-0.03;
				yr:=0.5*ymax-0.03;
				zr:=0.1;
				nko:=nko+1;
				pictobj.setrect(bloc2, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1019 );





--########################################################################
			elsif (level=3) then -- lavapool


				pzlo:= 3.0; pzhi:=zmax-4.0;

				yprad:=margin;
				ypcen:=-ymax+0.02+yprad;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  
				xprad:=xmax-0.02; zprad:=0.5*(pzhi-pzlo);
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/bricksr.png");

				--NOTE:  all 3 work here...a) reflsurfobj, 
				--			b)finesurfobj, c)rectsurfobj.
				--       which proves they all work.
				lavasurf.setrect(fso,xpcen, zpcen, xprad-0.03, zprad); 
				--lava in gap

				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun


				-- begin brick lining of pool
				rectobj.setrect(pxp, --west edge
					xmax-2.05*margin, ypcen+0.01, zpcen, 
					2.0*margin,       yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm, --east edge
					-xmax+2.05*margin, ypcen+0.01,zpcen, 
					2.0*margin,        yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				rectobj.setrect(pzp,  --north edge
					     0.0,   ypcen,  pzhi, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				nko:=nko+1;
				rectobj.setrect(pzm,  --south edge
					     0.0,   ypcen,  pzlo, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;


				rectobj.setrect(pym,  --bottom
					     0.0,    -ymax+0.05+0.02,   zpcen, 
					xprad-0.05,             0.02,   zprad, 
					xm,xp,ym,yp,zm,zp);



				snd4ada_hpp.playLoop(lava); --Lava;
				snd4ada_hpp.playLoop(gothic); --gothic-dutch
				snd4ada_hpp.playSnd(xport); --Xport


				-- wooden ledge
				xc:=+0.5*xmax-0.05;
				yc:=-0.25;
				zc:= 0.0;
				xr:= 0.5*xmax;
				yr:= 0.25;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


-- begin define entry onto ledge -----------------------------------------------

				vertang := 0.0;
				horiang:= -halfpi; --onepi;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

				updateCamera(true);


				-- initial position:
				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				-- entry by falling from roof [over ledge] after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;
				--pauseatlevelchange:=true;

-- end define entry onto ledge ------------------------------------------------


				--movingpic (DaliClock)
				-- lava pool wall (+zmax):
				rectxobj.setrect(pox,
					x3picX,x3picY,+zmax-0.05, x3picws,x3pichs,0.01); 

				frameobj.setrect(nfox,x3picX,x3picY, +zmax-0.05, 
					x3picws,x3pichs,0.01, 0.3, 1); -- width, 1=no

				--movingpic (redPlanet)
				-- puzzle wall (-zmax):
				rectxobj.setrect(pox2,
					x3picX,x3picY,-zmax+0.05, x3picwb,x3pichb,0.01); 

				frameobj.setrect(sfox,x3picX,x3picY, -zmax+0.05, 
					x3picwb,x3pichb,0.01, 0.3, 3); -- width, 3=so


				--exit box
				xc:=-xmax+2.0;
				yc:=-ymax+1.05;
				zc:=+zmax-2.0;
				xr:=0.7;
				yr:=1.0;
				zr:=0.7;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid

				-- partition wall
				yr:=0.25*ymax;
				xc:=0.0;
				yc:=-ymax+0.05+yr;
				zc:=-2.0;
				xr:=xmax-0.05;
				zr:=0.1;
				nko:=nko+1;
				pictobj.setrect(bloc2, 
					xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1020 );




--########################################################################
			elsif (level=4) then  -- eerie dark green water



				pzlo:=-16.0; pzhi:=0.0;

				yprad:=margin;
				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax+0.02+yprad;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi, 0.0,0.0,0.0, 
					xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/granitergb.png");

				-- dark translucent water surface setup:
				rectsurf.setrect(rso,xpcen, zpcen, xprad, zprad);
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

				fishx:=0.0;             --center of swim circle
				fishy:=waterlevel-0.10; --lower due to big waves...cuts off bottom fish
				fishz:=0.5*(pzlo+pzhi);
				fishr:=0.40*(pzhi-pzlo); --radius of swim circle
				fishs:=1.0;  -- swim speed
				fdx:=0.00001;
				fdy:=0.06;  -- fish size
				fdz:=0.24;
				myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool
				-- +X
				rectobj.setrect(pxp, 
					xmax-0.01-2.0*margin, ypcen+0.01, zpcen, 
					          2.0*margin, yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				-- -X
				rectobj.setrect(pxm,
					-xmax+0.01+2.0*margin, ypcen+0.01, zpcen, 
					           2.0*margin, yprad+0.01, zprad, 
					xm,xp,ym,yp,zm,zp);

				nko:=nko+1;
				-- +Z
				rectobj.setrect(pzp,  
					0.0,        ypcen,  pzhi, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;

				nko:=nko+1;
				-- -Z
				rectobj.setrect(pzm,  
					0.0,        ypcen,  pzlo, 
					xprad-0.05, yprad, 2.0*margin, 
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
				koyhi(nko):=koyhi(nko)+barr;



				--bottom
				rectobj.setrect(pym,  
					0.0,    -ymax+0.05+0.02, zpcen, 
					xprad-0.05,        0.02, zprad, 
					xm,xp,ym,yp,zm,zp);



				snd4ada_hpp.playLoop(water); --Water;
				snd4ada_hpp.playLoop(neptune); --portals-to-neptune
				snd4ada_hpp.playSnd(xport); --Xport


				-- ledge
				xc:=-xmax+1.55;
				yc:=-0.25;
				zc:=-zmax+1.55;
				xr:= 1.5;
				yr:= 0.25;
				zr:= 1.5;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );


	-- begin define entry 
				horiang:=onepi;
				vertang:=0.0;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);

					xme:= 1.0;
					yme := -ymax+aheight;
					zme:=18.0;

				updateCamera(true);

	-- end define entry



				-- frag shader controls ceiling:
				xc:=0.0;
				yc:=ymax-0.05;
				zc:=0.0;
				xr:=xmax-0.05;
				yr:=0.01;
				zr:=zmax-0.05;
				rectxobj.setrect(rox,xc,yc,zc, xr,yr,zr); --starceilx
				-- no texture needed here;  fancy fragshader used instead
		

				--movingpic: spiral galaxy
				rectxobj.setrect(pox,x4picX,x4picY,-zmax+0.05,x4picw,x4pich,0.01); 

				frameobj.setrect(sfox,x4picx,x4picy,-zmax+0.05,
					x4picw,x4pich,0.01, 0.3, 3); -- width, 3=so


				-- uru picture
				xc:=0.0;
				yc:=0.0;
				zc:=zmax-0.03;
				xr:=2.0;
				yr:=2.0;
				zr:=0.01;
				pictobj.setrect(pic,  xc,yc,zc, xr,yr,zr, 
					xm,xp,ym,yp,zm,zp);

				pic_texid := loadPng(mirror,"data/ederu.png");

				frameobj.setrect(nfox,xc,yc,zc, xr,yr,zr, 0.3, 1); -- width, 1=no

				-- exit cube
				xc:=-xmax+2.0;
				yc:=-ymax+1.05;
				zc:=+zmax-2.0;
				xr:=0.7;
				yr:=1.0;
				zr:=0.7;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				twictobj.setrect2(xbox, xc,yc,zc, xr,yr,zr, 0.0,
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid

				--partition
				xc:=-3.0;
				yc:= 0.0;
				zc:= zmax*0.5;
				xr:=0.1;
				yr:=ymax-0.03;
				zr:= zmax*0.495;
				nko:=nko+1;
				rectobj.setrect(bloc, xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );

				myassert( nko <= maxnko, 1021 );



--########################################################################
			elsif (level=5) then  -- epilog


				horiang:=+halfpi;

				vertang:=0.0;
				xlook := fmath.cos(vertang)*fmath.sin(horiang);
				cylook := fmath.sin(vertang);
				zlook := fmath.cos(vertang)*fmath.cos(horiang);


				xme:=0.0;
				yme:=0.0;
				zme:=0.0;

				thirdPerson:=false;
				setCamAng;
				updateCamera(true);



				usboxobj.setrect(usb5, rad5,1.0,rad5);

				circsurf.setround(cir,0.0,0.0,rad5);


				snd4ada_hpp.playLoop(water); --Water;
				snd4ada_hpp.playLoop(choir); --ChurchChoir
				snd4ada_hpp.playSnd(xport); --Xport

			elsif (level>5) then
				myassert( mxlev=4, 1022 );
				put_line("only 4 levels");
				raise program_error;
			end if;


end preplevel;




	completed, details : boolean := false;
	dt : float;


procedure getuserinputs is
begin

		if( level < 5 ) then

			if
				( key_map( SDL_SCANCODE_UP ) /= 0 )
				or ( key_map( SDL_SCANCODE_W ) /= 0 )
			then 
				moveForward(currentTime);

			elsif
				( key_map( SDL_SCANCODE_DOWN ) /= 0 ) 
				or ( key_map( SDL_SCANCODE_S ) /= 0 )
			then 
				moveBackward(currentTime);
        
			-- 11jan17 exposed this...why was it hidden before?
			elsif( key_map( SDL_SCANCODE_E )  /= 0 ) then -- was _W
				portalEnabled:=true;

			elsif
			(
				( key_map( SDL_SCANCODE_M )  /= 0 )
				or
				( key_map( SDL_SCANCODE_F1 ) /= 0 )
			)
			then
				dt := currentTime - dBtnTime;
				if( dt > 0.8 ) then
					thirdPerson := not thirdPerson;
					dBtnTime:=currentTime;
				end if;

			elsif( key_map( SDL_SCANCODE_X )  /= 0 ) then 
				dt := currentTime - dBtnTime;
				if( dt > 0.8 ) then
					details:=not details;
					dBtnTime:=currentTime;
				end if;

			elsif( key_map( SDL_SCANCODE_L )  /= 0 ) then 
				shootLeft(currentTime);
			elsif( key_map( SDL_SCANCODE_R )  /= 0 ) then 
				shootRight(currentTime); 
			end if;

			if( key_map( SDL_SCANCODE_SPACE )  /= 0 ) then
						jumpTime := currentTime;
						pyjump:= yme;
						vyjump:=2.0;
						jumping:=true;
			end if;

-----	///////////////////// begin response to mouse buttons

			MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
			state := integer( MouseState );
			ileft := integer( SDL_BUTTON(1) );
			iright:= integer( SDL_BUTTON(3) );
			if    bitmatch(state, ileft)   then 
				shootLeft(currentTime);
			elsif bitmatch(state, iright)  then 
				shootRight(currentTime);
			end if;


		end if; -- level<5




		deltaT := currentTime - oldTimeKb;

		if
			( key_map( SDL_SCANCODE_LEFT ) /= 0 ) 
				or ( key_map( SDL_SCANCODE_A ) /= 0 )
		then
			roty := +0.5*deltaT;
			horiang := horiang + roty;
			setCamAng;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			cylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			--updateCamera;

		elsif
			( key_map( SDL_SCANCODE_RIGHT ) /= 0 ) 
				or ( key_map( SDL_SCANCODE_D ) /= 0 )
		then
			roty := -0.5*deltaT;
			horiang := horiang + roty;
			setCamAng;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			cylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			--updateCamera;

		end if;


------ begin mouse drag -------------------------------------------
		handle_mouse_drag(currentTime);
------ end mouse drag -------------------------------------------


----------- begin game controller ---------------------------------
	if joystik or gamepad then

		-- axis values in [-32768...+32767]

		-- JS: 2nd Axis parm:  0..2
		-- GC: 2nd Axis parm:  0..3

		-- unresolved question:  how do I prevent spinning @ startup?

		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
		handle_gc_left(axis_lx,axis_ly);

		if gamepad then -- these handle move forward/backward
			axis_rx := SDL_JoystickGetAxis(jsa, 2);
			axis_ry := SDL_JoystickGetAxis(jsa, 3);
			handle_gc_right(currentTime,axis_rx,axis_ry);
		end if;

		-- now for the buttons:

		-- 1 => pressed,  0 => not pressed
		-- JS: 2nd Btn parm:  0..7
		-- GC: 2nd Btn parm:  0..11

		zeroBtns; -- set btns 0..8 to zero
		if gamepad then
			btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- shootLeft(LtShoulder)
			btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- shootRight(RtShoulder)
			btn_8 := SDL_JoystickGetButton(jsa,gjmp); -- jump
		elsif joystik then
			btn_0 := SDL_JoystickGetButton(jsa,jbak); -- moveBackward(trigger)
			btn_1 := SDL_JoystickGetButton(jsa,jfor); -- moveForward(thumb)
			btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- shootLeft(thumb)
			btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- shootRight(thumb)
			btn_7 := SDL_JoystickGetButton(jsa,jjmp); -- jump
		end if;

		if btn_7>0 or btn_8>0 then
			jumpTime := currentTime;
			pyjump:= yme;
			vyjump:=2.0;
			jumping:=true;
		end if;

		if btn_4>0 or btn_2>0 then 
			shootLeft(currentTime); 
		end if;

		if btn_5>0 or btn_3>0 then 
			shootRight(currentTime); 
		end if;

		if joystik then
			if    btn_0>0 then -- JS.trigger
				moveBackward(currentTime);
			elsif btn_1>0 then -- JS.thumb
				moveForward(currentTime);
			end if;
		end if;

	end if; --joystik or gamepad
----------- end game controller ---------------------------------



end getuserinputs;




	dxome,dzome, dxme,dyme,dzme : float;
	ohang, ovang: float;
	draw1, draw2 : boolean := true;

	levdebug: boolean := false;


	oxcam,ozcam,oycam, 
	ochang, ocxluk, oczluk: float;

	vmt,vcc: vec4;
	xap,yap,zap: float;

	adagate_main_error : exception;

-------------------------- main program begin ==========================
begin --adagate

	new_line;
	new_line;
	put_line("Please be patient...AdaGate is slow to load...");
	new_line;
	new_line;



	first_prep;  -- main program setup
	-- NOW, we may begin testing for GLerrors

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog


	nerr:=dumpGLerrorQueue("main 1"); --avoid misleading messages in pngloader or loadshaders
	setup_textures; -- prep dungeon textures

	-- I hope this one is enough:
	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	island_texture_setup; 

	updateCamera(true);
	updateMVP( float(winwidth), float(winheight) );


	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog


	level:=0;
	solved(0):=true;
	solved(5):=false; -- false until epilog is visited

	currentTime := float(sdl_getticks)/1000.0;

	nerr:=dumpGLerrorQueue("main 2"); --lets begin mainloop with a clean slate


	-- main event loop begin: -----------------------------------------------
   while not userexit and not lavadead and not fireballdead loop

		direction:=0; --stop avatar's legs unless moving

		if (level<5) and solved(level) then --prepare new level



			if level>0 then
				gldeletetextures(1, room_texid'address);
			end if;

			if level=1 then 
				gldeletetextures(1, ceil_texid'address); 
			end if;

			if (level=1) or (level=4) then 
				gldeletetextures(1, pic_texid'address);
			end if;

			snd4ada_hpp.stopLoops;

			-- elliminate gratuitous holes while shooting
			xtgt1:=25.0;
			ztgt1:=25.0;
			xtgt2:=xtgt1;
			ztgt2:=ztgt1;

			portalenabled:=false;
			lport_located:=false;
			rport_located:=false;
			lport_defined:=false;
			rport_defined:=false;
			lport_stable:=false;
			rport_stable:=false;
			lshooting:=false;
			rshooting:=false;
			worm_defined:=false;
			worm_active:=false;
			first_worm_active:=false;
			xit:=false;
			exitwait:=false;
			wall1:=none;
			wall2:=none;


			nko:=0;
			pko:=0;



			xme:=0.0; yme:=0.0; zme:=0.0;
			-- beach uses alternate paradigm Yeye = sandHt + eyeht
			-- whereas dungeons default  Yeye = -ymax + aheight

			-- play Xport if returning from dungeon:
			if level > 0 then snd4ada_hpp.playSnd(xport); end if; -- 21mar16


			-- to skip beach and immediately jump to a 
			-- particular level for debugging, set to true:
			levdebug:=false;
			if levdebug then
				interior:=true;
				level:=2; --choose level to debug here

			else

				-- Now draw island ########################################
				-- user selects destination on the DHD:
				interior:=false;
				level := island_ftn(bkgd,dbug); -- island-nexus (returns 1..5)

				if level<5 then interior:=true; end if;

			end if;



			vertang:=0.0;
			horiang:=0.0;


			-- careful, these are ALSO used within island_ftn for rocks
			nko:=0;
			pko:=0;

			preplevel; -- sets pauseAtLevelChange:=true



			if levdebug then 
				worming:=false;

			else	
					
				-- New, narrower tunnel now makes this possible even in level 5, 
				-- but tunnel requires horiang be a multiple of halfpi
				fromIsland:=true;
				prepwormhole( currenttime, 
					xme-40.0*xlook, yme, zme-40.0*zlook, xme,yme,zme, xme,zme);
				-- wormhole trajectory begins 40 units "behind" starting location

			end if;


		end if; -- new level prep ###########################################




	-- main event loop middle: -----------------------------------------------


		currentTime := float(sdl_getticks)/1000.0;


------- begin response to user inputs

		SDL_PumpEvents;
		key_map := sdl_getkeyboardstate(numkeys'access);


		-- these 2 keyboard responses work anytime...
		-- and are the only 2 needed in level=5 (epilogue)
		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then userexit:=true; end if;
		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then userexit:=true; end if;




		if not worming then

			getuserinputs;

		else -- worming
			vertang:=0.0;
			worm(currenttime, xme,yme,zme, worming);

			if not worming then
				updateCamera(true);
			end if;

		end if; -- not worming





		if not worming then updateCamera; end if;
		updateMVP( float(winwidth), float(winheight) );


		if level<5 then
			updategamestate( currentTime );
		end if;

		foldtime:=currenttime;
		boldtime:=currenttime;
		oldTimeKb := currentTime; --prepare for next time





--------- begin drawing =================================================

		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);


		if 
			not worming     --skip this when going thru wormhole

			and not userexit

			and worm_active

			and level<5

		then

			--for each portal we set coords/look
			--then updateMVP and draw
			--and finally, restore coords, updateMVP, draw normal view


			--first, save normal values here:
			ohang:=horiang;
			ovang:=vertang;
			oxme:=xme;
			oyme:=yme;
			ozme:=zme;

			ochang:=choriang;
			ocxluk:=cxlook;
			oczluk:=czlook;
			oxcam:=xcam;
			oycam:=ycam;
			ozcam:=zcam;

			--dycam:=ycam-yme;
			--dxcam:=xcam-xme;
			--dzcam:=zcam-zme;

---------- begin delta angle = dang  calculation ----------------------------
-- note:  horiang=0 => north = +Z,  horiang=pi/2 => west = +X
------------------------------------------------------------------------------
-- define dang1 as the difference between 
-- the outward normal at p2 and inward normal @ p1
-- = pn2 - (-pn1) = pn2+pn1, 
-- so that dang1=0 when on opposite walls
---------------------------------------------------------------------------

			if 
				(wall1=ea and wall2=no) or
				(wall1=no and wall2=we) or
				(wall1=we and wall2=so) or
				(wall1=so and wall2=ea)
			then
				dang1:=-halfpi;
			elsif
				(wall2=ea and wall1=no) or
				(wall2=no and wall1=we) or
				(wall2=we and wall1=so) or
				(wall2=so and wall1=ea)
			then
				dang1:=+halfpi;
			elsif
				(wall1=ea and wall2=we) or
				(wall2=ea and wall1=we) or
				(wall1=so and wall2=no) or
				(wall2=so and wall1=no)
			then
				dang1:=0.0;
			elsif wall1=wall2 then 
				dang1:=onepi;
				-- Caution...in this case the virtual scenes
				-- seen thru each portal overlap and interfere
				-- with each other.  If we allow 2 portals on
				-- the same wall, we must not draw both...
				-- unless ytgt1=ytgt2
			else 
				raise program_error;
			end if;

			-- used in shootleft shootright
			dang2:=-dang1; 


---------- end delta angle = dang ----------------------------



---------- 1st portal ----------------------------------

			if thirdPerson then

				dxome:=oxcam-xtgt1;
				dyme :=oycam-ytgt1;
				dzome:=ozcam-ztgt1;

				horiang := ochang+dang1;

			else -- firstPerson

				dxome:=oxme-xtgt1;
				dyme :=oyme-ytgt1;
				dzome:=ozme-ztgt1;

				horiang := ohang+dang1;

			end if; --thirdPerson


			dxme:= cos(dang1)*dxome + sin(dang1)*dzome;
			dzme:=-sin(dang1)*dxome + cos(dang1)*dzome;

			-- these coords are "outside" the room to be drawn:
			xme:=xtgt2+dxme;
			yme:=ytgt2+dyme; -- oyme+ytgt2-ytgt1
			zme:=ztgt2+dzme;

			cylook := sin(vertang);
			xlook := cos(vertang)*sin(horiang);
			zlook := cos(vertang)*cos(horiang);

			choriang:=horiang;
			cxlook := xlook;
			czlook := zlook;
			xcam:=xme;
			ycam:=yme;
			zcam:=zme;


			updateMVP( float(winwidth), float(winheight) ); --left portal#1

			drawroom(1,true, oxme,oyme,ozme,ohang); 
			-- view thru 1st (leftBtn) portal


---------- 2nd portal ----------------------------------


			if thirdPerson then

				dxome:=oxcam-xtgt2;
				dyme :=oycam-ytgt2;
				dzome:=ozcam-ztgt2;

				horiang := ochang+dang2;

			else -- firstPerson

				dxome:=oxme-xtgt2;
				dyme :=oyme-ytgt2;
				dzome:=ozme-ztgt2;

				horiang := ohang+dang2;

			end if; --thirdPerson


			dxme:= cos(dang2)*dxome + sin(dang2)*dzome;
			dzme:=-sin(dang2)*dxome + cos(dang2)*dzome;

			-- these coords are "outside" the room to be drawn:
			xme:=xtgt1+dxme;
			yme:=ytgt1+dyme; -- oyme+ytgt1-ytgt2
			zme:=ztgt1+dzme;


			cylook := sin(vertang);
			xlook := cos(vertang)*sin(horiang);
			zlook := cos(vertang)*cos(horiang);

			choriang:=horiang;
			cxlook := xlook;
			czlook := zlook;
			xcam:=xme;
			ycam:=yme;
			zcam:=zme;



			updateMVP( float(winwidth), float(winheight) ); --right portal#2

			drawroom(2, true, oxme,oyme,ozme,ohang); 
			-- view thru 2nd (rightBtn) portal






----- now, restore normal view, MVP matrix: ------------------------------
			xme:=oxme;
			yme:=oyme;
			zme:=ozme;
			horiang:=ohang;
			vertang:=ovang;
			xlook := cos(vertang)*sin(horiang);
			cylook := sin(vertang);
			zlook := cos(vertang)*cos(horiang);


			choriang:=ochang;
			cxlook := ocxluk;
			czlook := oczluk;
			xcam:=oxcam;
			ycam:=oycam;
			zcam:=ozcam;

			updateMVP( float(winwidth), float(winheight) );



		end if; -- not worming and worm_active





		---------- here is the primary drawing of current dungeon: --------
		if not userexit then
			drawroom(0,false, xme,yme,zme,horiang); --################
		end if;
		---------- here is the primary drawing of current dungeon: --------



		if worming and not userexit then -- draw passage thru wormhole
			drawWormHole( currentTime, mvp );

		else -- draw crosshair-cursor
			--utex.print2d("+",0.5,0.5,50); -- crosshair gun sight
			aim(xap,yap,zap);
			vmt:=(xap,yap,zap,1.0);
			mymatvec(mvp,vmt,vcc);
			utex.print3d("+",vcc(1),vcc(2),vcc(3),vcc(4), 40, 1.0);
			drawbeams(currenttime);

		end if; -- worming




		if details then -- initiated with <x>-key

			--put(" |cam: "&float'image(xcam)&","&float'image(ycam)&","&float'image(zcam));
			--put(" |me: "&float'image(xme)&","&float'image(yme)&","&float'image(zme));
			--new_line;

			-- intent of this section is to show certain technical details 
			-- to check the status under OS-X in case of a MacBundle 
			-- rather than the command line version.

			--utex.print2d(" Ndim: " &
			--	interfaces.c.int'image(Nwid)&" X "
			--	& interfaces.c.int'image(Nhit), 0.02, 0.8, 15 );

			utex.print2d(" hdpi: " &
				interfaces.c.int'image(Fwid)&" X "
				& interfaces.c.int'image(Fhit), 0.02, 0.7, 15 );

--------- begin OGL queries -----------------------------------------

			glGetIntegerv(GL_CONTEXT_PROFILE_MASK, profile'address);
			if( profile = GL_CONTEXT_CORE_PROFILE_BIT ) then
				utex.print2d("ogl-query:  Core Profile", 0.02, 0.6, 10);
			end if;

			-- Note that OSX currently requires the forward_compatible flag!
			glGetIntegerv(GL_CONTEXT_FLAGS, flags'address);
			if( flags = GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT ) then
				utex.print2d("ogl-query:  Forward-Compatible bit is set", 0.02, 0.55, 10);
			end if;

			glgetintegerv(gl_major_version, major'address);
			glgetintegerv(gl_minor_version, minor'address);
			utex.print2d( "ogl-query: OGL-major: "&glint'image(major), 0.02, 0.5, 10);
			utex.print2d( "ogl-query: OGL-minor: "&glint'image(minor), 0.02, 0.45, 10);

			glgetintegerv(gl_max_texture_units, mtu'address);
			utex.print2d( "ogl-query: maxTexUnits: "&glint'image(mtu), 0.02, 0.4, 10);

			glgetintegerv(gl_max_texture_image_units, mtu'address);
			utex.print2d( "ogl-query: maxTexImgUnits: "&glint'image(mtu), 0.02, 0.35, 10);

			glgetintegerv(gl_max_combined_texture_image_units, mtu'address);
			utex.print2d( "ogl-query: maxCombTexImgUnits: "&glint'image(mtu), 0.02, 0.3, 10);

			glgetintegerv(gl_max_uniform_buffer_bindings, mul'address);
			utex.print2d( "ogl-query: maxUniformBufferBindings: "&glint'image(mul), 0.02, 0.25, 10);

			glgetintegerv(gl_max_uniform_locations, mul'address);
			utex.print2d( "ogl-query: maxUniformLocations: "&glint'image(mul), 0.02, 0.20, 10);

--------- end OGL queries -----------------------------------------


		end if;





		--output errors but raise exception only if dbug
		if dumpGLerrorQueue("AG main loop end")>0 then
			if dbug then raise adagate_main_error; end if;
		end if;



		sdl_gl_swapwindow( mainWindow );


-----------------------------------------------------------------------------
   end loop; ------------------------ main event loop end -------------------
-----------------------------------------------------------------------------



	if lavadead or fireballdead then
		snd4ada_hpp.playSnd(shriek); -- shriek
		utex.print2d("Sorry, Lava Killed You !", 0.25, 0.5, 50);
		sdl_gl_swapwindow( mainWindow );
		delay 4.0;
	end if;




	text_io.create(tfile, out_file, resfile);
	completed:=
		solved(1) and solved(2) and solved(3) and solved(4) and solved(5);
	if completed then

		put_line(tfile, integer'image( dod mod mxdeg + 1));
		put_line(tfile, integer'image(0) );
		put_line(tfile, integer'image(0) );
		put_line(tfile, integer'image(0) );
		put_line(tfile, integer'image(0) );

	else

		put_line(tfile, integer'image(dod));
		for i in 1..mxlev loop
		if solved(i) then
			put_line(tfile, integer'image(1) );
		else
			put_line(tfile, integer'image(0) );
		end if;
		end loop;

	end if;
	text_io.close(tfile);


	snd4ada_hpp.termSnds; -- stops any loops;  then deallocates

	release_textures;

	utex.cleanuptext;

	if joystik or gamepad then
		SDL_JoystickClose(jsa);
	end if;

	SDL_GL_DeleteContext(mainGLContext);
	SDL_DestroyWindow(mainWindow);

	SDL_Quit;


end adagate;

