
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_castle is

	i,k: integer;



procedure drawarches(k: integer) is
begin
		glbindtexture(gl_texture_2d, gmarble_texid);
		glUniform1f(holeradid, glfloat(rr) );

		-- sort the arched "cornices" = rectangles with holes
		for ii in 1..4 loop
			ox(ii):=hox(ii,k);
			oz(ii):=hoz(ii,k);
		end loop;
		sort(cf2n,ox,oz,1,4,xme,zme);

		--now draw far to near
		for ii in 1..4 loop
			i:=cf2n(ii);
			glUniform3f(
				holecenid,
				glfloat(hox(i,k)),
				glfloat(hoy(i,k)),
				glfloat(hoz(i,k)) );
			rectobj.ldraw(cornice(i,k), vertbuff,uvbuff,normbuff,elembuff);
		end loop;

end drawarches;


	angl: float;


begin

		glUseProgram( pgmtexshadid );
		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		if success then
			gluniform1i(pgmFlag,1); -- 1=>use light effects
			gluniform3f(pgmColr, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
			glUniform1i(unifdark, castledarkness); -- was -1
			gluniform1f(pgmspc, 0.5); --fracMspc (dflt=0.1)
		else
			gluniform1i(pgmFlag,0); -- 0=>NO light effects
			gluniform3f(pgmColr, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
			glUniform1i(unifdark, castledarkness);
		end if;
		gluniform3f(pgmPos, xchalice,ychalice,zchalice );

		if thirdPerson then
			gluniform3f(pgmeye, glfloat(xcam),glfloat(ycam),glfloat(zcam) );
		else
			gluniform3f(pgmeye, glfloat(xme),glfloat(yme),glfloat(zme) );
		end if;

		gluniform1i(uniftex,0);

		gluniform1i(uniflev, foglev2 ); 
		gluniform1i(unifclr, fogclr2 ); 


		--moorish alcove
		glbindtexture(gl_texture_2d, moorwall_texid);
		pictobj.ldraw(wallmoor, vertbuff,uvbuff,normbuff,elembuff);


		--floor
		glbindtexture(gl_texture_2d, floor_texid);
		rectobj.ldraw(floor, vertbuff,uvbuff,normbuff,elembuff);

		--pedestal
		glbindtexture(gl_texture_2d, cherry_texid);
		pictobj.ldraw(pedestal, vertbuff,uvbuff,normbuff,elembuff);

		--tapestry
		glbindtexture(gl_texture_2d, rug_texid);
		pictobj.draw(rug, vertbuff,uvbuff,elembuff); --no shine on rug




		if not gkeyheld and sgkey=2  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;

		if not bkeyheld and sbkey=2 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=2 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=2 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;

		if not gateheld and sgate=2 and kgate=0 then
			glbindtexture(gl_texture_2d, frame_texid);
			pictobj.draw(gateway, vertbuff,uvbuff,elembuff);
		end if;




-------- begin reflective pool -------------------------------

			glUseProgram( poolshadid );

			gluniform1i(pooldrk, pooldarkness);
			gluniform1i(poollev, foglev2);
			gluniform1i(poolclr, fogclr2);

			gluniformmatrix4fv( poolmvid, 1, gl_false, imv(1,1)'address );
			gluniformmatrix4fv( poolmatid, 1, gl_false, imvp(1,1)'address );
			gluniform1f(timeid, glfloat(currentTime) );
			gluniform3f(pcenid, glfloat(mpx(0)), 0.1, glfloat(mpz(0)) );
			gluniform3f(pradid, 1.9, 0.1, 1.9 );
			gluniform1f(wlevid, 0.15 ); --water level
			newrectsurf.draw(rso,vertbuff);

-------- end reflective pool -------------------------------





		glUseProgram( holetexshadid );
		gluniformmatrix4fv( holemvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( holematrixid, 1, gl_false, imvp(1,1)'address );
		gluniform1i(holeuniftex,0);


		if success then
			gluniform1i(holeFlag,1); -- 1=>use light effects
			gluniform3f(holeColr, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
			glUniform1i(holeunifdark, castledarkness); -- was -1
			gluniform1f(holespc, 0.5); --fracMspc (dflt=0.1)
		else
			gluniform1i(holeFlag,0); -- 0=>NO light effects
			gluniform3f(holeColr, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
			glUniform1i(holeunifdark, castledarkness);
		end if;

		gluniform3f(holePos, xchalice,ychalice,zchalice );

		if thirdPerson then
			gluniform3f(holeeye, glfloat(xcam),glfloat(ycam),glfloat(zcam) );
		else
			gluniform3f(holeeye, glfloat(xme),glfloat(yme),glfloat(zme) );
		end if;


		gluniform1i(holeuniflev, foglev2 ); 
		gluniform1i(holeunifclr, fogclr2 ); 


		glUniform1f(holeradid, 0.0 );
		glbindtexture(gl_texture_2d, adobe_texid); --13oct16
		cylobj.draw(iskylight, vertbuff,uvbuff,elembuff);

---------------------- begin room & ceiling -----------------------------
		-- we now draw room & ceiling here to draw
		-- a hole in the ceiling center:
		glUniform1f(holeradid, 0.5 );
		glUniform3f(holecenid, -5.0, glfloat(iymax), -5.0 );

		--main interior
		glbindtexture(gl_texture_2d, adobe_texid);
		droomobj.ldraw(cdo,vertbuff,uvbuff,normbuff,elembuff); --textured room

		--ceiling
		glbindtexture(gl_texture_2d, ceil_texid);
		pictobj.ldraw(ceil, vertbuff,uvbuff,normbuff,elembuff);
---------------------- end room & ceiling -----------------------------



		glUniform1f(holeradid, 0.0 ); --disable hole for other stuff



		-- I like the looks better without golden-discoloring
		-- of Korla, or the marble...
		gluniform1i(holeFlag,0); -- 0=>NO light effects

		if success then
			angl:=currentTime*onepi*0.1;

			--draw rotating Korla Pandit
			twictobj.setrect2(korla,
				-5.0, 1.0, -5.0,
				0.2,      0.3, 0.2, angl,
				j1,j2,j3,j4,j5,j6);

			glbindtexture(gl_texture_2d, korla_texid);
			twictobj.draw(korla, vertbuff,uvbuff,elembuff);
		end if;


		glbindtexture(gl_texture_2d, bmarble_texid);
		rectobj.ldraw(slab, vertbuff,uvbuff,normbuff,elembuff); --pool roof

		--3 pool edges
		rectobj.ldraw(edgezm, vertbuff,uvbuff,normbuff,elembuff);
		rectobj.ldraw(edgezp, vertbuff,uvbuff,normbuff,elembuff);
		rectobj.ldraw(edgexp, vertbuff,uvbuff,normbuff,elembuff);


--------- begin pillar with cornices ------------------------------------------

		for ii in 0..4 loop
			ox(ii):=mpx(ii);
			oz(ii):=mpz(ii);
		end loop;
		sort( pfar2near, ox, oz, 0,4, xme,zme );

		glbindtexture(gl_texture_2d, bmarble_texid);
		for i in 0..4 loop
			k:=pfar2near(i);
			cylobj.draw(moorishpillar(k), vertbuff,uvbuff,elembuff);
		end loop;

		-- the only way I've found to make these arches
		-- look correct is to draw twice:

		-- draw arches:
		gldepthmask(gl_false);
		for ii in 0..4 loop
			i:=pfar2near(ii);
			drawarches(i);
		end loop;
		gldepthmask(gl_true);
		for ii in 0..4 loop
			i:=pfar2near(ii);
			drawarches(i);
		end loop;

--------- end pillar with cornices --------------------------------------------








	if drawchalice and schalice=2 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);

		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		gluniform1i(cupFlag, 1 ); --light effects (always)
		glUniform1i(cupunifdark, 0); --castledarkness);
		if success then
			gluniform3f(cupColr, 123.0/255.0, 108.0/255.0, 6.0/255.0 ); --dgold
		else
			gluniform3f(cupColr, 30.0/255.0, 27.0/255.0, 2.0/255.0 ); --dddgold
		end if;
		glUniform1f(cupunifang, 0.0);

		gluniform3f(cupPos, xchalice,ychalice,zchalice );

		if thirdPerson then
			gluniform3f(cupeye, glfloat(xcam),glfloat(ycam),glfloat(zcam) );
		else
			gluniform3f(cupeye, glfloat(xme),glfloat(yme),glfloat(zme) );
		end if;


		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, wcup, hcup, wcup );

		gluniform1i(cupuniflev, 0); --foglev2 ); 
		gluniform1i(cupunifclr, 0); --fogclr2 ); 

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.ldraw(chalice, vertbuff,uvbuff,normbuff,elembuff);
	end if;




	if scene=2 then
		showWhatIsHeld;
	end if;

end draw_castle;


