
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_lab8 is







	barangle: float;
	ballsec: float;
	ibsec,ii,kk: integer;
	nslic: constant integer := 1000; --partitions per direction
	xfb1 : constant float := -ixmax+barrad;       -- one end
	xfb2 : constant float := +ixmax-barrad;       -- other end
	xxfb,yyfb,zzfb : float;


procedure getFireBallPos(xxx,yyy,zzz: out float) is
begin
----------------------------------------------------------------------
			ballsec := 0.06*float(sdl_getticks);
			ibsec := integer( ballsec );
			kk:= ibsec/nslic;
			ii:= 1 + ibsec mod nslic; -- 1..nslic = 1..1000
			if (kk mod 2 = 1) then
				null;
			else
				ii:= 1 + nslic - ii; -- 1001-i = 1..1000
			end if;
			xxx := xfb1 + float(ii-1)/float(nslic) * (xfb2-xfb1);
			yyy:= -iymax+barrad;
			zzz:= -9.2;
-----------------------------------------------------------------------
end getFireBallPos;










	hwdoor : constant float := 0.8;
	fhdoor : constant float := 1.8;

	xtc,ytc,ztc, xtr,ytr,ztr, yb : glfloat;

begin

		snake8rad := 7.0;

		snake8angl := 0.02*onepi*currenttime;

		-- given my coords, this defines a clockwise rotation:
		x8snake:= snake8rad*fmath.cos(snake8angl);
		z8snake:= snake8rad*fmath.sin(snake8angl);


		-- green mamba
		glUseProgram( snaketexshadid );
		gluniformmatrix4fv(snakemvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv(snakeMatrixID, 1, gl_false, imvp(1,1)'address );
		gluniform1i(snakeuniftex,0);
		glUniform3f(snakecenID, 0.0, glfloat( -iymax+0.02 ), 0.0 );
		glUniform1f(snakeunifrad, glfloat(snake8rad)); --circle radius
		glUniform1f(snakeunifangl, glfloat(snake8angl)); --angle around orbit
		glUniform1f(snakeunifwvel, 1.0 ); --wiggle freq
		glUniform1f(snakeunifwamp, 4.0 ); --wiggle amplitude

		glUniform1i(snakeunifdark, darkness8);
		gluniform1i(snakeuniflev, foglev8 ); 
		gluniform1i(snakeunifclr, fogclr8 ); 

		glbindtexture(gl_texture_2d, snake_texid);
		longtube.draw( snake, vertbuff,uvbuff,elembuff );






		--for normal textured objects:
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness8);

		gluniform1i(uniflev, foglev8 ); 
		gluniform1i(unifclr, fogclr8 ); 

		glbindtexture(gl_texture_2d, roots_texid);
		droomobj.draw(mdo8,vertbuff,uvbuff,elembuff); --textured room


		--floor
		glbindtexture(gl_texture_2d, slime_texid); -- nice slime!
		rectobj.draw(lfloor, vertbuff,uvbuff,elembuff);

		--doors
		glbindtexture(gl_texture_2d, doort_texid);
		pictobj.draw(g8, vertbuff,uvbuff,elembuff);
		pictobj.draw(h8, vertbuff,uvbuff,elembuff);

		--exit
		glbindtexture(gl_texture_2d, exit_texid);
		pictobj.draw(eh8, vertbuff,uvbuff,elembuff);

		--darkmaze
		glbindtexture(gl_texture_2d, dmaze_texid);
		pictobj.draw(eg8, vertbuff,uvbuff,elembuff);



		--labyrinth walls
		glbindtexture(gl_texture_2d, slime_texid); -- nice slime!
		for row in -mrows..mrows loop
		for col in -mcols..mcols loop
		if 
			iswall(8,row,col) and
			(kgate=0 or sgate/=8 or rgate/=row or cgate/=col)
		then
			pictobj.draw(
				mzwall(8,row,col), 
					vertbuff,uvbuff,elembuff);
		end if;
		end loop;
		end loop;

		if kgate>0 and sgate=8 then
			glbindtexture(gl_texture_2d, frame_texid); --passthru
			pictobj.draw(
				mzwall(8,rgate,cgate), 
					vertbuff,uvbuff,elembuff);
		end if;







		if not gkeyheld and sgkey=8  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=8 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=8 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=8 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;

		if not gateheld and sgate=8  and kgate=0 then
			glbindtexture(gl_texture_2d, frame_texid);
			pictobj.draw(gateway, vertbuff,uvbuff,elembuff);
		end if;













---------------------------------------------------------------
		-- addendum draw tree begin

		xtc:=0.0;
		ztc:=0.0;

		xtr:=2.0;
		ytr:=2.0;
		ztr:=xtr;

		ytc:=glfloat(-iymax) + ytr - 0.5;

		yb := glfloat(-iymax); -- ytc-ytr;


		--draw tree
		for k in 1..2 loop
			if k=1 then
				gldepthmask(gl_false);
			end if;

			glUseProgram(treeTexShadID);
			glUniformMatrix4fv(treeMatrixID, 1, GL_FALSE, imvp(1,1)'address);

			glUniformMatrix4fv(treeMVID, 1, GL_FALSE, imv(1,1)'address);
			glUniform1i(treelev, foglev8); --19dec17
			glUniform1i(treeclr, fogclr8); --19dec17

			glUniform1i(treeuniftex, 0);
			glUniform1i(treeunifdark, darkness8);
			glUniform1f(treeuniftime, glfloat(currentTime) ); 
			--shader makes them sway

			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

			----------------------------------------------------
			glUniform3f(treecenid, xtc,ytc,ztc );
			glUniform3f(treeradid, xtr,ytr,ztr );
			glUniform1f( treebaseunifid, yb );

			glUniform1i(treeunifid, glint(1) );
			glBindTexture(GL_TEXTURE_2D, tree8_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------

			if k=1 then
				gldepthmask(gl_true);
			end if;
		end loop; --tree




---------------------------------------------------------------

		if drawchalice and schalice=8 and not chaliceheld then
		-- use uniforms to set position
			glUseProgram(cupTexShadID);

			gluniform1i(cupFlag, 1 ); --light effects
			glUniform1f(cupunifang, 0.0);
			gluniform3f(cupColr, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
			gluniform3f(cupPos, xchalice,ychalice,zchalice );

			if thirdPerson then
				gluniform3f(cupeye, glfloat(xcam),glfloat(ycam),glfloat(zcam) );
			else
				gluniform3f(cupeye, glfloat(xme),glfloat(yme),glfloat(zme) );
			end if;



			glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
			glUniform1i(cupuniftex, 0);
			glUniform1i(cupunifdark, 0); --darkness8);
			glUniform3f(cupcenid, xchalice,ychalice,zchalice );
			glUniform3f(cupradid, wcup, hcup, wcup );

			gluniform1i(cupuniflev, 0); --foglev8 ); 
			gluniform1i(cupunifclr, 0); --fogclr8 ); 

			glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

			glbindtexture(gl_texture_2d, chalice_texid);
			xtreeobj.ldraw(chalice, vertbuff,uvbuff,normbuff,elembuff);

		end if;


---------------------------------------------------------------


		if scene=8 then
			showWhatIsHeld;
		end if;


		-- fancy fragshader draws B&W cloud ceiling
		glUseProgram( star2shadid );
		gluniformmatrix4fv( star2matid, 1, gl_false, imvp(1,1)'address );
		gluniform1f(star2timeid, glfloat(currentTime) );
		gluniform2f(star2resid, glfloat(winwidth), glfloat(winheight) );
		rectxobj.draw(rox,vertbuff,elembuff);




		if play9 then -- we are returning with chalice

		----------- draw fireball --------------------------------------

			glUseProgram(fireTexShadID); --===============================
			glUniform1i(funiftex, 0);
			glUniform1f(fopacid, 0.9);
			glUniform1f(fbrad, glfloat(barrad));
			glBindTexture(GL_TEXTURE_2D, ball_texid);

			-- begin fireball roll --------------------------------------
			BMVP := IMVP;

			getFireBallPos(xxfb,yyfb,zzfb);

			axis:=zaxis;

			bmm:=identity;
			translate(bmm, -xxfb,-yyfb,-zzfb ); --Xlate to origin
			barangle := -twopi*xxfb/(twopi*barrad) *rad2deg;
			degrotate(bmm, barangle, axis(1), axis(2), axis(3) ); --rotate
			translate(bmm, xxfb,yyfb,zzfb ); --Xlate back
			bmvp := bmm;
			matXmat( bmvp, imv ); --ViewMatrix );
			matXmat( bmvp, pm ); --ProjectionMatrix );

			-- we have to register bmvp AFTER it is redefined:
			gluniformmatrix4fv( fmatrixid, 1, gl_false, BMVP(1,1)'address );

			glUniform3f(firecenid,  --send current centroid to shaders
				glfloat(xxfb),glfloat(yyfb),glfloat(zzfb) );

			glUniform1f(ftimeid, glfloat(currenttime));

			fireballobj.draw(fireball,vertbuff,elembuff);

			if fmath.sqrt( sqr(xxfb-xme)+sqr(yyfb-yme)+sqr(zzfb-zme) ) 
				< barrad+margin then
				imdead_fireball:=true;
			end if;

			-- end fireball roll ------------------------------------------

		end if; --play9





end draw_lab8;


