
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_temple is
begin


		--for normal textured objects:
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness4);

		gluniform1i(uniflev, tfoglev ); 
		gluniform1i(unifclr, tfogclr ); 

		glbindtexture(gl_texture_2d, adobe_texid);
		droomobj.draw(tdo,vertbuff,uvbuff,elembuff); --textured room


		glbindtexture(gl_texture_2d, greekey_texid);
		rectobj.draw(zpwall, vertbuff,uvbuff,elembuff);
		rectobj.draw(zmwall, vertbuff,uvbuff,elembuff);
		rectobj.draw(xpwall, vertbuff,uvbuff,elembuff);
		rectobj.draw(xmwall, vertbuff,uvbuff,elembuff);

		glbindtexture(gl_texture_2d, mural_texid);
		pictobj.draw(zpmural, vertbuff,uvbuff,elembuff);


		--floor (only needed if different than walls)
		glbindtexture(gl_texture_2d, gmarble_texid);
		rectobj.draw(tfloor, vertbuff,uvbuff,elembuff);

		--ceiling (only needed if different than walls)
		glbindtexture(gl_texture_2d, gmarble_texid);
		rectobj.draw(rceil, vertbuff,uvbuff,elembuff);




		--pillars
		glbindtexture(gl_texture_2d, gmarble_texid);
		cylobj.draw(pillar3, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar4, vertbuff,uvbuff,elembuff);
		pictobj.draw(beam34, vertbuff,uvbuff,elembuff);

		cylobj.draw(pillar5, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar6, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar7, vertbuff,uvbuff,elembuff);

		cylobj.draw(pillar8, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar9, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar10, vertbuff,uvbuff,elembuff);


		--rocksafe
		glbindtexture(gl_texture_2d, greenrockwall_texid);
		pictobj.draw(rsafe, vertbuff,uvbuff,elembuff);



		if not gkeyheld and sgkey=4  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=4 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=4 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=4 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;

		if not gateheld and sgate=4  and kgate=0 then
			glbindtexture(gl_texture_2d, frame_texid);
			pictobj.draw(gateway, vertbuff,uvbuff,elembuff);
		end if;


-----------------------------------------------------------------


	if drawchalice and schalice=4 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);

		gluniform1i(cupFlag, 1 ); --no light effects
		glUniform1f(cupunifang, 0.0);
		gluniform3f(cupColr, 246.0/255.0, 216.0/255.0, 11.0/255.0 ); --gold
		gluniform3f(cupPos, xchalice,ychalice,zchalice );

		if thirdPerson then
			gluniform3f(cupeye, glfloat(xcam),glfloat(ycam),glfloat(zcam) );
		else
			gluniform3f(cupeye, glfloat(xme),glfloat(yme),glfloat(zme) );
		end if;



		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		glUniform1i(cupunifdark, 0);
		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, wcup, hcup, wcup );

		gluniform1i(cupuniflev, 0); --tfoglev ); 
		gluniform1i(cupunifclr, 0); --tfogclr ); 

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.ldraw(chalice, vertbuff,uvbuff,normbuff,elembuff);

	end if;



	if scene=4 then
		showWhatIsHeld;
	end if;


end draw_temple;


