
--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_castle is

	i,k: integer;



procedure drawarches(k: integer) is
begin
		glbindtexture(gl_texture_2d, gmarble_texid);
		glUniform1f(holeradid, glfloat(rr) );

		-- sort the arched "cornices" = rectangles with holes
		for ii in 1..4 loop
			ox(ii):=hox(ii,k);
			oz(ii):=hoz(ii,k);
		end loop;
		sort(cf2n,ox,oz,1,4,xme,zme);

		--now draw far to near
		for ii in 1..4 loop
			i:=cf2n(ii);
			glUniform3f(
				holecenid,
				glfloat(hox(i,k)),
				glfloat(hoy(i,k)),
				glfloat(hoz(i,k)) );
			--rectobj.draw(cornice(i,k), vertbuff,uvbuff,elembuff);
			rectobj.ldraw(cornice(i,k), vertbuff,uvbuff,normbuff,elembuff);
		end loop;

end drawarches;


	angl: float;

	castledarkness : glint := 3; 
	-- 3 => dark enough to savor lighting effects

begin


		
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );



		--gluniformmatrix3fv( pgmNorm, 1, gl_false, nm(1,1)'address );
		if success then
		gluniform1i(pgmFlag,1); -- 1=>use light effects
		else
		gluniform1i(pgmFlag,0); -- 1=>use light effects
		end if;
		gluniform3f(pgmColr, 1.0, 1.0, 1.0 ); --white

		gluniform3f(pgmPos1, xchalice+1.0,ychalice+1.0,zchalice );
		gluniform3f(pgmPos2, xchalice-1.0,ychalice+1.0,zchalice+1.0 );
		gluniform3f(pgmPos3, xchalice-1.0,ychalice+1.0,zchalice-1.0 );



		gluniform1i(uniftex,0);
		glUniform1i(unifdark, castledarkness);

		gluniform1i(uniflev, foglev2 ); 
		gluniform1i(unifclr, fogclr2 ); 



		--moorish alcove
		glbindtexture(gl_texture_2d, moorwall_texid);
		--pictobj.draw(wallmoor, vertbuff,uvbuff,elembuff);
		pictobj.ldraw(wallmoor, vertbuff,uvbuff,normbuff,elembuff);


		--floor
		glbindtexture(gl_texture_2d, floor_texid);
		--rectobj.draw(floor, vertbuff,uvbuff,elembuff);
		rectobj.ldraw(floor, vertbuff,uvbuff,normbuff,elembuff);

		--pedestal
		glbindtexture(gl_texture_2d, cherry_texid);
		--pictobj.draw(pedestal, vertbuff,uvbuff,elembuff);
		pictobj.ldraw(pedestal, vertbuff,uvbuff,normbuff,elembuff);

		--tapestry
		glbindtexture(gl_texture_2d, rug_texid);
		--pictobj.draw(rug, vertbuff,uvbuff,elembuff);
		pictobj.ldraw(rug, vertbuff,uvbuff,normbuff,elembuff);



		if not gkeyheld and sgkey=2  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;

		if not bkeyheld and sbkey=2 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=2 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=2 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;




-------- begin reflective pool -------------------------------

			glUseProgram( poolshadid );
			gluniformmatrix4fv( poolmvid, 1, gl_false, imv(1,1)'address );
			gluniformmatrix4fv( poolmatid, 1, gl_false, imvp(1,1)'address );
			gluniform1f(timeid, glfloat(currentTime) );
			gluniform3f(pcenid, glfloat(mpx(0)), 0.1, glfloat(mpz(0)) );
			gluniform3f(pradid, 1.9, 0.1, 1.9 );
			gluniform1f(wlevid, 0.15 ); --water level
			newrectsurf.draw(rso,vertbuff);

-------- end reflective pool -------------------------------






--------- begin pillar with cornices ------------------------------------------

		
		glUseProgram( holetexshadid );
		gluniformmatrix4fv( holemvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( holematrixid, 1, gl_false, imvp(1,1)'address );
		gluniform1i(holeuniftex,0);



		--gluniformmatrix3fv( holeNorm, 1, gl_false, nm(1,1)'address );
		if success then
		gluniform1i(holeFlag,1); -- 1=>use light effects
		else
		gluniform1i(holeFlag,0); -- 1=>use light effects
		end if;
		gluniform3f(holeColr, 1.0, 1.0, 1.0 ); --white

		gluniform3f(holePos1, xchalice+1.0,ychalice+1.0,zchalice );
		gluniform3f(holePos2, xchalice-1.0,ychalice+1.0,zchalice+1.0 );
		gluniform3f(holePos3, xchalice-1.0,ychalice+1.0,zchalice-1.0 );




		glUniform1i(holeunifdark, castledarkness);

		gluniform1i(holeuniflev, foglev2 ); 
		gluniform1i(holeunifclr, fogclr2 ); 



		glUniform1f(holeradid, 0.0 );
		glbindtexture(gl_texture_2d, adobe_texid); --13oct16
		cylobj.draw(iskylight, vertbuff,uvbuff,elembuff);

---------------------- begin room & ceiling -----------------------------
		-- we now draw room & ceiling here to draw
		-- a hole in the ceiling center:
		glUniform1f(holeradid, 0.5 );
		glUniform3f(holecenid, -5.0, glfloat(iymax), -5.0 );

		--main interior
		--glbindtexture(gl_texture_2d, room_texid);
		glbindtexture(gl_texture_2d, adobe_texid);
		droomobj.ldraw(cdo,vertbuff,uvbuff,normbuff,elembuff); --textured room

		--ceiling
		glbindtexture(gl_texture_2d, ceil_texid);
		pictobj.ldraw(ceil, vertbuff,uvbuff,normbuff,elembuff);
---------------------- end room & ceiling -----------------------------






		glUniform1f(holeradid, 0.0 ); --disable hole for other stuff


	if success then
		angl:=currentTime*onepi*0.1;

		--Korla Pandit
		twictobj.setrect2(korla,
			-5.0, 1.0, -5.0,
			0.2,      0.3, 0.2, angl,
			j1,j2,j3,j4,j5,j6);

		glbindtexture(gl_texture_2d, korla_texid);
		twictobj.draw(korla, vertbuff,uvbuff,elembuff);
	end if;




		glbindtexture(gl_texture_2d, bmarble_texid);
		rectobj.ldraw(slab, vertbuff,uvbuff,normbuff,elembuff); --pool roof

		--3 pool edges
		rectobj.ldraw(edgezm, vertbuff,uvbuff,normbuff,elembuff);
		rectobj.ldraw(edgezp, vertbuff,uvbuff,normbuff,elembuff);
		rectobj.ldraw(edgexp, vertbuff,uvbuff,normbuff,elembuff);











		for ii in 0..4 loop
			ox(ii):=mpx(ii);
			oz(ii):=mpz(ii);
		end loop;
		sort( pfar2near, ox, oz, 0,4, xme,zme );

		glbindtexture(gl_texture_2d, bmarble_texid);
		glUniform1f(holeradid, 0.0 );
		for i in 0..4 loop
			k:=pfar2near(i);
			cylobj.draw(moorishpillar(k), vertbuff,uvbuff,elembuff);
		end loop;

		-- the only way I've found to make these arches
		-- look correct is to draw twice:

		-- draw arches:
		gldepthmask(gl_false);
		for ii in 0..4 loop
			i:=pfar2near(ii);
			drawarches(i);
		end loop;
		gldepthmask(gl_true);
		for ii in 0..4 loop
			i:=pfar2near(ii);
			drawarches(i);
		end loop;






--------- end pillar with cornices --------------------------------------------




	if drawchalice and schalice=2 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);

		gluniform1i(cupFlag, 0 ); --no light effects


		glUniform1f(cupunifang, 0.0);

		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		if success then
			glUniform1i(cupunifdark, 0);
		else
			glUniform1i(cupunifdark, castledarkness);
		end if;
		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, wcup, hcup, wcup );

		gluniform1i(cupuniflev, foglev2 ); 
		gluniform1i(cupunifclr, fogclr2 ); 

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.draw(chalice, vertbuff,uvbuff,elembuff);
	end if;




	if scene=2 then
	
		-- glyphs drawn @ screen center
			showingGlyph:=false;

		if gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" => green key
			showingGlyph:=true;

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" => white key
			showingGlyph:=true;

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" => black key
			showingGlyph:=true;

		elsif swordheld then --draw sword
			utex.print2d("=",0.5,0.5,120); -- "=" => sword
			showingGlyph:=true;

		elsif chaliceheld then --draw chalice
			utex.print2d(";",0.5,0.5,80); -- ";" => chalice
			showingGlyph:=true;
		end if;

		if 
			(gkeynear or bkeynear or wkeynear or swordnear or chalicenear)
			and not gatewait and not lionwait and not mazewait
		then
			utex.print2d("`",0.5,0.4,50); -- "`" = hand
			showingHand:=true;
		else
			showingHand:=false;
		end if;

	end if;

end draw_castle;


