#version 330 core

// fragment shader
in vec2 UV;
in vec4 vEyeSpacePos;
in vec4 aPos;
out vec4 color;

uniform sampler2D myTextureSampler;

uniform int level;// 0=none, 1=>normal, 2=>heavy, 3=>extreme FOG
uniform int colr; // 0=true, 1=>grayish, 2=>brownish, 3=>purpleish FOG




const float fStart=0.0;
const float fEnd=10.0; // normal fog
const float sEnd= 5.0; // heavy fog
const float xEnd= 2.5; // extreme fog

const vec4 vFogColor=vec4(0.7,0.7,0.7,1.0); //normal white/gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brownish soot
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purplish fog

float getFogFactor(float rng, float altFrac)
{
	float fResult = 0.0;

	if(level==3) // extreme fog
		fResult = (xEnd-rng)/(xEnd-fStart);

	else if(level==2) // heavy fog
		fResult = (sEnd-rng)/(sEnd-fStart);

	else if(level==1) // normal fog
		fResult = (fEnd-rng)/(fEnd-fStart);
	else
		fResult=1.0;

	// at this point fResult=1 => transparent, fResult=0 => opaque

	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	// at this point fResult=0 => transparent, fResult=1 => opaque

	fResult *= (1.0-altFrac);
	
	return sqrt(sqrt(fResult));
}




const float yc=-2.85;
// -ymax+epsilon

uniform int darkness; // 0...4=darkest (bkgd)
const vec4 night = vec4(0.0,0.0,0.0,1.0);



void main(){
	color = texture( myTextureSampler, UV).rgba;
	if(color.a < 0.1) discard;

	float dist = length( vEyeSpacePos.xz );
	const float iymax=3.0;
	float altF = abs(aPos.y+iymax)/(2.0*iymax);
	clamp( altF, 0.0, 1.0);
	altF=altF*altF;

	if( colr==3 )
		color = mix(color, vMystColor, getFogFactor(dist,altF));
	else if( colr==2 )
		color = mix(color, vSootColor, getFogFactor(dist,altF));
	else if( colr==1 )
		color = mix(color,  vFogColor, getFogFactor(dist,altF));


	float df=0;
	if( darkness < 1 ) df=0.0;
	else if( darkness==1 ) df=0.3;
	else if( darkness==2 ) df=0.6;
	else if( darkness==3 ) df=0.8;
	else if( darkness>3 ) df=0.9;
	float asave=color.a;
	color = mix(color, night, df);
	color.a = asave;


}



//--
//-- Copyright (C) 2017  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

