pragma Ada_2012;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with SDL_stdinc_h;

package SDL_touch_h is

   --  unsupported macro: SDL_TOUCH_MOUSEID ((Uint32)-1)
   --  unsupported macro: SDL_MOUSE_TOUCHID ((Sint64)-1)
  --  Simple DirectMedia Layer
  --  Copyright (C) 1997-2019 Sam Lantinga <slouken@libsdl.org>
  --  This software is provided 'as-is', without any express or implied
  --  warranty.  In no event will the authors be held liable for any damages
  --  arising from the use of this software.
  --  Permission is granted to anyone to use this software for any purpose,
  --  including commercial applications, and to alter it and redistribute it
  --  freely, subject to the following restrictions:
  --  1. The origin of this software must not be misrepresented; you must not
  --     claim that you wrote the original software. If you use this software
  --     in a product, an acknowledgment in the product documentation would be
  --     appreciated but is not required.
  --  2. Altered source versions must be plainly marked as such, and must not be
  --     misrepresented as being the original software.
  --  3. This notice may not be removed or altered from any source distribution.
  -- 

  --*
  -- *  \file SDL_touch.h
  -- *
  -- *  Include file for SDL touch event handling.
  --  

  -- Set up for C function definitions, even when using C++  
   subtype SDL_TouchID is SDL_stdinc_h.Sint64;  -- ../../inc10/SDL2/SDL_touch.h:41

   subtype SDL_FingerID is SDL_stdinc_h.Sint64;  -- ../../inc10/SDL2/SDL_touch.h:42

  -- touch screen with window-relative coordinates  
  -- trackpad with absolute device coordinates  
  -- trackpad with screen cursor-relative coordinates  
   subtype SDL_TouchDeviceType is int;
   SDL_TOUCH_DEVICE_INVALID : constant int := -1;
   SDL_TOUCH_DEVICE_DIRECT : constant int := 0;
   SDL_TOUCH_DEVICE_INDIRECT_ABSOLUTE : constant int := 1;
   SDL_TOUCH_DEVICE_INDIRECT_RELATIVE : constant int := 2;  -- ../../inc10/SDL2/SDL_touch.h:50

   type SDL_Finger is record
      id : aliased SDL_FingerID;  -- ../../inc10/SDL2/SDL_touch.h:54
      x : aliased float;  -- ../../inc10/SDL2/SDL_touch.h:55
      y : aliased float;  -- ../../inc10/SDL2/SDL_touch.h:56
      pressure : aliased float;  -- ../../inc10/SDL2/SDL_touch.h:57
   end record
   with Convention => C_Pass_By_Copy;  -- ../../inc10/SDL2/SDL_touch.h:52

  -- Used as the device ID for mouse events simulated with touch input  
  -- Used as the SDL_TouchID for touch events simulated with mouse input  
  -- Function prototypes  
  --*
  -- *  \brief Get the number of registered touch devices.
  --  

   function SDL_GetNumTouchDevices return int  -- ../../inc10/SDL2/SDL_touch.h:72
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_GetNumTouchDevices";

  --*
  -- *  \brief Get the touch ID with the given index, or 0 if the index is invalid.
  --  

   function SDL_GetTouchDevice (index : int) return SDL_TouchID  -- ../../inc10/SDL2/SDL_touch.h:77
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_GetTouchDevice";

  --*
  -- * \brief Get the type of the given touch device.
  --  

   function SDL_GetTouchDeviceType (touchID : SDL_TouchID) return SDL_TouchDeviceType  -- ../../inc10/SDL2/SDL_touch.h:82
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_GetTouchDeviceType";

  --*
  -- *  \brief Get the number of active fingers for a given touch device.
  --  

   function SDL_GetNumTouchFingers (touchID : SDL_TouchID) return int  -- ../../inc10/SDL2/SDL_touch.h:87
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_GetNumTouchFingers";

  --*
  -- *  \brief Get the finger object of the given touch, with the given index.
  --  

   function SDL_GetTouchFinger (touchID : SDL_TouchID; index : int) return access SDL_Finger  -- ../../inc10/SDL2/SDL_touch.h:92
   with Import => True, 
        Convention => C, 
        External_Name => "SDL_GetTouchFinger";

  -- Ends C function definitions when using C++  
  -- vi: set ts=4 sw=4 expandtab:  
end SDL_touch_h;
