
--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with matutils;  use matutils;
with gametypes;  use gametypes;



with glfw3; use glfw3;


with interfaces.c;
with interfaces.c.strings;
with glext;
with glext.pointers;
with glext.binding;
with gl;
with gl.binding;
with gl.pointers;





package gameutils is


	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;


	mainWindow : access GLFWwindow;

	procedure myassert( 
		condition : boolean;  
		flag: integer:=0;
		msg: string := "");

function fmod( numer, denom : float ) return float;

	function odd( i: integer ) return boolean;

	function sqr( x: float ) return float;
	function min( x,y: float ) return float;
	function mini( i,j: integer ) return integer;



	function hordistance( x1,y1, x2,y2 : float ) return float;

	procedure moveforward( currenttime: gldouble );
	procedure movebackward( currenttime: gldouble );

	procedure first_prep(
		HiRes: boolean := false);


procedure InitGLFW( width, height : glint; name: string );
procedure InitGLFWfs( name: string; wid, hit, fwd,fht : in out glint );




	procedure updategamestate;
	procedure updateCamera(init: boolean := false);

	procedure updateMVPs( 
		et: gldouble;
		wid,hit : float; upd8: boolean:=false );

	procedure slewToAvLook;
	procedure slewToAv;




	procedure handle_mouse_move( nowTime : gldouble );

	procedure handle_gc_look(gcx,gcy:float);
	procedure handle_gc_move(nowTime:gldouble; gcx,gcy:float);





	procedure liftmaze;
	procedure slidelab;
	procedure liftlion;
	procedure liftgate( n: integer );



	function land_alt( x,z : float ) return float;

	procedure sendBat;
	procedure drawbat( dt: gldouble );
	procedure drawRdragon( dt: gldouble );
	procedure drawBdragon( dt: gldouble );
	procedure drawMinotaur( dt: gldouble );
	function angl( x1,y1,z1, x2,y2,z2 : float ) return float;

	procedure initializeNewMazes;


	function snakehiss return boolean;
	function nearsnake return boolean;

	procedure drawspider( dt: gldouble );


	procedure sort( 
		f2n: in out sortarray;  -- output permutations
		ox,oz : limarray;       -- pos of each object
		lo, hi : integer;       -- bounds of sort
		eyex,eyez : float       -- xme, zme
		);


	procedure emptyGLerrorQueue;

	function dumpGLerrorQueue(id: string) return integer;


	function atThreshold(	
		timenow: gldouble; 
		str: string;
		sene: integer ) return boolean;


	procedure showWhatIsHeld;


	procedure insertgate( k: integer );


procedure updateBull( --28may18
	mytime: gldouble;
	xme,zme: float;
	xm,ym,zm,am: in out float;
	idir: out integer;
	collide: out boolean
	);
procedure drawBull( 
	mytime: gldouble;
	xb,yb,zb,hang : float;
	idir: integer
	);

procedure writeState;
procedure readState;
procedure setState;

end gameutils;
