#!/bin/sh


if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# compile the c++ interface to SFML sounds:
g++ adabindings/sfmlAudio/snd4ada.cpp \
-c -Werror -fPIC -I$PWD/incSFML250

ar -crs $PWD/libs/osx/libsnd4ada.a snd4ada.o

rm snd4ada.o

#--------------------------------------------------------


# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2019/bin:$PATH


gnatmake  adaventure -O3  \
-o adaventure_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs -lm -lz \
-lc++ \
$PWD/libs/osx/libsnd4ada.a \
$PWD/libs/osx/libglfw3.a \
$PWD/libs/osx/libiconv.a \
$PWD/libs/osx/libopenal.a \
$PWD/libs/osx/libsfml250-audio-s.a \
$PWD/libs/osx/libsfml250-system-s.a \
$PWD/libs/osx/libogg.a \
$PWD/libs/osx/libFLAC-static.a \
$PWD/libs/osx/libvorbis.a \
$PWD/libs/osx/libvorbisenc.a \
$PWD/libs/osx/libvorbisfile.a \
$PWD/libs/osx/libfreetype.a \
$PWD/libs/osx/libpng16.a \
$PWD/libs/osx/libbz2.a \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-pthread 


