#version 330 core
layout(location = 0) in vec3 vertexPos;
out vec2 UV;

uniform mat4 MVP;
uniform float mytime;

uniform vec3 wPos;
uniform vec3 wRad;

uniform float waterlevel;

const float pi = 3.14159;
const float amplitude=0.0; //was 0.005
const float npeaks=2;
const float speed=0.4;

float wave(float r) {
    return amplitude * sin( npeaks*(mytime*speed+r)*2*pi);
}

float waveHeight(float x, float z) {
	float rad = sqrt(x*x+z*z);
   float height = 0.0;
   height += wave(rad);
   return height;
}


void main(){
	vec3 pos = vertexPos;

	float xmin=wPos.x-wRad.x;
	float xmax=wPos.x+wRad.x;
	float zmin=wPos.z-wRad.z;
	float zmax=wPos.z+wRad.z;
	UV = vec2( (pos.x-xmin)/(xmax-xmin), (pos.z-zmin)/(zmax-zmin) );

	//pos.y = waterlevel + waveHeight(vertexPos.x-wPos.x, vertexPos.z-wPos.z);
	pos.y = waterlevel;

	gl_Position =  MVP * vec4(pos,1.0);
}


