--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;


----------------------------------------------------------------
with sdl;  use sdl;
----------------------------------------------------------------

with matutils;
with ftex;
with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;

----------------------------------------------------------------


with shader;  use shader;

with cubemapobj;
with droomobj;
with xtreeobj;
with w3treeobj;
with rectobj;
with rectxobj;
with avatarobj;
with pictobj;
with twictobj;
with cylobj;

with holesurfobj;


with text_io;
with pngloader;
with gametypes;
with gameutils;
with matutils;

with ada.calendar;

with snd4ada_hpp;



package body avent is


	use text_io;
	use pngloader;
	use gametypes;
	use gameutils;
	use matutils;
	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;


	nerr: integer;


-- this new surface allows a building to extend below it...
-- 20X20 X-Z grid per quadrant => 40X40, 
-- with square hole @ (-5,-5) of radius 5:
--package terrain is new holesurfobj(20,20,land_alt,-5.0,-5.0,5.0,5.0);

-- experiment to fix jitter on Gateway (still looks fine):
-- this new surface allows a building to extend below it...
-- 10X10 X-Z grid per quadrant => 20X20, 
-- with square hole @ (-5,-5) of radius 5:
package terrain is new holesurfobj(10,10,land_alt,-5.0,-5.0,5.0,5.0);
grounds : terrain.holesurf;


procedure setup_maze9 is separate;
procedure draw_maze9 is separate;


procedure setup_lab8 is separate;
procedure draw_lab8 is separate;

procedure setup_maze7 is separate;
procedure draw_maze7 is separate;

procedure setup_maze5 is separate;
procedure setup_maze6 is separate;
procedure draw_maze5 is separate;
procedure draw_maze6 is separate;

procedure setup_exterior(chapter: integer) is separate;
procedure draw_exterior(chapter: integer) is separate;

procedure setup_castle is separate;
procedure draw_castle is separate;


procedure setup_temple is separate;
procedure draw_temple is separate;




procedure release_textures is separate;
procedure setup_textures is separate;




procedure aventure( chapter: integer; jump: integer:=0 ) is





type itemtype is (pgate, gkee, bkee, wkee, srd, cup);

procedure dropitem( item: itemtype ) is
begin

	if item=pgate then --purple Gate portal

		if insertable>0 then

			insertgate(insertable);
			insertable:=0;

		else

			kgate:=0; -- => inactive gateway (on ground)
			xgate:=xme;
			zgate:=zme;
			sgate:=scene;
			gateheld:=false;
			if scene=2 then
				ygate:=htobj;
			elsif interior then
				ygate:=-iymax+2.0*htobj;
			else
				ygate:=2.0*htobj+land_alt(xme,zme);
			end if;

			pictobj.setrect( 
				gateway, 
				xgate,ygate,zgate, --xc,yc,zc
				0.2, 0.0, 0.2, --xr,yr,zr
				j1,j2,j3,j4,j5,j6);

		end if;


	elsif item=gkee then --green key

		xgkey:=xme;
		zgkey:=zme;
		sgkey:=scene;
		gkeyheld:=false;
		if scene=2 then
			ygkey:=htobj;
		elsif interior then
			ygkey:=-iymax+2.0*htobj;
		else
			ygkey:=htobj+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key3, 
			xgkey,ygkey,zgkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);


	elsif item=bkee then --black key

		xbkey:=xme;
		zbkey:=zme;
		sbkey:=scene;
		bkeyheld:=false;
		if scene=2 then
			ybkey:=htobj;
		elsif interior then
			ybkey:=-iymax+2.0*htobj;
		else
			ybkey:=htobj+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key2, 
			xbkey,ybkey,zbkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);

	elsif item=wkee then --white key

		xwkey:=xme;
		zwkey:=zme;
		swkey:=scene;
		wkeyheld:=false;
		if scene=2 then
			ywkey:=htobj;
		elsif interior then
			ywkey:=-iymax+2.0*htobj;
		else
			ywkey:=htobj+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key1, 
			xwkey,ywkey,zwkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);

	elsif item=srd then

		xsword:=xme;
		zsword:=zme;
		ssword:=scene;
		swordheld:=false;
		if scene=2 then
			ysword:=htobj;
		elsif interior then
			ysword:=-iymax+2.0*htobj;
		else
			ysword:=htobj+land_alt(xme,zme);
		end if;


		pictobj.setrect( 
			sword, 
			xsword,ysword,zsword,
			rsword, 0.0, 0.2*rsword,
			j1,j2,j3,j4,j5,j6);


	elsif item=cup then

		xchalice:=glfloat(xme);
		if scene=2 then
			ychalice:=glfloat(htobj)+hcup;
		elsif interior then
			ychalice:=glfloat(-iymax+htobj)+hcup;
		else
			ychalice:=glfloat(htobj+land_alt(xme,zme))+hcup;
		end if;
		zchalice:=glfloat(zme);
		schalice:=scene;
		chaliceheld:=false;
		-- uses [dynamic] uniform-positioning @ draw-time

	end if;

end dropitem;



-- decide if object is picked
procedure pickLeft( item: itemtype ) is
begin

if 
	not gatewait and
	not lionwait and
	not labwait and
	not mazewait 
then

	if item=pgate then

		if swordheld then dropitem(srd);
		elsif wkeyheld then dropitem(wkee);
		elsif gkeyheld then dropitem(gkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		kgate:=0; --=> gateway inactive (on ground or held)

		gateheld:=true;
		gkeyheld:=false; 
		swordheld:=false; 
		chaliceheld:=false; 
		bkeyheld:=false;
		wkeyheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=gkee then

		if swordheld then dropitem(srd);
		elsif gateheld then dropitem(pgate);
		elsif wkeyheld then dropitem(wkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		gkeyheld:=true; 
		swordheld:=false; 
		chaliceheld:=false; 
		bkeyheld:=false;
		wkeyheld:=false;
		gateheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=wkee then

		if swordheld then dropitem(srd);
		elsif gateheld then dropitem(pgate);
		elsif gkeyheld then dropitem(gkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		wkeyheld:=true; swordheld:=false; chaliceheld:=false; 
		bkeyheld:=false;
		gkeyheld:=false;
		gateheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=bkee then

		if swordheld then dropitem(srd);
		elsif gateheld then dropitem(pgate);
		elsif wkeyheld then dropitem(wkee);
		elsif gkeyheld then dropitem(gkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		bkeyheld:=true; swordheld:=false; 
		chaliceheld:=false; wkeyheld:=false;
		gkeyheld:=false;
		gateheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=srd then

		if wkeyheld then dropitem(wkee);
		elsif gateheld then dropitem(pgate);
		elsif bkeyheld then dropitem(bkee);
		elsif gkeyheld then dropitem(gkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		swordheld:=true; wkeyheld:=false; 
		chaliceheld:=false; bkeyheld:=false;
		gkeyheld:=false;
		gateheld:=false;
		snd4ada_hpp.playSnd(up); --pickup

	elsif item=cup then

		if swordheld then dropitem(srd);
		elsif gateheld then dropitem(pgate);
		elsif bkeyheld then dropitem(bkee);
		elsif gkeyheld then dropitem(gkee);
		elsif wkeyheld then dropitem(wkee);
		end if;

		chaliceheld:=true; swordheld:=false; 
		wkeyheld:=false; bkeyheld:=false;
		gkeyheld:=false;
		gateheld:=false;
		chalicegone:=true; --do NOT show inside rocksafe
		drawchalice:=true; --...but DO draw it as soon as dropped

		if play9 and not stop9 then
			snd4ada_hpp.stopLoop(tmpl4);
			stop9:=true;
		elsif play4 and not stop4 then
			snd4ada_hpp.stopLoop(tmpl4);
			stop4:=true;
		end if;
		snd4ada_hpp.playSnd(up); --pickup

	end if; -- cup


end if; -- not wait

end pickLeft;







procedure drawAvatar( mytime : float ) is

begin
	
	glUseProgram(pidava07);
	glUniformMatrix4fv(mvpid07, 1, GL_FALSE, imvp(1,1)'address);
	glUniform1f(hangid07, glfloat(horiang));
	glUniform1i(dirid07, glint(direction));

	if showingHand then
		glUniform1i(fadid07, 1); -- fade avatar
	else
		glUniform1i(fadid07, 0); -- no fade
	end if;

	glUniform1f(timeid07, glfloat(mytime));

	glUniform3f(cenid07, 
		glfloat(xme),glfloat(yme-aheight),glfloat(zme) );

	glUniform1i(sampid07, 0);

	glbindtexture(gl_texture_2d, ava_texid);
	avatarobj.draw(ava, vertbuff,uvbuff,elembuff);

end drawAvatar;



procedure pickOrDrop is
begin

---------------------------------------------------------------
		-- perhaps an item is being picked...

			if sgate=scene and pgatenear then --pgate
				pickLeft(pgate);

			-- green key logic:
			elsif sgkey=scene and gkeynear  then
				pickLeft(gkee);

			-- black key logic:
			elsif sbkey=scene and bkeynear  then
				pickLeft(bkee);

			-- white key logic:
			elsif swkey=scene and wkeynear  then
				pickLeft(wkee);

			-- sword logic:
			elsif ssword=scene and swordnear  then
				pickLeft(srd);

			-- chalice logic:
			elsif schalice=scene and chalicenear  then
				pickLeft(cup);


		-- or maybe an item is being dropped...


			--elsif gateheld and insertable>0 then
			elsif gateheld then
				gateheld:=false;
				dropitem(pgate);
				snd4ada_hpp.playSnd(down); --putdown


			elsif wkeyheld and not gatewait then
				wkeyheld:=false;
				dropitem(wkee);
				snd4ada_hpp.playSnd(down); --putdown


			elsif gkeyheld and not mazewait then
				gkeyheld:=false;
				dropitem(gkee);
				snd4ada_hpp.playSnd(down); --putdown

			elsif bkeyheld and not lionwait and not labwait then
				bkeyheld:=false;
				dropitem(bkee);
				snd4ada_hpp.playSnd(down); --putdown


			elsif swordheld then
				swordheld:=false;
				dropitem(srd);
				snd4ada_hpp.playSnd(down); --putdown


			elsif chaliceheld then
				chaliceheld:=false;
				dropitem(cup);
				snd4ada_hpp.playSnd(down); --putdown

				if interior and scene=2 and pedestalnear then
					xchalice:=xped;
					ychalice:=yped+hcup;
					zchalice:=zped;
					success:=true;
				end if;

			end if;
-----------------------------------------------

end pickOrDrop;











	sz: float;

	winnertime, warningtime: float:=0.0;
	warningpause: constant float := 3.0;
	warningreset: constant float := 60.0;

	keydwell: constant float := 2.0; --seconds
	hdang,dt,btntime,keytime, dxme : float := 0.0;

	reenter, roarbegun, runAway: boolean:=false; --used for red dragon

	dbug: boolean := false;
	--dbug: boolean := true;

	avent_main_error : exception;


	fontcol: constant vec4 := (1.0,1.0,1.0,1.0); --white


-- 44 pages down to utex/ftex

-------------------------- main program begin ==========================
begin --adaventure


	new_line;
	new_line;
	put_line("Please be patient...AdaVenture is slow to load...");
	put_line("...starting Level " & integer'image(chapter) );
	new_line;
	new_line;


	first_prep;  -- main program setup
	-- NOW, we may begin tesing for GLerrors

	nerr:=dumpGLerrorQueue("AV.main_1");

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	emptyGLerrorQueue; -- avoid misleading messages in setup_textures
	setup_textures; -- prep various textures

	nerr:=dumpGLerrorQueue("AV.main_2");


	initializeNewMazes;

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	currentTime := float(sdl_getticks)/1000.0;
	updateMVPs( currentTime, float(winwidth), float(winheight) );





	nko:=0;
	setup_exterior(chapter);
	setup_castle;

	if chapter=1 then
		setup_maze5;
		setup_maze6;
		setup_temple;
	elsif chapter=2 then
		setup_maze7;
		setup_lab8;
		setup_maze9;
	end if;
	-- note:  darkness set in draw_exterior...
	-- ch 1:  if chaliceheld then d:=1 (bright day) else d:=2
	-- ch 2:  if chaliceheld then d:=2 (dark night) else d:=1

	put("nko="&integer'image(nko));
	put_line(", maxnko="&integer'image(maxnko));



	xtreeobj.setrect(chalice);

	nuscene:=1; -- starting scene
	xme:= -5.0;
	zme:=-15.0;
	yme:=aheight+land_alt(xme,zme);

	xcam:=xme; ycam:=yme; zcam:=zme;



-- these jump clauses ONLY for debug:

if jump=3 then --debug just outside castle with chalice

	-- with chalice:
	xchalice:=-5.0;
	ychalice:=glfloat(htobj)+hcup;
	zchalice:=-5.0;
	schalice:=2;
	intro:=false;

	-- debug quick access key:
	xwkey:=-5.0; zwkey:=-13.0; swkey:=1;
	ywkey:=0.2+htobj+land_alt(xwkey,zwkey);
	pictobj.setrect( key1, xwkey,ywkey,zwkey,
	0.1, 0.0, 0.1, j1,j2,j3,j4,j5,j6);


elsif jump=9 then --maze9 (orange2)

	nuscene:=9;
	scene:=9;
	interior:=true;
	xme:= 9.6;
	zme:= -9.6; --7.0;
	yme:=-iymax+aheight;
	gateheld:=true;
	kgate:=0; --=>gateway inactive
	intro:=false;
	minotaurdead:=true;
	horiang:=-halfpi;

elsif jump=8 then --lab

	nuscene:=8;
	scene:=7;
	interior:=true;
	xme:= 2.0;
	zme:= 2.0;
	yme:=-iymax+aheight;
	swordheld:=true;
	ssword:=8;
	intro:=false;
	openlab:=true;
	labopen:=true;

elsif jump=7 then --maze7:

	nuscene:=7;
	scene:=7;
	interior:=true;
	xme:= 0.0;
	zme:= 0.0;
	yme:=-iymax+aheight;
	intro:=false;

	swordheld:=true;
	ssword:=7;
	-- want open door, holding cup
	--chaliceheld:=true;
	--schalice:=7;
	mazeopen:=true;

elsif jump=5 then --maze5:

	nuscene:=5;
	scene:=5;
	interior:=true;
	xme:= 0.0;
	zme:= 0.0;
	yme:=-iymax+aheight;
	swordheld:=true;
	ssword:=5;
	intro:=false;
	mazeopen:=true;

elsif jump=6 then --maze6

	nuscene:=6;
	scene:=5;
	interior:=true;
	xme:= 0.0;
	zme:= 0.0;
	yme:=-iymax+aheight;
	swordheld:=true;
	ssword:=6;
	intro:=false;

elsif jump=4 then --greek temple:

	nuscene:=4;
	scene:=5;
	interior:=true;
	xme:= 0.0;
	zme:= 0.0;
	yme:=-iymax+aheight;
	swordheld:=true;
	ssword:=4;
	intro:=false;

end if;



-- scene 1: exterior 		(ch1,2)
-- scene 2: castle			(ch1,2)
-- scene 3: NONE...deleted
-- scene 4: greek temple	(ch1)
-- scene 5: maze5				(ch1)
-- scene 6: maze6				(ch1)
-- scene 7: maze7				(ch2)
-- scene 8: labyrinth		(ch2)
-- scene 9: darkMaze			(ch2)









	-- prepare font-related shaders & uniforms -------------
	ftex.InitFont ( winwidth, winheight, "data/Canterbury.ttf" );






	nerr:=dumpGLerrorQueue("AV.main_3");
	-- begin mainloop with a clean slate



	-- main event loop begin: ------------------------------------------
   while not userexit loop

		direction:=0;

		if nuscene /= scene then

			if nuscene=1 then interior:=false;
			else interior:=true; end if;


			if 
				(nuscene=9 and scene=8)
				or (nuscene=8 and scene=9)
			then
				-- no coordinate change
				-- but we must turn onepi
				horiang := onepi + horiang;
			end if;


			if nuscene=1 then
				if scene=2 and seen1already and not bdragonsent then
					bdragonfly:=true;
					dragonstart:=float(sdl_getticks)/1000.0;

					bdragonsent:=true;
				end if;
				seen1already:=true; 
			end if;


			if nuscene=5 then -- chapter 1
				if scene=1 and not rdragonsent then
					rdragonfly:=true;
					runAway:=false; --deadly encounter
					dragonstart:=float(sdl_getticks)/1000.0;

					rdragonsent:=true;
				end if;
			end if;


			-- NewStoryLine chapter 2:
			-- send red dragon on first exit of Lab8 if Minotaur is dead;
			-- this prevents simply sneaking out with chalice...
			if 
				nuscene=7 and scene=8 and minotaurdead 
				and not rdragondead -- limit to single deadly encounter
			then --return from Lab
				--send Red Dragon and hope user has sword!
				rdragonfly:=true;
				runAway:=false; --2nd encounter is deadly
				dragonstart:=float(sdl_getticks)/1000.0;
			elsif nuscene=7 and chaliceheld and not bat7sent then -- send bat
				sendBat; -- just once per scene
				bat7sent:=true;
			elsif nuscene=7 and scene=1 and not chaliceheld then --1st maze entry
				--send Red Dragon and hope user has sword!
				rdragonfly:=true;
				runAway:=true; --runs away @ first encounter
				dragonstart:=float(sdl_getticks)/1000.0;
			elsif nuscene=1 and scene=7 and chaliceheld and not bat9sent then
				sendBat; -- just once per scene
				bat9sent:=true;
			end if;


			-- call is always Ok, even if no music is playing...
			snd4ada_hpp.stopLoops;

			scene:=nuscene; --<<<<<<<<<<<<<<<<<<<<<<<<<<<
			if chaliceheld then schalice:=scene; end if;
			if swordheld then ssword:=scene; end if;
			if wkeyheld then swkey:=scene; end if;
			if gkeyheld then sgkey:=scene; end if;
			if bkeyheld then sbkey:=scene; end if;
			if gateheld then sgate:=scene; end if;


			if scene=4 or jump=4 then --temple(westfold.wav)
				if not play4 then
					snd4ada_hpp.playLoop(tmpl4);
					play4:=true;
				end if;
			elsif scene=8 or jump=8 then --labyrinth(cephalopod)
				if 
					play9            -- return entry...another danger
					or
					not minotaurdead -- first entry...danger
				then
					snd4ada_hpp.playLoop(ceph8);
				end if;
			elsif scene=2 then --castle pool
				snd4ada_hpp.playLoop(water);

				if success then
					if chapter=1 then snd4ada_hpp.playLoop(misr); --Misr;
					elsif chapter=2 then snd4ada_hpp.playLoop(turk); --Turk; 
					end if;
				end if;

			end if;

			--19dec16 addendum to correct direction after entry
			ahoriang:=horiang;
			choriang:=horiang;
			updateCamera(true); 
			-- initialize=true => reset (xcam,zcam) whether moving or not

		end if; -- nuscene /= scene =================================


		if reenter then
			ahoriang:=horiang;
			choriang:=horiang;
			updateCamera(true); 
			-- initialize=true => reset (xcam,zcam) whether moving or not
			reenter:=false;
		end if;


		if scene=5 and bkeyseen and not bat5sent then
			sendBat; -- just once per scene
			bat5sent:=true;
		end if;

		if scene=1 and wkeyseen and not bat1sent then
			sendBat; -- just once per scene
			bat1sent:=true;
		end if;








	-- main event loop middle: -----------------------------------------------

------- begin response to user inputs ////////////////////////////////////

		currentTime := float(sdl_getticks)/1000.0;


		if ((currenttime-warningtime)>warningreset) then
			warning1:=false;
			-- if you avoid the snake for 1 minute
			-- then you will, again, get a warning
		end if;


		SDL_PumpEvents;
		key_map := sdl_getkeyboardstate(numkeys'access);


		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then userexit:=true; end if;
		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then userexit:=true; end if;

		if
			( key_map( SDL_SCANCODE_I ) /= 0 )
			and (currentTime-keytime>keydwell)
		then 
			intro:=not intro; 
			keytime:=currentTime;


		elsif
			( key_map( SDL_SCANCODE_L ) /= 0 )
			and (currentTime-keytime>keydwell)
		then 
			lazyCam:=not lazyCam;
			keytime:=currentTime;


		elsif
		(
			( key_map( SDL_SCANCODE_M ) /= 0 )
			or
			( key_map( SDL_SCANCODE_F1 ) /= 0 )
		)
			and (currentTime-keytime>keydwell)
		then
			thirdPerson:=not thirdPerson;
			keytime:=currenttime;


		elsif 
			( key_map( SDL_SCANCODE_SPACE ) /= 0 )
			and (currentTime-keytime>keydwell)
		then
			pickOrDrop;
			keytime:=currenttime;

		end if;


		if
			( key_map( SDL_SCANCODE_UP ) /= 0 )
			or ( key_map( SDL_SCANCODE_W ) /= 0 )
		then 
			moveForward(currentTime); --updategamestate called

		elsif
			( key_map( SDL_SCANCODE_DOWN ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_S ) /= 0 )
		then 
			moveBackward(currentTime); --updategamestate called

		end if;
		

		-- debug asistant:
		if
			( key_map( SDL_SCANCODE_X ) /= 0 ) 
		then 

			put("scene="&integer'image(scene));
			put(", horiangDeg="&float'image(horiang*rad2deg));
			put_line(", me: "
				&float'image(xme)&","
				&float'image(yme)&","&float'image(zme));
			new_line;

		end if;
		


-----	///////////////////// begin response to mouse wheel

		if SDL_PollEvent(test_event'access)>0 
		and then test_event.typ = SDL_MouseWheel then

			if test_event.wheel.y<0 then --move eye closer by 1%
				camdist := 0.99*camdist;
				if camdist<0.1 then camdist:=0.1; end if;

			else --move eye away by 1%
				camdist := 1.01*camdist;
				if camdist>10.0 then camdist:=10.0; end if;

			end if;

		end if;


-----	///////////////////// begin response to mouse buttons

		if abs(currentTime-pltime)>pickdwell then

			MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
			state := integer( MouseState );
			ileft := integer( SDL_BUTTON(1) );
			--iright:= integer( SDL_BUTTON(3) );

			if    bitmatch(state, ileft)   then --left mouse btn was pressed
				pltime:=currentTime;
				pickOrDrop;

			elsif bitmatch(state, iright) then --right mouse btn was pressed
				null;
			end if;

		end if; -- dt>pickdwell



		deltaT := currentTime - oldTimeKb;

		if
			( key_map( SDL_SCANCODE_LEFT ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_A ) /= 0 )
		then
			roty := +0.5*deltaT;
			if thirdperson then
				hdang := angrate3*roty;
			else
				hdang := angrate1*roty;
			end if;
			horiang := horiang + hdang;
			--slewToAvLook;
			slewToAv; --27jan18

			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			updategamestate; --automatic in moveforward

		elsif
			( key_map( SDL_SCANCODE_RIGHT ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_D ) /= 0 )
		then
			roty := -0.5*deltaT;
			if thirdperson then
				hdang := angrate3*roty;
			else
				hdang := angrate1*roty;
			end if;
			horiang := horiang + hdang;
			--slewToAvLook;
			slewToAv; --27jan18

			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			updategamestate; --automatic in moveforward

		end if;


		handle_mouse_move(currentTime);


----------- begin game controller ---------------------------------
	if joystik or gamepad then

		-- axis values in [-32768...+32767]

		-- JS: 2nd Axis parm:  0..2
		-- GC: 2nd Axis parm:  0..3

		-- unresolved question:  how do I prevent spinning @ startup?

		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
		handle_gc_left(axis_lx,axis_ly);

		if gamepad then -- these handle move forward/backward
			axis_rx := SDL_JoystickGetAxis(jsa, 2);
			axis_ry := SDL_JoystickGetAxis(jsa, 3);
			handle_gc_right(currentTime,axis_rx,axis_ry);
		end if;

		-- now for the buttons:

		-- 1 => pressed,  0 => not pressed
		-- JS: 2nd Btn parm:  0..7
		-- GC: 2nd Btn parm:  0..11

		zeroBtns; -- set btns 0..8 to zero
		if gamepad then
			btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- pick&drop(LtShoulder)
			btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- pick&drop(RtShoulder)
			btn_8 := SDL_JoystickGetButton(jsa,gjmp); -- 
		elsif joystik then
			btn_0 := SDL_JoystickGetButton(jsa,jbak); -- moveBackward(trigger)
			btn_1 := SDL_JoystickGetButton(jsa,jfor); -- moveForward(thumb)
			btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- pick&drop(thumb)
			btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- pick&drop(thumb)
			btn_7 := SDL_JoystickGetButton(jsa,jjmp); -- 
		end if;

		if gamepad then
			if 
				(btn_4>0 or btn_5>0 or btn_8>0) and
				(currentTime-btntime>keydwell)
			then --pick/drop
				pickOrDrop;
				btntime:=currenttime;
			end if;
		end if;

		if joystik then
			if    btn_0>0 then -- JS.trigger
				moveBackward(currentTime);
			elsif btn_1>0 then -- JS.thumb
				moveForward(currentTime);
			elsif 
				(btn_2>0 or btn_3>0 or btn_7>0 ) and
				(currentTime-btntime>keydwell)
			then --pick/drop
				pickOrDrop;
				btntime:=currenttime;
			end if;
		end if;


	end if; --joystik or gamepad
----------- end game controller ---------------------------------

----////////////// end response to user inputs //////////////////////////


		currentTime := float(sdl_getticks)/1000.0;

		updateCamera;
		updateMVPs( currentTime, float(winwidth), float(winheight), true );

		foldtime:=currenttime; --forward dwell
		boldtime:=currenttime; --backward dwell
		oldTimeKb := currentTime; --Keyboard dwell





--------- begin drawing =================================================
		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);










	--tests for scene transitions;  if changing...reset
	--position (xme,yme,zme) to a reasonable entrance value

	-- current status per scene:
	--  1 = exterior
	--  2 = castle
	--  3 = defunct...removed

	--  4 = temple (ch1)
	--  5 = entry from exterior maze (chapter1)
	--  6 = exit to temple maze (chapter1)

	--  7 = entry from exterior, exit to labyrinth maze (ch2)
	--  8 = labyrinth (ch2)
	--  9 = maze9 (other side of lab)





		--exterior
		if scene=1 then

			-- economize if insides of castle are not visible
			if zme<-10.0 then -- inside visible
				oyme:=yme;
				yme:=yme+0.1; --need slight boost so floor looks correct

				updateMVPs( currentTime, float(winwidth), float(winheight) );
				draw_castle; --interior


				-- restore exterior coords
				yme:=oyme;
				updateMVPs( currentTime, float(winwidth), float(winheight) );
			end if;

			draw_exterior(chapter);


			-- threshold castle/exterior:
			-- (ixdoor,izdoor)=(-5.0,-10.0)
			-- ( xdoor, zdoor)=(-5.0,-10.0)
			if 
				atThreshold(currenttime, "2e", 1) --2e
			then
				nuscene:=2;
				xme:=ixdoor; 
				zme:=izdoor+ddoor+0.01;
				yme:=aheight;

			-- threshold exterior1/maze5or7
			elsif 
				atThreshold(currenttime, "1x", 1) --1x
				and mazeopen
				and not mazewait
			then
				if chapter=1 then	nuscene:=5;
				elsif chapter=2 then nuscene:=7; end if;
				xme:=ixmaze;
				zme:=izmaze+dmaze+0.01;
				yme:=-iymax+aheight;
			end if;



		--castle interior
		elsif scene=2 then

			--in case we can see outside:
			draw_exterior(chapter); --here, yme is close enough

			draw_castle; --interior

			drawspider(currenttime);


		-- threshold castle/exterior:
		-- (ixdoor,izdoor)=(-5.0,-10.0)
		-- ( xdoor, zdoor)=(-5.0,-10.0)
			if
				atThreshold(currenttime, "2x", 2) --2x
			then
				nuscene:=1;
				xme:=xdoor;
				zme:=zdoor-ddoor-0.01;
				yme:=aheight+land_alt(xme,zme);
			end if;




		--greek temple
		elsif scene=4 then --assuming see-thru to scene#6

			--in case we can see maze outside temple:
			zme:=zme+20.0;
			zcam:=zcam+20.0;
			updateMVPs( currentTime, float(winwidth), float(winheight) );
			draw_maze6;

			zme:=zme-20.0;	 --restore to present value
			zcam:=zcam-20.0;
			updateMVPs( currentTime, float(winwidth), float(winheight) );

			draw_temple;

			if
				atThreshold(currenttime, "4x", 4) --4x
			then
				nuscene:=6;
				xme:=xtmpl; -- 0
				zme:=ztmpl-dtmpl-0.01; --  ~= +10
				yme:=-iymax+aheight;
			end if;




		--maze part1
		elsif scene=5 then --connected with itself, scene #6, #1=exterior

		-- See scene5.txt, scene6.txt for definitions of
		-- all the inter-connections:
		-- { a,b,c,d,e,f,g,y,z,v,w,x, a1,a2,b1,b2, 
		--   c6,d6,e6,f6,g6,v6,w6,x6,y6,z6 }

			draw_maze5;


-- now, check for imminent transitions...

			--(+10,+9) -> #6 @(-10,+9)
			if atThreshold(currenttime,"5c",5) then --5c
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,+4) -> #6 @(-10,+4)
			elsif atThreshold(currenttime,"5d",5) then --5d
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,+2) -> #6 @(-10,+2)
			elsif atThreshold(currenttime,"5e",5) then --5e
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,+0) -> #6 @(-10,+0)
			elsif atThreshold(currenttime,"5f",5) then --5f
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,-2) -> #6 @(-10,-2)
			elsif atThreshold(currenttime,"5g",5) then --5g
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(-10,+2) -> #6 @(+10,+2)
			elsif atThreshold(currenttime,"5v",5) then --5v
					xme:=xme+20.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,+0) -> #6 @(+10,+0)
			elsif atThreshold(currenttime,"5w",5) then --5w
					xme:=xme+20.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,-2) -> #6 @(+10,-2)
			elsif atThreshold(currenttime,"5x",5) then --5x
					xme:=xme+20.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,+9) -> #6 @(+10,-4)
			elsif atThreshold(currenttime,"5y",5) then --5y
					xme:=xme+20.0;
					zme:=zme-13.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,+4) -> #6 @(+10,-9)
			elsif atThreshold(currenttime,"5z",5) then --5z
					xme:=xme+20.0;
					zme:=zme-13.0;
					nuscene:=6;
					xme:=xme-step;



			elsif
				atThreshold(currenttime, "5ex", 5)
			then
				nuscene:=1;
				xme:=xmaze; -- new single doorway
				zme:=zmaze-dmaze-0.01;
				yme:=aheight+land_alt(xme,zme);
			end if;







		--maze part2
		elsif scene=6 then --connected with itself & scene #5, #4=temple

			zme:=zme-20.0; --temple coords
			zcam:=zcam-20.0;
			updateMVPs( currentTime, float(winwidth), float(winheight) );
			draw_temple; --scene #4
			zme:=zme+20.0; --restore to present value
			zcam:=zcam+20.0;
			updateMVPs( currentTime, float(winwidth), float(winheight) );
	
			draw_maze6;


-- now, check for imminent transitions:


			if atThreshold(currenttime,"6z",6) then --6z

			--(+10,-9) -> #5 @(-10,+4)
				xme:=xme-20.0;
				zme:=zme+13.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atThreshold(currenttime,"6y",6) then --6y

			--(+10,-4) -> #5 @(-10,+9)
				xme:=xme-20.0;
				zme:=zme+13.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atThreshold(currenttime,"6x",6) then --6x

			--(+10,-2) -> #5 @(-10,-2)
				xme:=xme-20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atThreshold(currenttime,"6w",6) then --6w

			--(+10,+0) -> #5 @(-10,+0)
				xme:=xme-20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atThreshold(currenttime,"6v",6) then --6v

			--(+10,+2) -> #5 @(-10,+2)
				xme:=xme-20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atThreshold(currenttime,"6g",6) then --6g

			--(-10,-2) -> #5 @(+10,-2)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atThreshold(currenttime,"6f",6) then --6f

			--(-10,0)  -> #5 @(+10,+0)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme+margin;

			elsif atThreshold(currenttime,"6e",6) then --6e

			--(-10,+2) -> #5 @(+10,+2)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atThreshold(currenttime,"6d",6) then --6d

			--(-10,+4) -> #5 @(+10,+4)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atThreshold(currenttime,"6c",6) then --6c

			--(-10,+9) -> #5 @(+10,+9)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atThreshold(currenttime,"6br",6) then --6br

			--(-10,-9) -> (+10,+4)
				xme:=xme+20.0;
				zme:=zme+13.0;
				nuscene:=6;
				xme:=xme-step;
				reenter:=true;

			elsif atThreshold(currenttime,"6bl",6) then --6bl

			--(+10,+4) -> (-10,-9)
				xme:=xme-20.0;
				zme:=zme-13.0;
				nuscene:=6;
				xme:=xme+step;
				reenter:=true;

			elsif atThreshold(currenttime,"6ar",6) then --6ar

			--(-10,-4)
				xme:=xme+20.0;
				zme:=zme+13.0;
				nuscene:=6;
				xme:=xme-step;
				reenter:=true;

			elsif atThreshold(currenttime,"6al",6) then --6al

			--(+10,+9)
				xme:=xme-20.0;
				zme:=zme-13.0;
				nuscene:=6;
				xme:=xme+step;
				reenter:=true;



			elsif 
				atThreshold(currenttime, "6ex", 6) --6ex(4e)
				and lionopen and not lionwait
			then
				nuscene:=4;
				xme:=ixtmpl; -- 0
				zme:=iztmpl+dtmpl+0.01; --  ~= -10
				yme:=-iymax+aheight;


			end if;





		elsif scene=7 then --connected with itself, scene #1, #8=labyrinth

			draw_maze7;

-- 1st, check for imminent transitions within scene7:

			if atThreshold(currenttime,"7ar",7) then --7ar
				xme:=-10.0+step;
				zme:=-9.0;
				nuscene:=7;
				reenter:=true;

			elsif atThreshold(currenttime,"7al",7) then --7al
				xme:=+10.0-step;
				zme:=-2.0;
				nuscene:=7;
				reenter:=true;


			elsif atThreshold(currenttime,"7br",7) then --7br
				xme:=-10.0+step;
				zme:=-7.0;
				nuscene:=7;
				reenter:=true;

			elsif atThreshold(currenttime,"7bl",7) then --7bl
				xme:=+10.0-step;
				zme:=0.0;
				nuscene:=7;
				reenter:=true;



			elsif atThreshold(currenttime,"7cr",7) then --7cr
				xme:=-10.0+step;
				zme:=-4.0;
				nuscene:=7;
				reenter:=true;

			elsif atThreshold(currenttime,"7cl",7) then --7cl
				xme:=+10.0-step;
				zme:=+3.0;
				nuscene:=7;
				reenter:=true;





			elsif atThreshold(currenttime,"7dr",7) then --7dr
				xme:=-10.0+step;
				zme:=-2.0;
				nuscene:=7;
				reenter:=true;

			elsif atThreshold(currenttime,"7dl",7) then --7dl
				xme:=+10.0-step;
				zme:=-9.0;
				nuscene:=7;
				reenter:=true;




			elsif atThreshold(currenttime,"7er",7) then --7er
				xme:=-10.0+step;
				zme:=-0.0;
				nuscene:=7;
				reenter:=true;

			elsif atThreshold(currenttime,"7el",7) then --7el
				xme:=+10.0-step;
				zme:=-7.0;
				nuscene:=7;
				reenter:=true;




			elsif atThreshold(currenttime,"7fr",7) then --7fr
				xme:=-10.0+step;
				zme:=+3.0;
				nuscene:=7;
				reenter:=true;

			elsif atThreshold(currenttime,"7fl",7) then --7fl
				xme:=+10.0-step;
				zme:=-4.0;
				nuscene:=7;
				reenter:=true;



-- check for scene8 transition:
			elsif atThreshold(currenttime,"7h",7) then --7h
				xme:=-10.0+step;
				nuscene:=8;



-- check for scene1 transition:
			elsif
				atThreshold(currenttime, "7ex", 7) --7ex(1e)
			then
				nuscene:=1;
				xme:=xmaze; -- new single doorway
				zme:=zmaze-dmaze-0.01;
				yme:=aheight+land_alt(xme,zme);
			end if;




		elsif scene=8 then --connected to scene7, scene9

			draw_lab8;

-- check for scene9 transition:
			if atThreshold(currenttime,"8g",8) then --8g
				nuscene:=9;
				-- shall do about-face!

-- check for scene7 transition:
			elsif atThreshold(currenttime,"8h",8) then --8h
				xme:=+10.0-step;
				nuscene:=7;




			end if;

------------- addendum 29oct16 end ----------------------------------------

		elsif scene=9 then
			draw_maze9;


-- check for scene8 transition:
			if atThreshold(currenttime,"9x",9) then --98=9x
				nuscene:=8;
				-- shall be doing an about-face!


			--(-1,-10) -> (+9,+10)
			elsif atThreshold(currenttime,"9al",9) then --9al

					xme:=xme+10.0;
					zme:=zme+20.0;
					nuscene:=9;
					zme:=zme-step;
					reenter:=true;

			--(+9,+10) -> (-1,-10)
			elsif atThreshold(currenttime,"9ar",9) then --9ar

					xme:=xme-10.0;
					zme:=zme-20.0;
					nuscene:=9;
					zme:=zme+step;
					reenter:=true;


			--(-5,-10) -> (+5,+10)
			elsif atThreshold(currenttime,"9bl",9) then --9bl

					xme:=xme+10.0;
					zme:=zme+20.0;
					nuscene:=9;
					zme:=zme-step;
					reenter:=true;

			--(+5,+10) -> (-5,-10)
			elsif atThreshold(currenttime,"9br",9) then --9br

					xme:=xme-10.0;
					zme:=zme-20.0;
					nuscene:=9;
					zme:=zme+step;
					reenter:=true;



			--(+4,-10) -> (-6,+10)
			elsif atThreshold(currenttime,"9cl",9) then --9cl

					xme:=xme-10.0;
					zme:=zme+20.0;
					nuscene:=9;
					zme:=zme-step;
					reenter:=true;

			--(-6,+10) -> (+4,-10)
			elsif atThreshold(currenttime,"9cr",9) then --9cr

					xme:=xme+10.0;
					zme:=zme-20.0;
					nuscene:=9;
					zme:=zme+step;
					reenter:=true;




			--(-8,-10) -> (+2,+10)
			elsif atThreshold(currenttime,"9fl",9) then --9fl

					xme:=xme+10.0;
					zme:=zme+20.0;
					nuscene:=9;
					zme:=zme-step;
					reenter:=true;

			--(+2,+10) -> (-8,-10)
			elsif atThreshold(currenttime,"9fr",9) then --9fr

					xme:=xme-10.0;
					zme:=zme-20.0;
					nuscene:=9;
					zme:=zme+step;
					reenter:=true;

-----------------------------------------------------



			--(-10,-8) -> (+10,-8)
			elsif atThreshold(currenttime,"9dt",9) then --9dt

					xme:=xme+20.0;
					nuscene:=9;
					xme:=xme-step;
					reenter:=true;

			--(+10,-8) -> (-10,-8)
			elsif atThreshold(currenttime,"9db",9) then --9db

					xme:=xme-20.0;
					nuscene:=9;
					xme:=xme+step;
					reenter:=true;




			--(-10,-1) -> (+10,-1)
			elsif atThreshold(currenttime,"9et",9) then --9et

					xme:=xme+20.0;
					nuscene:=9;
					xme:=xme-step;
					reenter:=true;

			--(+10,-1) -> (-10,-1)
			elsif atThreshold(currenttime,"9eb",9) then --9eb

					xme:=xme-20.0;
					nuscene:=9;
					xme:=xme+step;
					reenter:=true;



			end if;



		end if; -- scene=9




-------------------------------------------------------------------------

--bat moved to draw_exterior & draw_maze5

------------- begin draw dragons ----------------------------------------





		if bdragonfly and (scene=1 or scene=2) then --draw dragon
			dt:=(currenttime-dragonstart)/dragonduration; -- 0..1
			if dt>=1.0 then
				bdragonfly:=false;
				bsdra:=scene;
				bxdra:=xme;
				bzdra:=zme;
				if interior then --scene=2
					bydra:=2.0*htobj;
				else
					bydra:=2.0*htobj+land_alt(bxdra,bzdra);
				end if;
				pictobj.setrect( 
					bdragon, 
					bxdra,bydra,bzdra,
					0.6, 0.0, 0.6, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

				snd4ada_hpp.playSnd(roar); --Roar (in either case) 11sep16
				delay 0.8; -- give time to play roar

				if swordheld then --dragon dies
					bdragondead:=true;
					snd4ada_hpp.playSnd(die); -- dragondie.wav
					delay 0.8;
				else --dragon eats you...
					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_dragon:=true;
				end if;
				
			else
				drawbdragon(dt);
			end if;
		end if; --bdragonfly





		-- draw RED dragon
		if rdragonfly and (scene=5 or scene=1 or scene=6 or scene=7) then
			dt:=(currenttime-dragonstart)/dragonduration; -- 0..1

			if dt>=2.0 and runAway then
				rdragonfly:=false;
				runAway:=false;
				roarbegun:=false;

			elsif dt>=1.0 and runAway then
				if swordheld then
					drawrdragon(2.0-dt); --retreat

					-- would prefer a diminshing retreat roar
					if not roarbegun then
						snd4ada_hpp.playSnd(roar); --Roar but retreat
						roarbegun:=true;
					end if;
					--delay 0.8; -- give time to play roar


				else --dragon eats you...
					rdragonfly:=false;

					snd4ada_hpp.playSnd(roar); --Roar
					delay 0.8; -- give time to play roar

					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_dragon:=true;
				end if;

			elsif dt>=1.0 then
				rdragonfly:=false;
				rsdra:=scene;
				rxdra:=xme;
				rzdra:=zme;
				if interior then
					rydra:=-iymax+2.0*htobj;
				else
					rydra:=land_alt(rxdra,rzdra)+2.0*htobj;
				end if;
				pictobj.setrect( 
					rdragon, 
					rxdra,rydra,rzdra,
					0.6, 0.0, 0.6, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

				snd4ada_hpp.playSnd(roar); --Roar (in either case) 11sep16
				delay 0.8; -- give time to play roar

				if swordheld then --dragon dies
					rdragondead:=true;
					snd4ada_hpp.playSnd(die); -- dragondie.wav
					delay 0.8;
				else --dragon eats you...
					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_dragon:=true;
				end if;
				
			else -- 0<dt<1
				drawrdragon(dt);
			end if;
		end if; --rdragonfly




		if minofly and scene=8 then
			dt:=(currenttime-dragonstart)/(0.5*dragonduration); -- 0..1
			if dt>=1.0 then
				minofly:=false;
				mxdra:=xme;
				mzdra:=zme;
				mydra:=-iymax+2.0*htobj;
				pictobj.setrect( minotaur,
					mxdra,mydra,mzdra,
					0.6, 0.0, 0.6, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

				snd4ada_hpp.stopLoop(ceph8);
				snd4ada_hpp.playSnd(roar); --Roar (in either case) 11sep16
				delay 0.8; -- give time to play roar

				if swordheld then --minotaur dies
					minotaurdead:=true;
					snd4ada_hpp.playSnd(die); -- dragondie.wav
					delay 0.8;
				else --minotaur eats you...
					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_minotaur:=true;
				end if;
				
			else
				drawMinotaur(dt);
			end if;
		end if; --minofly

		if scene=8 and minotaurdead then
			glUseProgram( pidtex05 );
			gluniformmatrix4fv( mvpid05, 1, gl_false, imvp(1,1)'address );
			gluniform1i(sampid05,0);
			glUniform1i(darkid05, darkness8);
			gluniform1i(flevid05, foglev8 ); 
			gluniform1i(fcolid05, fogclr8 ); 
			glbindtexture(gl_texture_2d, deadminotaur_texid);
			pictobj.draw(minotaur, vertbuff,uvbuff,elembuff);
		end if;








		if scene=rsdra and rdragondead then

			if not interior then
				glUseProgram(pidterra02);
				glUniformMatrix4fv(mvpid02, 1, GL_FALSE, imvp(1,1)'address);

				if thirdperson then
				glUniform3f(eyeid02,glfloat(xcam),glfloat(ycam),glfloat(zcam));
				else
				glUniform3f(eyeid02,glfloat(xme),glfloat(yme),glfloat(zme));
				end if;

				glUniform1i(flevid02, 0); --extfoglev);
				glUniform1i(sampid02, 0);
				glUniform1i(darkid02, 0); --extdarkness);

				glbindtexture(gl_texture_2d, deadrdragon_texid);
				pictobj.draw(rdragon, vertbuff,uvbuff,elembuff);
			else
				glUseProgram( pidtex05 );
				gluniformmatrix4fv( mvpid05, 1, gl_false, imvp(1,1)'address );
				gluniform1i(sampid05,0);
				glUniform1i(darkid05,0); -- darkness);
				gluniform1i(flevid05, 0 ); 
				-- 1=>normal, 2=>heavy, 3=>extreme fog
				gluniform1i(fcolid05, 1 ); 
				-- 1=>gray, 2=>brown, 3=>purple fog

				glbindtexture(gl_texture_2d, deadrdragon_texid);
				pictobj.draw(rdragon, vertbuff,uvbuff,elembuff);
			end if;

		end if;

--Always draw dragons with no fog ========================================

		if scene=bsdra and bdragondead then

			if not interior then
				glUseProgram(pidterra02);

				if thirdperson then
				glUniform3f(eyeid02,glfloat(xcam),glfloat(ycam),glfloat(zcam));
				else
				glUniform3f(eyeid02,glfloat(xme),glfloat(yme),glfloat(zme));
				end if;


				glUniform1i(flevid02, 0); --extfoglev);
				glUniformMatrix4fv(mvpid02, 1, GL_FALSE, imvp(1,1)'address);
				glUniform1i(sampid02, 0);
				glUniform1i(darkid02,0); -- darkness);

				glbindtexture(gl_texture_2d, deadbdragon_texid);
				pictobj.draw(bdragon, vertbuff,uvbuff,elembuff);
			else

				glUseProgram( pidtex05 );
				gluniformmatrix4fv( mvpid05, 1, gl_false, imvp(1,1)'address );
				gluniform1i(sampid05,0);
				glUniform1i(darkid05,0); -- darkness);
				gluniform1i(flevid05, 0 ); 
				-- 1=>normal, 2=>heavy, 3=>extreme fog
				gluniform1i(fcolid05, 1 ); 
				-- 1=>gray, 2=>brown, 3=>purple fog

				glbindtexture(gl_texture_2d, deadbdragon_texid);
				pictobj.draw(bdragon, vertbuff,uvbuff,elembuff);
			end if;

		end if;


------------- end draw dragons ----------------------------------------




----------------------- avatar begin ------------------------------------

		if thirdPerson then 
			currentTime := float(sdl_getticks)/1000.0;
			-- moved here 3apr17 to assure fresh, accurate
			-- (xme,yme,zme) & (xcam,ycam,zcam) positions
			-- and perhaps avoid avatar jitter.
			drawAvatar(currenttime);
		end if;

-------------------------------------------------------------------------


		if snakehiss then
			if not hissbeat then
				hissbeat:=true;
				snd4ada_hpp.playLoop(hiss);
			end if;
		elsif hissbeat then
			hissbeat:=false;
			snd4ada_hpp.stopLoop(hiss);
		end if;



		if nearsnake then
			ftex.print2d("TOO CLOSE...",
				0.3,0.80, 0.8, fontcol );
			ftex.print2d("that mamba is deadly.",
				0.2,0.70, 0.8, fontcol );

			if warning1 and ((currenttime-warningtime)>warningpause) then

				-- here we should roll the dice...even if you are holding
				-- a sword, 1 out of 3 times you still die...

				if not swordheld then -- 20nov17 addendum
					userexit:=true;
					imdead_snake:=true;

				elsif snakeVSsword<2 then
					-- we COULD kill the snake here
					-- but it's more fun if we keep it...
					ftex.print2d("your SWORD keeps him at bay!",
						0.2,0.60, 0.7, fontcol );
					snakeVSsword:=snakeVSsword+1;
					warningtime := currenttime;

				else -- you die anyway
					userexit:=true;
					imdead_snake:=true;

				end if;

				if imdead_snake then --15dec17
					snd4ada_hpp.playSnd(scream); -- bitten!!!
					delay 3.0;
				end if;

			else
				warning1:=true;
				warningtime := currenttime;
			end if;
		end if;



		if intro then
			sz:=1.0;
			if chapter=1 then
				ftex.print2d("AdaVenture is a point & click quest set in", 0.02,0.90, sz,fontcol);
				ftex.print2d("ancient Persia.  The golden chalice of Xerxes",0.02,0.85, sz,fontcol);
				ftex.print2d("has been stolen by Leonidas the Spartan King.",0.02,0.80, sz,fontcol);
				ftex.print2d("Find & return the golden chalice",0.02,0.75, sz,fontcol);
				ftex.print2d("to its pedestal within the castle.",0.02,0.70, sz,fontcol);
				ftex.print2d("Use the sword to kill deadly beasts,",0.02,0.65, sz,fontcol);
				ftex.print2d("click to grab/drop objects as needed.",0.02,0.60, sz,fontcol);
				ftex.print2d("The [i]-key toggles this Introduction",0.02,0.55, sz,fontcol);
				ftex.print2d("The [m]-key toggles the Avatar",0.02,0.50, sz,fontcol);
				ftex.print2d("The [l]-key toggles LazyCamera",0.02,0.45, sz,fontcol);
			elsif chapter=2 then
				ftex.print2d("AdaVenture is a point & click quest set in",0.02,0.90, sz,fontcol);
				ftex.print2d("ancient Persia.  The golden chalice of Xerxes",0.02,0.85, sz,fontcol);
				ftex.print2d("has been stolen by Minos the Cretan King.",0.02,0.80, sz,fontcol);
				ftex.print2d("Find & return the golden chalice",0.02,0.75, sz,fontcol);
				ftex.print2d("to its pedestal within the castle.",0.02,0.70, sz,fontcol);
				ftex.print2d("Use the sword to kill deadly beasts,",0.02,0.65, sz,fontcol);
				ftex.print2d("click to grab/drop objects as needed.",0.02,0.60, sz,fontcol);
				ftex.print2d("The [i]-key toggles this Introduction",0.02,0.55, sz,fontcol);
				ftex.print2d("The [m]-key toggles the Avatar",0.02,0.50, sz,fontcol);
				ftex.print2d("The [l]-key toggles LazyCamera",0.02,0.45, sz,fontcol);
			end if;
		end if; --intro

		if success and (currentTime-winnertime<15.0) then --show for 15 seconds

			sz:=1.2;
			ftex.print2d("You have restored the Golden Chalice",0.02,0.90,      sz,fontcol);
			ftex.print2d("of Xerxes.  Praise be upon you.",0.02,0.80,           sz,fontcol);
			ftex.print2d("Now, we shall celebrate into the night...",0.02,0.70, sz,fontcol);
			ftex.print2d("...or until you hit the [esc]-key.",0.02,0.60,        sz,fontcol);

		end if;



		sdl_gl_swapwindow( mainWindow );

		if success and not heralded then
			winnertime:=currentTime;
			heralded:=true;
			delay 0.3; --allow putdown sound to complete


			snd4ada_hpp.playSnd(won); --adventure-win-sound
			delay 5.0; --allow win-sound to complete


			if chapter=1 then snd4ada_hpp.playLoop(misr); --Misr;
			elsif chapter=2 then snd4ada_hpp.playLoop(turk); --Turk; 
			end if;
		end if;


		if imdead_fireball then
			userexit:=true;
			snd4ada_hpp.playSnd(scream); -- charred & crushed!!!
			delay 3.0;
			ftex.print2d("You are burnt to a crisp!", 0.1, 0.5, 1.5,fontcol);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		elsif imdead_minotaur then
			ftex.print2d("The Minotaur Ate You.", 0.3, 0.5, 1.5,fontcol);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		elsif imdead_dragon then
			ftex.print2d("The Dragon Ate You.", 0.3, 0.5, 1.5,fontcol);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		elsif imdead_snake then
			ftex.print2d("The Mamba Bit You.", 0.1, 0.5, 1.5,fontcol);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		end if;



		--output errors and raise exception here only if dbug
		if dbug then
			if dumpGLerrorQueue("AV main loop end")>0 then
				raise avent_main_error;
			end if;
		end if;




---------------------------------------------------------------------------
   end loop; ---------------------- main event loop end -------------------
---------------------------------------------------------------------------


	ftex.CloseFont;

	utex.cleanuptext;

	snd4ada_hpp.termSnds; -- stops any loops;  then deallocates

	release_textures;


	if joystik or gamepad then
		SDL_JoystickClose(jsa);
	end if;

	SDL_GL_DeleteContext(mainGLContext);
	SDL_DestroyWindow(mainWindow);

	SDL_Quit;


end aventure;

end avent;

