
--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_lab8 is

	hwdoor : constant float := 0.8;
	fhdoor : constant float := 1.8;

	foglev : constant glint := 2;
		-- 1=>normal, 2=>heavy, 3=>extreme fog

	fogclr : constant glint := 3;
		-- 1=>gray, 2=>brown, 3=>purple fog

	xtc,ytc,ztc, xtr,ytr,ztr, yb : glfloat;

begin

	snake8rad := 7.0;

	snake8angl := 0.02*onepi*currenttime;

	-- given my coords, this defines a clockwise rotation:
	x8snake:= snake8rad*fmath.cos(snake8angl);
	z8snake:= snake8rad*fmath.sin(snake8angl);


		-- green mamba
		glUseProgram( snaketexshadid );
		gluniformmatrix4fv(snakemvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv(snakeMatrixID, 1, gl_false, imvp(1,1)'address );
		gluniform1i(snakeuniftex,0);
		glUniform3f(snakecenID, 0.0, glfloat( -iymax+0.02 ), 0.0 );
		glUniform1f(snakeunifrad, glfloat(snake8rad)); --circle radius
		glUniform1f(snakeunifangl, glfloat(snake8angl)); --angle around orbit
		glUniform1f(snakeunifwvel, 1.0 ); --wiggle freq
		glUniform1f(snakeunifwamp, 4.0 ); --wiggle amplitude

		glUniform1i(snakeunifdark, darkness);
		gluniform1i(snakeuniflev, foglev ); 
		gluniform1i(snakeunifclr, fogclr ); 

		glbindtexture(gl_texture_2d, snake_texid);
		longtube.draw( snake, vertbuff,uvbuff,elembuff );






		--for normal textured objects:
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness);

		gluniform1i(uniflev, foglev ); 
		gluniform1i(unifclr, fogclr ); 

		glbindtexture(gl_texture_2d, roots_texid);
		--glbindtexture(gl_texture_2d, slime_texid); -- nice slime!
		droomobj.draw(mdo8,vertbuff,uvbuff,elembuff); --textured room


		--floor
		glbindtexture(gl_texture_2d, slime_texid);
		rectobj.draw(lfloor, vertbuff,uvbuff,elembuff);

		--doors
		glbindtexture(gl_texture_2d, doort_texid);
		pictobj.draw(g8, vertbuff,uvbuff,elembuff);
		pictobj.draw(h8, vertbuff,uvbuff,elembuff);

		--exit
		glbindtexture(gl_texture_2d, exit_texid);
		pictobj.draw(eg8, vertbuff,uvbuff,elembuff);
		pictobj.draw(eh8, vertbuff,uvbuff,elembuff);





		--labyrinth walls
		glbindtexture(gl_texture_2d, slime_texid); -- nice slime!
		for row in -mrows..mrows loop
		for col in -mcols..mcols loop
		if iswall(8,row,col) then
			rectobj.draw(
				mzwall(8,row,col), 
					vertbuff,uvbuff,elembuff);
		end if;
		end loop;
		end loop;






		if not gkeyheld and sgkey=8  then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=8 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=8 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=8 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;













---------------------------------------------------------------
-- addendum draw tree begin

xtc:=0.0;
ztc:=0.0;

xtr:=2.0;
ytr:=2.0;
ztr:=xtr;

ytc:=glfloat(-iymax) + ytr - 0.5;

yb := glfloat(-iymax); -- ytc-ytr;


--draw tree
for k in 1..2 loop
	if k=1 then
		gldepthmask(gl_false);
	end if;

		glUseProgram(treeTexShadID);
		glUniformMatrix4fv(treeMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(treeuniftex, 0);
		glUniform1i(treeunifdark, darkness);
		glUniform1f(treeuniftime, glfloat(currentTime) ); 
		--shader makes them sway

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

			----------------------------------------------------
			glUniform3f(treecenid, xtc,ytc,ztc );
			glUniform3f(treeradid, xtr,ytr,ztr );
			glUniform1f( treebaseunifid, yb );

			glUniform1i(treeunifid, glint(1) );
			glBindTexture(GL_TEXTURE_2D, tree8_texid);
			xtreeobj.Draw( tree, vertbuff,uvbuff,elembuff);

			----------------------------------------------------

	if k=1 then
		gldepthmask(gl_true);
	end if;
end loop; --tree




---------------------------------------------------------------

	if drawchalice and schalice=8 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);

		gluniform1i(cupFlag, 0 ); --no light effects

		glUniform1f(cupunifang, 0.0);

		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		glUniform1i(cupunifdark, darkness);
		glUniform3f(cupcenid, xchalice,ychalice,zchalice );
		glUniform3f(cupradid, wcup, hcup, wcup );

		gluniform1i(cupuniflev, foglev ); 
		gluniform1i(cupunifclr, fogclr ); 

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);

		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.draw(chalice, vertbuff,uvbuff,elembuff);

	end if;


---------------------------------------------------------------


	if scene=8 then

		showingGlyph:=false;

		-- glyphs drawn @ screen center
		if gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" => green key
			showingGlyph:=true;

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" => black key
			showingGlyph:=true;

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" => white key
			showingGlyph:=true;

		elsif swordheld then --draw sword
			utex.print2d("=",0.5,0.5,120); -- "=" => sword
			showingGlyph:=true;

		elsif chaliceheld then --draw chalice
			utex.print2d(";",0.5,0.5,80); -- ";" => chalice
			showingGlyph:=true;
		end if;

		if 
			(gkeynear or bkeynear or wkeynear or swordnear or chalicenear)
			and not gatewait and not lionwait and not mazewait
		then
			utex.print2d("`",0.5,0.4,50); -- "`" = hand
			showingHand:=true;
		else
			showingHand:=false;
		end if;

	end if;


		-- fancy fragshader draws cloud ceiling
		--glUseProgram( sky2shadid );
		--gluniformmatrix4fv( sky2matid, 1, gl_false, imvp(1,1)'address );
		--gluniform1f(sky2timeid, glfloat(currentTime) );
		--gluniform2f(sky2resid, glfloat(winwidth), glfloat(winheight) );
		--rectxobj.draw(rox,vertbuff,elembuff);

		-- fancy fragshader draws B&W cloud ceiling
		glUseProgram( star2shadid );
		gluniformmatrix4fv( star2matid, 1, gl_false, imvp(1,1)'address );
		gluniform1f(star2timeid, glfloat(currentTime) );
		gluniform2f(star2resid, glfloat(winwidth), glfloat(winheight) );
		rectxobj.draw(rox,vertbuff,elembuff);


end draw_lab8;


