--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;


----------------------------------------------------------------
with sdl;  use sdl;
----------------------------------------------------------------

with matutils;
with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;

----------------------------------------------------------------


with shader;  use shader;

with cubemapobj;
with droomobj;
with xtreeobj;
with rectobj;
with rectxobj;
with avatarobj;
with pictobj;
with twictobj;
with cylobj;

with holesurfobj;


with text_io;
with pngloader;
with gametypes;
with gameutils;
with matutils;

with ada.calendar;

with snd4ada_hpp;


package body avent is


	use text_io;
	use pngloader;
	use gametypes;
	use gameutils;
	use matutils;
	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;


	nerr: integer;


-- this new surface allows a building to extend below it...
-- 20X20 X-Z grid per quadrant => 40X40, 
-- with square hole @ (-5,-5) of radius 5:
--package terrain is new holesurfobj(20,20,land_alt,-5.0,-5.0,5.0,5.0);

-- experiment to fix jitter on Gateway (still looks fine):
-- this new surface allows a building to extend below it...
-- 10X10 X-Z grid per quadrant => 20X20, 
-- with square hole @ (-5,-5) of radius 5:
package terrain is new holesurfobj(10,10,land_alt,-5.0,-5.0,5.0,5.0);
grounds : terrain.holesurf;





procedure setup_lab8 is separate;
procedure draw_lab8 is separate;

procedure setup_maze7 is separate;
procedure draw_maze7 is separate;

procedure setup_maze5 is separate;
procedure setup_maze6 is separate;
procedure draw_maze5 is separate;
procedure draw_maze6 is separate;

procedure setup_exterior(chapter: integer) is separate;
procedure draw_exterior(chapter: integer) is separate;

procedure setup_castle is separate;
procedure draw_castle is separate;


procedure setup_temple is separate;
procedure draw_temple is separate;














procedure aventure( chapter: integer ) is








procedure release_textures is -- prepare to close down
begin

	glext.binding.glDeleteBuffers(1, vertbuff'address);
	glext.binding.glDeleteBuffers(1, normbuff'address);
	glext.binding.glDeleteBuffers(1, rgbbuff'address);
	glext.binding.glDeleteBuffers(1, uvbuff'address);
	glext.binding.glDeleteBuffers(1, elembuff'address);
	glext.binding.glDeleteVertexArrays(1, vertexarrayid'address);

	gldeletetextures(1, keyhole_texid'address);
	gldeletetextures(1, ava_texid'address);
	gldeletetextures(1, gkey_texid'address);
	gldeletetextures(1, bkey_texid'address);
	gldeletetextures(1, key_texid'address);
	gldeletetextures(1, greekey_texid'address);
	gldeletetextures(1, sword_texid'address);
	gldeletetextures(1, adobe_texid'address);
	gldeletetextures(1, cherry_texid'address);
	gldeletetextures(1, chalice_texid'address);

	gldeletetextures(1, bat1_texid'address);
	gldeletetextures(1, bat2_texid'address);

	gldeletetextures(1, deadbdragon_texid'address);
	gldeletetextures(1, deadrdragon_texid'address);
	--gldeletetextures(1, doorwood_texid'address);
	gldeletetextures(1, door_texid'address);
	gldeletetextures(1, doort_texid'address);
	gldeletetextures(1, doortw_texid'address);
	gldeletetextures(1, hedge_texid'address);

	gldeletetextures(1, ceil_texid'address);
	gldeletetextures(1, floor_texid'address);
	gldeletetextures(1, rug_texid'address);
	--gldeletetextures(1, temple_texid'address);
	--gldeletetextures(1, templet_texid'address);

	glext.binding.glDeleteProgram( pidskyb );
	glext.binding.glDeleteProgram( pidterra );

	gldeletetextures(1, sunnycubemap_texid'address);
	gldeletetextures(1, darkcubemap_texid'address);
	gldeletetextures(1, stone_texid'address);
	gldeletetextures(1, grass_texid'address);
	gldeletetextures(1, grass1_texid'address);
	gldeletetextures(1, gate_texid'address);
	gldeletetextures(1, zoro_texid'address);
	gldeletetextures(1, hall_texid'address);
	gldeletetextures(1, wood_texid'address);
	gldeletetextures(1, room_texid'address);
	gldeletetextures(1, mural_texid'address);
	--gldeletetextures(1, mazewall_texid'address);
	gldeletetextures(1, mazeouter_texid'address);
	gldeletetextures(1, moorwall_texid'address);
	gldeletetextures(1, gmarble_texid'address);
	--gldeletetextures(1, pmarble_texid'address);

	gldeletetextures(1, stonedoor_texid'address);
	gldeletetextures(1, greenrockwall_texid'address);
	gldeletetextures(1, lion_texid'address);

	gldeletetextures(1, spalm_texid'address);
	gldeletetextures(1, tpalm_texid'address);

	gldeletetextures(1, tree1_texid'address);
	gldeletetextures(1, tree2_texid'address);
	gldeletetextures(1, tree3_texid'address);
	gldeletetextures(1, tree4_texid'address);
	gldeletetextures(1, tree5_texid'address);

	gldeletetextures(1, tree8_texid'address);

	gldeletetextures(1, intview_texid'address);


end release_textures;



procedure setup_textures is
begin 

--------- castle begin --------------------------------------------

	--dark clouds:
	darkcubemap_texid := loadCubePng(
	"data/skyBoxes/stormy/px.png",	"data/skyBoxes/stormy/nx.png",
	"data/skyBoxes/stormy/py.png",	"data/skyBoxes/stormy/ny.png",
	"data/skyBoxes/stormy/pz.png",	"data/skyBoxes/stormy/nz.png"	);

	--brighter, but still cloudy:
	cloudycubemap_texid := loadCubePng(
	"data/skyBoxes/clouds/bluft.png",	"data/skyBoxes/clouds/blubk.png",
	"data/skyBoxes/clouds/bluup.png",	"data/skyBoxes/clouds/bludn.png",
	"data/skyBoxes/clouds/blurt.png",	"data/skyBoxes/clouds/blulf.png"	);

	--sunny day:
	sunnycubemap_texid := loadCubePng(
	"data/skyBoxes/tropicalsun/slt.png","data/skyBoxes/tropicalsun/srt.png",
	"data/skyBoxes/tropicalsun/sup.png","data/skyBoxes/tropicalsun/sdn.png",
	"data/skyBoxes/tropicalsun/sfr.png","data/skyBoxes/tropicalsun/sbk.png");


	mooncubemap_texid := loadCubePng(
	"data/skyBoxes/moon/lf.png",	"data/skyBoxes/moon/rt.png",
	"data/skyBoxes/moon/up.png",	"data/skyBoxes/moon/dn.png",
	"data/skyBoxes/moon/fr.png",	"data/skyBoxes/moon/bk.png");



	pidSkyB := LoadShaders( "./data/osky.vs", "./data/osky.fs" );
	sbmvpUID := glGetUniformLocation( pidSkyB, pmvp );     
	sbmapUID := glGetUniformLocation( pidSkyB, pcubemap );     




	pidterra := 
		LoadShaders( "./data/yislandobj.vs", "./data/islandobj.fs" );
	mMatrixID := glGetUniformLocation( pidterra, pmvp );     
	muniftex := glGetUniformLocation( pidterra, pmyts );     
	munifdark := glGetUniformLocation( pidterra, pdark );     

	terrain.setrect(grounds, 0.0,0.0, xmax, zmax );

	grass1_texid := loadPng(pngloader.mirror,"data/grass1.png");
	--grass1_texid := loadPng(pngloader.mirror,"data/grass2hum.png");

	grass_texid := loadPng(pngloader.mirror,"data/grasss.png");
	-- note that loadPng uses mirrored_repeat texture wrapping

	-- Note that when (xme,zme) is near the edge of the domain,
	-- we don't want the far edge to get clipped by the skybox.
	cubemapobj.setrect( skybox, 0.0,0.0,0.0, xmax*2.0,ymax*2.0,zmax*2.0 );

	--stone_texid  := loadPng(mirror,"data/stonewall.png");
	stone_texid  := loadPng(mirror,"data/darkstonewall.png");
	gate_texid  := loadPng(mirror,"data/pbayGate.png");
	zoro_texid  := loadPng(mirror,"data/zoroaster2.png");
	gkey_texid  := loadPng(mirror,"data/gkey.png");
	bkey_texid  := loadPng(mirror,"data/bkey.png");
	key_texid  := loadPng(mirror,"data/wkey.png");
	sword_texid  := loadPng(mirror,"data/swordw.png");
	hall_texid  := loadPng(mirror,"data/hallgray2.png");
	wood_texid  := loadPng(mirror,"data/wood.png");

	greenrockwall_texid  := loadPng(mirror,"data/rockwall1.png");
	stonedoor_texid  := loadPng(mirror,"data/stonedoor.png");

	keyhole_texid  := loadPng(mirror,"data/keyhole.png");

	slime_texid  := loadPng(mirror,"data/slime.png");
	--moss_texid  := loadPng(mirror,"data/moss.png");
	roots_texid  := loadPng(mirror,"data/dry_roots.png");

	moorwall_texid  := loadPng(mirror,"data/moorishWall.png");
	gmarble_texid  := loadPng(mirror,"data/marblegray.png");
	bmarble_texid  := loadPng(mirror,"data/marblebrown.png");

	deadbdragon_texid  := loadPng(mirror,"data/dbd.png");
	deadrdragon_texid  := loadPng(mirror,"data/drd.png");
	deadminotaur_texid  := loadPng(mirror,"data/deadgnu.png");


	--doorwood_texid  := loadPng(mirror,"data/doorwood.png");
	door_texid  := loadPng(mirror,"data/door.png");
	doort_texid  := loadPng(mirror,"data/doort.png");
	doortw_texid  := loadPng(mirror,"data/doortw.png");
	hedge_texid  := loadPng(mirror,"data/hedge2Pbay.png");


	lion_texid  := loadPng(mirror,"data/lion.png");

	intview_texid  := loadPng(mirror,"data/intview3.png");

	korla_texid := loadPng(mirror,"data/pandit.png");

------------ chalice room begin -----------------------------------


	--very nice black&white clouds in a black sky (lightweight)
	star2shadid := loadshaders("./data/skyX.vs", "./data/bw2clouds.fs");
	star2timeid := glgetuniformlocation(star2shadid, ptime);
	star2resid  := glgetuniformlocation(star2shadid, presol);
	star2matid  := glgetuniformlocation(star2shadid, pmvp);





	pgmtexshadid := loadshaders("./data/texobjFog.vs", "./data/texobjFog.fs");
	mvid := glgetuniformlocation(pgmtexshadid, pmv); --MV
	matrixid := glgetuniformlocation(pgmtexshadid, pmvp); --MVP
	uniftex  := glgetuniformlocation(pgmtexshadid, pmyts); --myTextureSampler
	unifdark := glGetUniformLocation(pgmtexshadid, pdark );--darkness
	uniflev  := glgetuniformlocation(pgmtexshadid, pmylev);--level
	unifclr  := glgetuniformlocation(pgmtexshadid, pmyclr);--color


	-- lighting effects
	--pgmNorm := glGetUniformLocation( pgmTexShadID, pnormal );
	pgmFlag := glGetUniformLocation( pgmTexShadID, pflag );
	pgmcolr := glGetUniformLocation( pgmTexShadID, ppcolor );
	pgmpos1 := glGetUniformLocation( pgmTexShadID, ppos1 );
	pgmpos2 := glGetUniformLocation( pgmTexShadID, ppos2 );
	pgmpos3 := glGetUniformLocation( pgmTexShadID, ppos3 );



	mural_texid := loadPng(mirror,"data/mural.png");
	greekey_texid := loadPng(mirror,"data/greek.png");
	adobe_texid := loadPng(mirror,"data/darkadobe.png");
	cherry_texid := loadPng(mirror,"data/wood2_texture.png"); --cherry wood
	room_texid := loadPng(mirror,"data/darkstonewall.png"); 

	--mazewall_texid := loadPng(mirror,"data/roof2.png"); 
	--mazeouter_texid  := loadPng(mirror,"data/hedge3Pbay.png");
	mazeouter_texid  := loadPng(mirror,"data/hedge3tPbay.png");

	ceil_texid := loadPng(mirror,"data/mosqueceilSQ.png"); 
	floor_texid  := loadPng(mirror,"data/bricksE.png");
labWall_texid  := loadPng(mirror,"data/bricksC.png");
labMaze_texid  := loadPng(mirror,"data/midnight.png");
	rug_texid  := loadPng(mirror,"data/persiancarpetdark.png");
	chalice_texid  := loadPng(mirror,"data/chalice.png");

	--grunge_texid  := loadPng(mirror,"data/grungeRGBA.png");

	bat1_texid := loadPng(mirror,"data/bat0b.png");
	bat2_texid := loadPng(mirror,"data/bat1b.png");

	--cupTexShadID:=LoadShaders("./data/newtexobj.vs","./data/texobjFog.fs");
	cupTexShadID:=LoadShaders("./data/rotexobj.vs","./data/texobjFog.fs");
	cupMatrixID := glGetUniformLocation( cupTexShadID, pmvp );     
	cupuniftex := glGetUniformLocation( cupTexShadID, pmyts );     
	cupunifdark := glGetUniformLocation( cupTexShadID, pdark );     
	cupradID := glGetUniformLocation(cupTexShadID, pwrad); --// vec3
	cupcenid := glGetUniformLocation(cupTexShadID, pwpos); --// vec3

	cupuniflev  := glgetuniformlocation(cuptexshadid, pmylev);--level
	cupunifclr  := glgetuniformlocation(cuptexshadid, pmyclr);--color
	cupmvid := glgetuniformlocation(cuptexshadid, pmv); --MV

	cupunifang := glgetuniformlocation(cuptexshadid, phang); --horiAng

	cupFlag := glGetUniformLocation( cupTexShadID, pflag );







---- ava begin ----------------------------

	avaTexShadID:=LoadShaders("./data/avatarobj.vs","./data/avatarobj.fs");
	avaunifmat := glGetUniformLocation( avaTexShadID, pmvp );     
	avaunifcen := glGetUniformLocation(avaTexShadID, pwpos); --// vec3
	avaunifang := glgetuniformlocation(avatexshadid, phang); --horiAng
	avauniftime := glGetUniformLocation( avaTexShadID, pmytime );

	avaunifdir := glGetUniformLocation( avaTexShadID, pmydir );
	avaunifade := glGetUniformLocation( avaTexShadID, pmyfade );

	avauniftex := glGetUniformLocation( avaTexShadID, pmyts );

	--ava_texid := loadPng(mirror,"data/barbarian.png"); --good
	--ava_texid := loadPng(mirror,"data/leonidas.png"); --very good, much skin
	--ava_texid := loadPng(mirror,"data/francis.png"); --very good, dark clothes
	ava_texid := loadPng(mirror,"data/skin.png"); --very good, dark clothes



	avatarobj.setrect(ava);









--------- trees begin ---------------------------------------------

	spalm_texid := loadPng(mirror,"data/palm1.png");
	tpalm_texid := loadPng(mirror,"data/tallpalm1.png");

	tree1_texid := loadPng(mirror,"data/tree1.png");
	tree2_texid := loadPng(mirror,"data/tree2.png");
	tree3_texid := loadPng(mirror,"data/tree3.png");
	tree4_texid := loadPng(mirror,"data/tree4.png");
	tree5_texid := loadPng(mirror,"data/tree5.png");

	tree8_texid := loadPng(mirror,"data/tree-51363.png");

	exit_texid := loadPng(mirror,"data/wexit.png");
	lab_texid := loadPng(mirror,"data/wlab.png");

	treeTexShadID:=LoadShaders("./data/windtexobj.vs","./data/otexobj.fs");
	treeMatrixID := glGetUniformLocation( treeTexShadID, pmvp );
	treeuniftex := glGetUniformLocation( treeTexShadID, pmyts );
	treeunifdark := glGetUniformLocation( treeTexShadID, pdark );
	treeuniftime := glGetUniformLocation( treeTexShadID, pmytime );
	treeunifid := glGetUniformLocation( treeTexShadID, ppid );
	treebaseunifid := glGetUniformLocation( treeTexShadID, psand );

	treeradID := glGetUniformLocation(treeTexShadID, pwrad); --// vec3
	treecenid := glGetUniformLocation(treeTexShadID, pwpos); --// vec3


------------hole-shader begin ----------------------

	holeTexShadID:=LoadShaders("./data/texobjFog.vs","./data/texobjHole.fs");
	holemvid := glgetuniformlocation(holetexshadid, pmv); --MV
	holeMatrixID := glGetUniformLocation(holeTexShadID, pmvp);
	holeuniftex := glGetUniformLocation(holeTexShadID, pmyts);
	holeradID := glGetUniformLocation(holeTexShadID, phrad); --// float
	holecenid := glGetUniformLocation(holeTexShadID, phpos); --// vec3

	holeunifdark := glGetUniformLocation( holeTexShadID, pdark );
	holeuniflev := glGetUniformLocation( holeTexShadID, pmylev );
	holeunifclr := glGetUniformLocation( holeTexShadID, pmyclr );

	-- lighting effects
	--holeNorm := glGetUniformLocation( holeTexShadID, pnormal );
	holeFlag := glGetUniformLocation( holeTexShadID, pflag );
	holecolr := glGetUniformLocation( holeTexShadID, ppcolor );
	holepos1 := glGetUniformLocation( holeTexShadID, ppos1 );
	holepos2 := glGetUniformLocation( holeTexShadID, ppos2 );
	holepos3 := glGetUniformLocation( holeTexShadID, ppos3 );



--------------- maze room begin -----------------------------------

	--sky2shadid:= loadshaders("./data/skyX.vs", "./data/lightweightclouds.fs");
	-- nice lightweight clouds in deep blue sky

	sky2shadid := loadshaders("./data/skyX.vs", "./data/starfield3.fs");
	-- nice as is liminous green designs in night sky

	--sky2shadid := loadshaders("./data/skyX.vs", "./data/clouds.fs");
	-- fine B&W night clouds

	sky2matid := glgetuniformlocation(sky2shadid, pmvp);
	sky2resid := glgetuniformlocation(sky2shadid, presol);
	sky2timeid := glgetuniformlocation(sky2shadid, ptime);



	skyshadid := loadshaders("./data/skyX.vs", "./data/tunnelstars.fs");
	-- ok, pretty awesome night sky...twinkling stars with liminous colors


	skymatid := glgetuniformlocation(skyshadid, pmvp);
	skyresid := glgetuniformlocation(skyshadid, presol);
	skytimeid := glgetuniformlocation(skyshadid, ptime);



	snake_texid := loadPng(pngloader.clamp,"data/mamba.png");
	longtube.setrect( snake, 0.02, 0.02, 0.6);
	--snakeTexShadID := LoadShaders( "./data/snakeFog.vs", "./data/snakeFog.fs" );
	snakeTexShadID := LoadShaders( "./data/snakeFogHiHead.vs", "./data/snakeFog.fs" );
	snakeMatrixID := glGetUniformLocation( snakeTexShadID, pmvp );     
	snakemvid := glgetuniformlocation(snaketexshadid, pmv); --MV
	snakeuniftex := glGetUniformLocation( snakeTexShadID, pmyts );     
	snakecenid := glGetUniformLocation(snakeTexShadID, pwpos); --// vec3
	snakeunifrad := glGetUniformLocation( snakeTexShadID, prad );     
	snakeunifangl := glGetUniformLocation( snakeTexShadID, pangl );     
	snakeunifwvel := glGetUniformLocation( snakeTexShadID, pwvel );     
	snakeunifwamp := glGetUniformLocation( snakeTexShadID, pwamp );

	snakeunifdark := glGetUniformLocation( snakeTexShadID, pdark );
	snakeuniflev := glGetUniformLocation( snakeTexShadID, pmylev );
	snakeunifclr := glGetUniformLocation( snakeTexShadID, pmyclr );






	-- pool:
poolshadid:=loadshaders("./data/poolobjFog.vs","./data/myBlueWaterFog.fs");
	poolmvid := glgetuniformlocation(poolshadid, pmv);
	poolmatid := glgetuniformlocation(poolshadid, pmvp);
	timeid    := glgetuniformlocation(poolshadid, pmytime);
	wlevid    := glgetuniformlocation(poolshadid, pwaterlevel);
	pradid    := glgetuniformlocation(poolshadid, pwRad);
	pcenid    := glgetuniformlocation(poolshadid, pwPos);




	



end setup_textures; ---------------------------------------------------------




type itemtype is (gkee, bkee, wkee, srd, cup);

procedure dropitem( item: itemtype ) is
begin



	if item=gkee then --green key

		xgkey:=xme;
		zgkey:=zme;
		sgkey:=scene;
		gkeyheld:=false;
		if scene=2 then
			ygkey:=htobj;
		elsif interior then
			ygkey:=-iymax+2.0*htobj;
		else
			ygkey:=htobj+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key3, 
			xgkey,ygkey,zgkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);


	elsif item=bkee then --black key

		xbkey:=xme;
		zbkey:=zme;
		sbkey:=scene;
		bkeyheld:=false;
		if scene=2 then
			ybkey:=htobj;
		elsif interior then
			ybkey:=-iymax+2.0*htobj;
		else
			ybkey:=htobj+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key2, 
			xbkey,ybkey,zbkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);

	elsif item=wkee then --white key

		xwkey:=xme;
		zwkey:=zme;
		swkey:=scene;
		wkeyheld:=false;
		if scene=2 then
			ywkey:=htobj;
		elsif interior then
			ywkey:=-iymax+2.0*htobj;
		else
			ywkey:=htobj+land_alt(xme,zme);
		end if;

		pictobj.setrect( 
			key1, 
			xwkey,ywkey,zwkey, --xc,yc,zc
			0.1, 0.0, 0.1, --xr,yr,zr
			j1,j2,j3,j4,j5,j6);

	elsif item=srd then

		xsword:=xme;
		zsword:=zme;
		ssword:=scene;
		swordheld:=false;
		if scene=2 then
			ysword:=htobj;
		elsif interior then
			ysword:=-iymax+2.0*htobj;
		else
			ysword:=htobj+land_alt(xme,zme);
		end if;


		pictobj.setrect( 
			sword, 
			xsword,ysword,zsword,
			rsword, 0.0, 0.2*rsword,
			j1,j2,j3,j4,j5,j6);


	elsif item=cup then

		xchalice:=glfloat(xme);
		if scene=2 then
			ychalice:=glfloat(htobj)+hcup;
		elsif interior then
			ychalice:=glfloat(-iymax+htobj)+hcup;
		else
			ychalice:=glfloat(htobj+land_alt(xme,zme))+hcup;
		end if;
		zchalice:=glfloat(zme);
		schalice:=scene;
		chaliceheld:=false;
		-- uses [dynamic] uniform-positioning @ draw-time

	end if;

end dropitem;



-- decide if object is picked
procedure pickLeft( item: itemtype ) is
begin

if 
	not gatewait and
	not lionwait and
	not labwait and
	not mazewait 
then


	if item=gkee then

		if swordheld then dropitem(srd);
		elsif wkeyheld then dropitem(wkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		gkeyheld:=true; 
		swordheld:=false; 
		chaliceheld:=false; 
		bkeyheld:=false;
		wkeyheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=wkee then

		if swordheld then dropitem(srd);
		elsif gkeyheld then dropitem(gkee);
		elsif bkeyheld then dropitem(bkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		wkeyheld:=true; swordheld:=false; chaliceheld:=false; 
		bkeyheld:=false;
		gkeyheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=bkee then

		if swordheld then dropitem(srd);
		elsif wkeyheld then dropitem(wkee);
		elsif gkeyheld then dropitem(gkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		bkeyheld:=true; swordheld:=false; 
		chaliceheld:=false; wkeyheld:=false;
		gkeyheld:=false;
		snd4ada_hpp.playSnd(up); --pickup


	elsif item=srd then

		if wkeyheld then dropitem(wkee);
		elsif bkeyheld then dropitem(bkee);
		elsif gkeyheld then dropitem(gkee);
		elsif chaliceheld then dropitem(cup);
		end if;

		swordheld:=true; wkeyheld:=false; 
		chaliceheld:=false; bkeyheld:=false;
		gkeyheld:=false;
		snd4ada_hpp.playSnd(up); --pickup

	elsif item=cup then

		if swordheld then dropitem(srd);
		elsif bkeyheld then dropitem(bkee);
		elsif gkeyheld then dropitem(gkee);
		elsif wkeyheld then dropitem(wkee);
		end if;

		chaliceheld:=true; swordheld:=false; 
		wkeyheld:=false; bkeyheld:=false;
		gkeyheld:=false;
		chalicegone:=true; --do NOT show inside rocksafe
		drawchalice:=true; --...but DO draw it as soon as dropped
		snd4ada_hpp.playSnd(up); --pickup

	end if; -- cup


end if; -- not wait

end pickLeft;







procedure drawAvatar( mytime : float ) is

begin
	
	glUseProgram(avaTexShadID);
	glUniformMatrix4fv(avaunifmat, 1, GL_FALSE, imvp(1,1)'address);
	glUniform1f(avaunifang, glfloat(horiang));

	glUniform1i(avaunifdir, glint(direction));

	if showingHand then
		glUniform1i(avaunifade, 1); -- fade avatar
	else
		glUniform1i(avaunifade, 0); -- no fade
	end if;

	glUniform1f(avauniftime, glfloat(mytime));

	glUniform3f(avaunifcen, 
		glfloat(xme),glfloat(yme-aheight),glfloat(zme) );

		glUniform1i(avauniftex, 0);

		glbindtexture(gl_texture_2d, ava_texid);



	avatarobj.draw(ava, vertbuff,uvbuff,elembuff);


end drawAvatar;



procedure pickOrDrop is
begin

---------------------------------------------------------------
		-- perhaps an item is being picked...

			-- green key logic:
			if sgkey=scene and gkeynear  then
				pickLeft(gkee);

			-- black key logic:
			elsif sbkey=scene and bkeynear  then
				pickLeft(bkee);

			-- white key logic:
			elsif swkey=scene and wkeynear  then
				pickLeft(wkee);

			-- sword logic:
			elsif ssword=scene and swordnear  then
				pickLeft(srd);

			-- chalice logic:
			elsif schalice=scene and chalicenear  then
				pickLeft(cup);


		-- or maybe an item is being dropped...


			elsif wkeyheld and not gatewait then
				wkeyheld:=false;
				dropitem(wkee);
				snd4ada_hpp.playSnd(down); --putdown


			elsif gkeyheld and not mazewait then
				gkeyheld:=false;
				dropitem(gkee);
				snd4ada_hpp.playSnd(down); --putdown

			elsif bkeyheld and not lionwait and not labwait then
				bkeyheld:=false;
				dropitem(bkee);
				snd4ada_hpp.playSnd(down); --putdown


			elsif swordheld then
				swordheld:=false;
				dropitem(srd);
				snd4ada_hpp.playSnd(down); --putdown


			elsif chaliceheld then
				chaliceheld:=false;
				dropitem(cup);
				snd4ada_hpp.playSnd(down); --putdown

				if interior and scene=2 and pedestalnear then
					xchalice:=xped;
					ychalice:=yped+hcup;
					zchalice:=zped;
					success:=true;
				end if;

			end if;
-----------------------------------------------

end pickOrDrop;











	sz: integer;

	winnertime, warningtime: float:=0.0;
	warningpause: constant float := 2.0;
	warningreset: constant float := 60.0;

	keydwell: constant float := 2.0; --seconds
	dt,btntime,keytime, dxme : float := 0.0;

	reenter, roarbegun, runAway: boolean:=false; --used for red dragon

	dbug: boolean := false;
	--dbug: boolean := true;
	avent_main_error : exception;

-------------------------- main program begin ==========================
begin --adaventure



	new_line;
	new_line;
	put_line("Please be patient...AdaVenture is slow to load...");
	put_line("...starting Level " & integer'image(chapter) );
	new_line;
	new_line;


	first_prep;  -- main program setup
	-- NOW, we may begin tesing for GLerrors

	nerr:=dumpGLerrorQueue("AV.main_1");

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	emptyGLerrorQueue; -- avoid misleading messages in setup_textures
	setup_textures; -- prep various textures

	nerr:=dumpGLerrorQueue("AV.main_2");


	initializeNewMazes;

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	updateMVPs( float(winwidth), float(winheight) );






	xtreeobj.setrect(chalice);

	nko:=0;
	setup_exterior(chapter);
	setup_castle;

	if chapter=1 then
		setup_maze5;
		setup_maze6;
		setup_temple;
	elsif chapter=2 then
		setup_maze7;
		setup_lab8;
	end if;
	-- note:  darkness set in draw_exterior...
	-- ch 1:  if chaliceheld then d:=1 (bright day) else d:=2
	-- ch 2:  if chaliceheld then d:=2 (dark night) else d:=1

put("nko="&integer'image(nko));
put_line(", maxnko="&integer'image(maxnko));

	nuscene:=1; -- starting scene
	xme:= -5.0;
	zme:=-15.0;
	yme:=aheight+land_alt(xme,zme);

	xcam:=xme; ycam:=yme; zcam:=zme;


-- debug begin...chalice inside castle --------------------
--xchalice:=-5.0;
--ychalice:=glfloat(htobj)+hcup;
--zchalice:=-5.0;
--schalice:=2;

-- debug quick access key:
--xwkey:=-5.0; zwkey:=-13.0; swkey:=1;
--ywkey:=htobj+land_alt(xwkey,zwkey);
--pictobj.setrect( key1, xwkey,ywkey,zwkey,
--0.1, 0.0, 0.1, j1,j2,j3,j4,j5,j6);
-- debug end...chalice inside castle ----------------------

-- debug lab
--nuscene:=8;
--scene:=8;
--interior:=true;
--xme:= 2.0;
--zme:= 2.0;
--yme:=-iymax+aheight;
--swordheld:=true;
--ssword:=8;
--intro:=false;
-- debug lab ------------------------------------------


-- debug maze7
--nuscene:=7;
--scene:=7;
--interior:=true;
--xme:= 0.0;
--zme:= 0.0;
--yme:=-iymax+aheight;
--intro:=false;
-- debug lab ------------------------------------------





	nerr:=dumpGLerrorQueue("AV.main_3");
	-- begin mainloop with a clean slate



	-- main event loop begin: ------------------------------------------
   while not userexit loop

		direction:=0;

		if nuscene /= scene then

			if nuscene=1 then interior:=false;
			else interior:=true; end if;

			if scene=2 then snd4ada_hpp.stopLoop(water); end if; --water
			if nuscene=2 then snd4ada_hpp.playLoop(water); end if;

			if nuscene=1 then
				if scene=2 and seen1already and not bdragonsent then
					bdragonfly:=true;
					dragonstart:=float(sdl_getticks)/1000.0;

					bdragonsent:=true;
				end if;
				seen1already:=true; 
			end if;


			if nuscene=5 then
				if scene=1 and not rdragonsent then
					rdragonfly:=true;
					runAway:=false; --deadly encounter
					dragonstart:=float(sdl_getticks)/1000.0;

					rdragonsent:=true;
				end if;
			end if;



			-- if we exit the labyrinth with the chalice, send bat;
			-- otherwise send dragon:

			if nuscene=7 and chaliceheld and not bat7sent then
				sendBat; -- just once per scene
				bat7sent:=true;

			elsif nuscene=7 and scene=8 and not chaliceheld then
				--send Red Dragon and hope user has sword!
				rdragonfly:=true;
				runAway:=false; --deadly encounter
				dragonstart:=float(sdl_getticks)/1000.0;
				rdragonsent:=true;

			elsif nuscene=7 and scene=1 and not chaliceheld then
				--send Red Dragon and hope user has sword!
				rdragonfly:=true;
				runAway:=true; --runs away
				dragonstart:=float(sdl_getticks)/1000.0;
				rdragonsent:=true;

			end if;




			scene:=nuscene;

			--19dec16 addendum to correct direction after entry
			ahoriang:=horiang;
			choriang:=horiang;
			updateCamera(true); 
			-- initialize=true => reset (xcam,zcam) whether moving or not

		end if; -- nuscene /= scene


		if reenter then
			ahoriang:=horiang;
			choriang:=horiang;
			updateCamera(true); 
			-- initialize=true => reset (xcam,zcam) whether moving or not
			reenter:=false;
		end if;




		if scene=5 and bkeyseen and not bat5sent then
			sendBat; -- just once per scene
			bat5sent:=true;
		end if;

		if scene=1 and wkeyseen and not bat1sent then
			sendBat; -- just once per scene
			bat1sent:=true;
		end if;








	-- main event loop middle: -----------------------------------------------

------- begin response to user inputs ////////////////////////////////////

		currentTime := float(sdl_getticks)/1000.0;


		if ((currenttime-warningtime)>warningreset) then
			warning1:=false;
			-- if you avoid the snake for 1 minute
			-- then you will, again, get a warning
		end if;


		SDL_PumpEvents;
		key_map := sdl_getkeyboardstate(numkeys'access);


		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then userexit:=true; end if;
		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then userexit:=true; end if;

		if
			( key_map( SDL_SCANCODE_I ) /= 0 )
			and (currentTime-keytime>keydwell)
		then 
			intro:=not intro; 
			keytime:=currentTime;

			--this output only for debugging:
			--put("scene="&integer'image(scene));
			--put_line(", -me: "
			--	&float'image(xme)&","
			--	&float'image(yme)&","&float'image(zme));

		elsif
		(
			( key_map( SDL_SCANCODE_M ) /= 0 )
			or
			( key_map( SDL_SCANCODE_F1 ) /= 0 )
		)
			and (currentTime-keytime>keydwell)
		then
			thirdPerson:=not thirdPerson;
			keytime:=currenttime;


		elsif 
			( key_map( SDL_SCANCODE_SPACE ) /= 0 )
			and (currentTime-keytime>keydwell)
		then
			pickOrDrop;
			keytime:=currenttime;

		end if;


		if
			( key_map( SDL_SCANCODE_UP ) /= 0 )
			or ( key_map( SDL_SCANCODE_W ) /= 0 )
		then 
			moveForward(currentTime); --updategamestate called

		elsif
			( key_map( SDL_SCANCODE_DOWN ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_S ) /= 0 )
		then 
			moveBackward(currentTime); --updategamestate called

		end if;
		

-----	///////////////////// begin response to mouse buttons


		if abs(currentTime-pltime)>pickdwell then

			MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
			state := integer( MouseState );
			ileft := integer( SDL_BUTTON(1) );
			--iright:= integer( SDL_BUTTON(3) );

			if    bitmatch(state, ileft)   then --left mouse btn was pressed
				pltime:=currentTime;
				pickOrDrop;

			elsif bitmatch(state, iright) then --right mouse btn was pressed
				null;
			end if;

		end if; -- dt>pickdwell



		deltaT := currentTime - oldTimeKb;

		if
			( key_map( SDL_SCANCODE_LEFT ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_A ) /= 0 )
		then
			roty := +0.5*deltaT;
			horiang := horiang + speed*2.0*roty;
			setCamAng;

			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			updategamestate; --automatic in moveforward

		elsif
			( key_map( SDL_SCANCODE_RIGHT ) /= 0 ) 
			or ( key_map( SDL_SCANCODE_D ) /= 0 )
		then
			roty := -0.5*deltaT;
			horiang := horiang + speed*2.0*roty;
			setCamAng;

			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

			updategamestate; --automatic in moveforward

		end if;


------ begin mouse drag -------------------------------------------
		handle_mouse_drag(currentTime);
------ end mouse drag -------------------------------------------


----------- begin game controller ---------------------------------
	if joystik or gamepad then

		-- axis values in [-32768...+32767]

		-- JS: 2nd Axis parm:  0..2
		-- GC: 2nd Axis parm:  0..3

		-- unresolved question:  how do I prevent spinning @ startup?

		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
		handle_gc_left(axis_lx,axis_ly);

		if gamepad then -- these handle move forward/backward
			axis_rx := SDL_JoystickGetAxis(jsa, 2);
			axis_ry := SDL_JoystickGetAxis(jsa, 3);
			handle_gc_right(currentTime,axis_rx,axis_ry);
		end if;

		-- now for the buttons:

		-- 1 => pressed,  0 => not pressed
		-- JS: 2nd Btn parm:  0..7
		-- GC: 2nd Btn parm:  0..11

		zeroBtns; -- set btns 0..8 to zero
		if gamepad then
			btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- pick&drop(LtShoulder)
			btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- pick&drop(RtShoulder)
			btn_8 := SDL_JoystickGetButton(jsa,gjmp); -- 
		elsif joystik then
			btn_0 := SDL_JoystickGetButton(jsa,jbak); -- moveBackward(trigger)
			btn_1 := SDL_JoystickGetButton(jsa,jfor); -- moveForward(thumb)
			btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- pick&drop(thumb)
			btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- pick&drop(thumb)
			btn_7 := SDL_JoystickGetButton(jsa,jjmp); -- 
		end if;

		if gamepad then
			if 
				(btn_4>0 or btn_5>0 or btn_8>0) and
				(currentTime-btntime>keydwell)
			then --pick/drop
				pickOrDrop;
				btntime:=currenttime;
			end if;
		end if;

		if joystik then
			if    btn_0>0 then -- JS.trigger
				moveBackward(currentTime);
			elsif btn_1>0 then -- JS.thumb
				moveForward(currentTime);
			elsif 
				(btn_2>0 or btn_3>0 or btn_7>0 ) and
				(currentTime-btntime>keydwell)
			then --pick/drop
				pickOrDrop;
				btntime:=currenttime;
			end if;
		end if;


	end if; --joystik or gamepad
----------- end game controller ---------------------------------

----////////////// end response to user inputs //////////////////////////


		updateCamera;
		updateMVPs( float(winwidth), float(winheight) );

		currentTime := float(sdl_getticks)/1000.0;

		foldtime:=currenttime; --forward dwell
		boldtime:=currenttime; --backward dwell
		oldTimeKb := currentTime; --Keyboard dwell



--------- begin drawing =================================================
		glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);










	--test for scene transition;  if changing...reset
	--position (xme,yme,zme) to a reasonable entrance value

-- current status per scene:
--  1 = exterior
--  2 = castle
--  3 = defunct

--  4 = temple
--  5 = entry from exterior maze (chapter1)
--  6 = exit to temple maze (chapter1)

--  7 = entry from exterior, exit to labyrinth maze (ch2)
--  8 = labyrinth (ch2)


		if (scene=1 or scene=2) and atdoor(currenttime) then
			if scene=1 then 
				nuscene:=2;
				xme:=ixdoor;
				zme:=izdoor+ddoor+0.01;
				yme:=aheight;
			elsif scene=2 then 
				nuscene:=1;
				xme:=xdoor;
				zme:=zdoor-ddoor-0.01;
				yme:=aheight+land_alt(xme,zme);
			end if;
		end if;



		if 
			(scene=1 or scene=5 or scene=7) 
			and atmaze(currenttime) 
			and mazeopen
			and not mazewait
		then
			if scene=1 then
				if chapter=1 then	nuscene:=5;
				elsif chapter=2 then nuscene:=7; end if;

				xme:=ixmaze;
				zme:=izmaze+dmaze+0.01;
				yme:=-iymax+aheight;
			elsif scene=5 or scene=7 then 
				nuscene:=1;
				xme:=xmaze; -- new single doorway
				zme:=zmaze-dmaze-0.01;
				yme:=aheight+land_alt(xme,zme);
			end if;
		end if;



		if 
			(scene=6 or scene=4) 
			and attemple(currenttime)
			and lionopen
			and not lionwait
		then
			if scene=4 then 
				nuscene:=6;
				xme:=xtmpl;
				zme:=ztmpl-dtmpl-0.01;
				yme:=-iymax+aheight;
			elsif scene=6 then 
				nuscene:=4;
				xme:=ixtmpl;
				zme:=iztmpl+dtmpl+0.01;
				yme:=-iymax+aheight;
			end if;
		end if;


		-- scenes 7, 8 should already be setup correctly by this point !


---------- continue drawing =============================================

		--exterior
		if scene=1 then

			-- economize if insides of castle are not visible
			if zme<-10.0 then -- inside visible
				oyme:=yme;
				yme:=yme+0.1; --need slight boost so floor looks correct

				updateMVPs( float(winwidth), float(winheight) );
				draw_castle; --interior


				-- restore exterior coords
				yme:=oyme;
				updateMVPs( float(winwidth), float(winheight) );
			end if;

			draw_exterior(chapter);



		--castle interior
		elsif scene=2 then

			--in case we can see outside:
			draw_exterior(chapter); --here, yme is close enough

			draw_castle; --interior

			drawspider(currenttime);

		--greek temple
		elsif scene=4 then --assuming see-thru to scene#6

			--in case we can see maze outside temple:
			zme:=zme+20.0;
			zcam:=zcam+20.0;
			updateMVPs( float(winwidth), float(winheight) );
			draw_maze6;

			zme:=zme-20.0;	 --restore to present value
			zcam:=zcam-20.0;
			updateMVPs( float(winwidth), float(winheight) );

			draw_temple;



		--maze part1
		elsif scene=5 then --connected with itself, scene #6, #1=exterior

		-- See scene5.txt, scene6.txt for definitions of
		-- all the inter-connections:
		-- { a,b,c,d,e,f,g,y,z,v,w,x, a1,a2,b1,b2, 
		--   c6,d6,e6,f6,g6,v6,w6,x6,y6,z6 }

			draw_maze5;


-- now, check for imminent transitions...


			--(+10,+9) -> #6 @(-10,+9)
			if atc(currenttime) then
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,+4) -> #6 @(-10,+4)
			elsif atd(currenttime) then
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,+2) -> #6 @(-10,+2)
			elsif ate(currenttime) then
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,+0) -> #6 @(-10,+0)
			elsif atf(currenttime) then
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(+10,-2) -> #6 @(-10,-2)
			elsif atg(currenttime) then
					xme:=xme-20.0;
					nuscene:=6;
					xme:=xme+step;

			
			--(-10,+2) -> #6 @(+10,+2)
			elsif atv(currenttime) then
					xme:=xme+20.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,+0) -> #6 @(+10,+0)
			elsif atw(currenttime) then
					xme:=xme+20.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,-2) -> #6 @(+10,-2)
			elsif atx(currenttime) then
					xme:=xme+20.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,+9) -> #6 @(+10,-4)
			elsif aty(currenttime) then
					xme:=xme+20.0;
					zme:=zme-13.0;
					nuscene:=6;
					xme:=xme-step;

			
			--(-10,+4) -> #6 @(+10,-9)
			elsif atz(currenttime) then
					xme:=xme+20.0;
					zme:=zme-13.0;
					nuscene:=6;
					xme:=xme-step;
			end if;



		--maze part2
		elsif scene=6 then --connected with itself & scene #5, #4=temple

			zme:=zme-20.0; --temple coords
			zcam:=zcam-20.0;
			updateMVPs( float(winwidth), float(winheight) );
			draw_temple; --scene #4
			zme:=zme+20.0; --restore to present value
			zcam:=zcam+20.0;
			updateMVPs( float(winwidth), float(winheight) );
	
			draw_maze6;


-- now, check for imminent transitions:


			if atz(currenttime) then

			--(+10,-9) -> #5 @(-10,+4)
				xme:=xme-20.0;
				zme:=zme+13.0;
				nuscene:=5;
				xme:=xme+step;

			elsif aty(currenttime) then

			--(+10,-4) -> #5 @(-10,+9)
				xme:=xme-20.0;
				zme:=zme+13.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atx(currenttime) then

			--(+10,-2) -> #5 @(-10,-2)
				xme:=xme-20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atw(currenttime) then

			--(+10,+0) -> #5 @(-10,+0)
				xme:=xme-20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atv(currenttime) then

			--(+10,+2) -> #5 @(-10,+2)
				xme:=xme-20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atg(currenttime) then

			--(-10,-2) -> #5 @(+10,-2)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atf(currenttime) then

			--(-10,0)  -> #5 @(+10,+0)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme+margin;

			elsif ate(currenttime) then

			--(-10,+2) -> #5 @(+10,+2)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme+step;

			elsif atd(currenttime) then

			--(-10,+4) -> #5 @(+10,+4)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atc(currenttime) then

			--(-10,+9) -> #5 @(+10,+9)
				xme:=xme+20.0;
				nuscene:=5;
				xme:=xme-step;

			elsif atb2(currenttime) then

			--(-10,-9) -> (+10,+4)
				xme:=xme+20.0;
				zme:=zme+13.0;
				nuscene:=6;
				xme:=xme-step;
				reenter:=true;

			elsif atb1(currenttime) then

			--(+10,+4) -> (-10,-9)
				xme:=xme-20.0;
				zme:=zme-13.0;
				nuscene:=6;
				xme:=xme+step;
				reenter:=true;

			elsif ata2(currenttime) then

			--(-10,-4)
				xme:=xme+20.0;
				zme:=zme+13.0;
				nuscene:=6;
				xme:=xme-step;
				reenter:=true;

			elsif ata1(currenttime) then

			--(+10,+9)
				xme:=xme-20.0;
				zme:=zme-13.0;
				nuscene:=6;
				xme:=xme+step;
				reenter:=true;

			end if;

------------ addendum 29oct16 begin --------------------------------------

		elsif scene=7 then --connected with itself & scene #1, #8=labyrinth

			draw_maze7;

-- 1st, check for imminent transitions within scene7:

			if at7a(currenttime) then
				nuscene:=7;
				reenter:=true;

			elsif at7b(currenttime) then
				nuscene:=7;
				reenter:=true;

			elsif at7c(currenttime) then
				nuscene:=7;
				reenter:=true;

			elsif at7d(currenttime) then
				nuscene:=7;
				reenter:=true;

			elsif at7e(currenttime) then
				nuscene:=7;
				reenter:=true;

			elsif at7f(currenttime) then
				nuscene:=7;
				reenter:=true;




-- 2nd, check for scene8 transitions:
			elsif at78g(currenttime)  then
				nuscene:=8;

			elsif at78h(currenttime)  then
				nuscene:=8;

			end if;




		elsif scene=8 then --connected only with scene7

			draw_lab8;

			if at78g(currenttime) then
				nuscene:=7;

			elsif at78h(currenttime) then
				nuscene:=7;

			end if;

------------- addendum 29oct16 end ----------------------------------------

		end if; -- scene=8





-------------------------------------------------------------------------

--bat moved to draw_exterior & draw_maze5

------------- begin draw dragons ----------------------------------------





		if bdragonfly and (scene=1 or scene=2) then --draw dragon
			dt:=(currenttime-dragonstart)/dragonduration; -- 0..1
			if dt>=1.0 then
				--snd4ada_hpp.stopLoops; -- in case of hissbeat
				bdragonfly:=false;
				bsdra:=scene;
				bxdra:=xme;
				bzdra:=zme;
				if interior then --scene=2
					bydra:=2.0*htobj;
				else
					bydra:=2.0*htobj+land_alt(bxdra,bzdra);
				end if;
				pictobj.setrect( 
					bdragon, 
					bxdra,bydra,bzdra,
					0.6, 0.0, 0.6, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

				snd4ada_hpp.playSnd(roar); --Roar (in either case) 11sep16
				delay 0.8; -- give time to play roar

				if swordheld then --dragon dies
					bdragondead:=true;
					snd4ada_hpp.playSnd(die); -- dragondie.wav
					delay 0.8;
				else --dragon eats you...
					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_dragon:=true;
				end if;
				
			else
				drawbdragon(dt);
			end if;
		end if; --bdragonfly





		-- draw RED dragon
		if rdragonfly and (scene=5 or scene=1 or scene=6 or scene=7) then
			dt:=(currenttime-dragonstart)/dragonduration; -- 0..1

			if dt>=2.0 and runAway then
				rdragonfly:=false;
				runAway:=false;
				roarbegun:=false;

			elsif dt>=1.0 and runAway then
				--snd4ada_hpp.stopLoops; -- in case of hissbeat
				if swordheld then
					drawrdragon(2.0-dt); --retreat

					-- would prefer a diminshing retreat roar
					if not roarbegun then
						snd4ada_hpp.playSnd(roar); --Roar but retreat
						roarbegun:=true;
					end if;
					--delay 0.8; -- give time to play roar


				else --dragon eats you...
					rdragonfly:=false;

					snd4ada_hpp.playSnd(roar); --Roar
					delay 0.8; -- give time to play roar

					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_dragon:=true;
				end if;

			elsif dt>=1.0 then
				--snd4ada_hpp.stopLoops; -- in case of hissbeat
				rdragonfly:=false;
				rsdra:=scene;
				rxdra:=xme;
				rzdra:=zme;
				if interior then
					rydra:=-iymax+2.0*htobj;
				else
					rydra:=land_alt(rxdra,rzdra)+2.0*htobj;
				end if;
				pictobj.setrect( 
					rdragon, 
					rxdra,rydra,rzdra,
					0.6, 0.0, 0.6, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

				snd4ada_hpp.playSnd(roar); --Roar (in either case) 11sep16
				delay 0.8; -- give time to play roar

				if swordheld then --dragon dies
					rdragondead:=true;
					snd4ada_hpp.playSnd(die); -- dragondie.wav
					delay 0.8;
				else --dragon eats you...
					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_dragon:=true;
				end if;
				
			else -- 0<dt<1
				drawrdragon(dt);
			end if;
		end if; --rdragonfly




		if minofly and scene=8 then
			dt:=(currenttime-dragonstart)/(0.5*dragonduration); -- 0..1
			if dt>=1.0 then
				--snd4ada_hpp.stopLoops; -- in case of hissbeat
				minofly:=false;
				mxdra:=xme;
				mzdra:=zme;
				mydra:=-iymax+2.0*htobj;
				pictobj.setrect( minotaur,
					mxdra,mydra,mzdra,
					0.6, 0.0, 0.6, --xr,yr,zr
					j1,j2,j3,j4,j5,j6);

				snd4ada_hpp.playSnd(roar); --Roar (in either case) 11sep16
				delay 0.8; -- give time to play roar

				if swordheld then --minotaur dies
					minotaurdead:=true;
					snd4ada_hpp.playSnd(die); -- dragondie.wav
					delay 0.8;
				else --minotaur eats you...
					snd4ada_hpp.playSnd(eat); -- eaten.wav
					delay 1.0;
					userexit:=true;
					imdead_minotaur:=true;
				end if;
				
			else
				drawMinotaur(dt);
			end if;
		end if; --minofly

		if scene=8 and minotaurdead then
			glUseProgram( pgmtexshadid );
			gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
			gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );
			gluniform1i(uniftex,0);
			glUniform1i(unifdark, darkness);
			gluniform1i(uniflev, interfaces.c.int(3) ); 
			-- 1=>normal, 2=>heavy, 3=>extreme fog
			gluniform1i(unifclr, interfaces.c.int(1) ); 
			-- 1=>gray, 2=>brown, 3=>purple fog
			glbindtexture(gl_texture_2d, deadminotaur_texid);
			pictobj.draw(minotaur, vertbuff,uvbuff,elembuff);
		end if;








		if scene=rsdra and rdragondead then

			if not interior then
				glUseProgram(pidterra);
				glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, imvp(1,1)'address);
				glUniform1i(muniftex, 0);
				glUniform1i(munifdark, darkness);

				glbindtexture(gl_texture_2d, deadrdragon_texid);
				pictobj.draw(rdragon, vertbuff,uvbuff,elembuff);
			else
				glUseProgram( pgmtexshadid );
				gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
				gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );
				gluniform1i(uniftex,0);
				glUniform1i(unifdark, darkness);
				gluniform1i(uniflev, interfaces.c.int(3) ); 
				-- 1=>normal, 2=>heavy, 3=>extreme fog
				gluniform1i(unifclr, interfaces.c.int(1) ); 
				-- 1=>gray, 2=>brown, 3=>purple fog

				glbindtexture(gl_texture_2d, deadrdragon_texid);
				pictobj.draw(rdragon, vertbuff,uvbuff,elembuff);
			end if;

		end if;



		if scene=bsdra and bdragondead then

			if not interior then
				glUseProgram(pidterra);
				glUniformMatrix4fv(mMatrixID, 1, GL_FALSE, imvp(1,1)'address);
				glUniform1i(muniftex, 0);
				glUniform1i(munifdark, darkness);

				glbindtexture(gl_texture_2d, deadbdragon_texid);
				pictobj.draw(bdragon, vertbuff,uvbuff,elembuff);
			else

				glUseProgram( pgmtexshadid );
				gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
				gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );
				gluniform1i(uniftex,0);
				glUniform1i(unifdark, darkness);
				gluniform1i(uniflev, interfaces.c.int(3) ); 
				-- 1=>normal, 2=>heavy, 3=>extreme fog
				gluniform1i(unifclr, interfaces.c.int(1) ); 
				-- 1=>gray, 2=>brown, 3=>purple fog

				glbindtexture(gl_texture_2d, deadbdragon_texid);
				pictobj.draw(bdragon, vertbuff,uvbuff,elembuff);
			end if;

		end if;


------------- end draw dragons ----------------------------------------




----------------------- avatar begin ------------------------------------

		if thirdPerson then 
			currentTime := float(sdl_getticks)/1000.0;
			-- moved here 3apr17 to assure fresh, accurate
			-- (xme,yme,zme) & (xcam,ycam,zcam) positions
			-- and perhaps avoid avatar jitter.
			drawAvatar(currenttime);
		end if;

-------------------------------------------------------------------------

		-- interaction with snake is too complex:
		--if minofly then
		--	if not hissbeat then
		--		hissbeat:=true;
		--		snd4ada_hpp.playLoop(hiss);
		--	end if;
		--end if;


		if snakehiss then
			if not hissbeat then
				hissbeat:=true;
				snd4ada_hpp.playLoop(hiss);
			end if;
		elsif hissbeat then
			hissbeat:=false;
			snd4ada_hpp.stopLoop(hiss);
		end if;



		if nearsnake then
			utex.print2d("TOO CLOSE...",0.3,0.80,50);
			utex.print2d("that mamba is deadly.",0.2,0.70,50);

			if warning1 and ((currenttime-warningtime)>warningpause) then

				-- here we should roll the dice...even if you are holding
				-- a sword, 1 out of 3 times you still die...

				if not swordheld then -- 20nov17 addendum
					userexit:=true;
					imdead_snake:=true;

				elsif snakeVSsword<2 then
					null; -- do nothing 
					-- we COULD kill the snake here
					-- but it's more fun if we keep it...
					utex.print2d("your SWORD keeps him at bay!",0.2,0.60,40);
					snakeVSsword:=snakeVSsword+1;

				else -- you die anyway
					userexit:=true;
					imdead_snake:=true;

				end if;

			else
				warning1:=true;
				warningtime := currenttime;
			end if;
		end if;



		if intro then
			sz:=25;
			if chapter=1 then
				utex.print2d("AdaVenture is a point & click quest set in",0.02,0.90,sz);
				utex.print2d("ancient Persia.  The golden chalice of Xerxes",0.02,0.85,sz);
				utex.print2d("has been stolen by Leonidas the Spartan King.",0.02,0.80,sz);
				utex.print2d("Find & return the golden chalice",0.02,0.75,sz);
				utex.print2d("to its pedestal within the castle.",0.02,0.70,sz);
				utex.print2d("Use the sword to kill deadly beasts,",0.02,0.65,sz);
				utex.print2d("click to grab/drop objects as needed.",0.02,0.60,sz);
				utex.print2d("The [i]-key toggles this Introduction",0.02,0.55,sz);
				utex.print2d("The [m]-key toggles the Avatar",0.02,0.50,sz);
			elsif chapter=2 then
				utex.print2d("AdaVenture is a point & click quest set in",0.02,0.90,sz);
				utex.print2d("ancient Persia.  The golden chalice of Xerxes",0.02,0.85,sz);
				utex.print2d("has been stolen by Minos the Cretan King.",0.02,0.80,sz);
				utex.print2d("Find & return the golden chalice",0.02,0.75,sz);
				utex.print2d("to its pedestal within the castle.",0.02,0.70,sz);
				utex.print2d("Use the sword to kill deadly beasts,",0.02,0.65,sz);
				utex.print2d("click to grab/drop objects as needed.",0.02,0.60,sz);
				utex.print2d("The [i]-key toggles this Introduction",0.02,0.55,sz);
				utex.print2d("The [m]-key toggles the Avatar",0.02,0.50,sz);
			end if;
		end if; --intro

		if success and (currentTime-winnertime<15.0) then --show for 15 seconds

			sz:=35;
			utex.print2d("You have restored the Golden Chalice",0.02,0.90,sz);
			utex.print2d("of Xerxes.  Praise be upon you.",0.02,0.80,sz);
			utex.print2d("Now, we shall celebrate into the night...",0.02,0.70,sz);
			utex.print2d("...or until you hit the [esc]-key.",0.02,0.60,sz);

		end if;

-- test new characters here:
--utex.print2d("!",0.5,0.5,100);
--
-- bat1="{" 
-- bat2="}"
--     RedDragon=")"
-- RedkillDragon="("
--     BlackDragon=">"
-- BlackkillDragon="<"
-- hand = "`"
-- whiteKey="~"
-- blackKey="|"
-- greenKey="^"
-- spider=":"
-- curvedSword="="
-- chalice=";"
-- minotaur=gnu="!"
--


		sdl_gl_swapwindow( mainWindow );

		if success and not heralded then
			winnertime:=currentTime;
			heralded:=true;
			delay 0.3; --allow putdown sound to complete

			--snd4ada_hpp.playSnd(fanfare); --fanfare
			--delay 1.3; --allow fanfare to complete

			snd4ada_hpp.playSnd(won); --adventure-win
			delay 5.0; --allow win-sound to complete

			if chapter=1 then snd4ada_hpp.playLoop(misr); --Misr;
			elsif chapter=2 then snd4ada_hpp.playLoop(turk); --Turk; 
			end if;
		end if;


		if imdead_minotaur then
			utex.print2d("The Minotaur Ate You.", 0.3, 0.5, 70);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		elsif imdead_dragon then
			utex.print2d("The Dragon Ate You.", 0.3, 0.5, 70);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		elsif imdead_snake then
			utex.print2d("The Mamba Bit You.", 0.1, 0.5, 70);
			sdl_gl_swapwindow( mainWindow );
			delay 3.0; --time to read above message
		end if;



		--output errors and raise exception here only if dbug
		if dbug then
			if dumpGLerrorQueue("AV main loop end")>0 then
				raise avent_main_error;
			end if;
		end if;




---------------------------------------------------------------------------
   end loop; ---------------------- main event loop end -------------------
---------------------------------------------------------------------------





	snd4ada_hpp.termSnds; -- stops any loops;  then deallocates

	release_textures;

	utex.cleanuptext;

	if joystik or gamepad then
		SDL_JoystickClose(jsa);
	end if;

	SDL_GL_DeleteContext(mainGLContext);
	SDL_DestroyWindow(mainWindow);

	SDL_Quit;


end aventure;

end avent;

