#version 330 core

//Experimental version that attempts to raise the
//snake head high

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;

out vec2 UV;
out vec4 vEyeSpacePos;
out vec4 aPos; // crazy experiment


uniform mat4 MV;

uniform mat4 MVP;
uniform vec3 wPos;  // orbit center
uniform float rad;  // orbit radius
uniform float angl; // angle
uniform float wvel; // wiggle-freq (nom=1.0)
uniform float wamp; // wiggle-amplitude (nom=1.0)

const float onepi = 3.14159;
const float halfpi = 0.5*onepi;

float wrad( float ang )
{
	//24 wiggles per twopi path around unit radius
	float dr = wamp*0.005*sin(sqrt(rad)*wvel*24*ang)/sqrt(rad); 
	return rad*(1+dr);
}

// wiggle component of final radius as ftn of 
// Z-offset=arclength away from ang:
float zwrad( float ang, float dz )
{
	float dang = atan(dz/rad);
	return wrad(ang+dang);
}

// note abs(dz)<0.6
// begin lift 0 @ +0.0 [sin(-pi/2)]
// end lift 0.4 @ +0.6 [sin(pi/2)]
float ywrad( float dz )
{
	const float dz1=0.6;
	const float dz2=dz1/2.0; // 0.3
	const float dz3=0.5*(dz2+dz1); // 0.45
	const float mxHt=0.2;

	float rawang = (dz-dz2) / dz2; // -1..+1 on [0.0..0.6]
	float ang = rawang*halfpi;
	float rawheight = 1.0 + sin(ang);
	float scaledHeight = mxHt*rawheight;

	if( dz<=0.0 ) 
		return 0.0;
	else
		return scaledHeight;
}







// note:  Z = long dimension => arclength delta from ang

void main(){

	float ang = angl;

	vec3 pos = vertexPosition_modelspace;

	// we assume original setup @ origin
	// ...move to orbit center
	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z;

	// original vector of current pt from center:
	float ddx = pos.x - wPos.x;
	float ddz = pos.z - wPos.z; //long direction delta
	float ddy = pos.y - wPos.y;

	// rotated vector of pt from center:
	float ddxx = +cos(ang)*ddx - sin(ang)*ddz;
	float ddzz = +sin(ang)*ddx + cos(ang)*ddz;

	// rotate snake to match tangent of trajectory circle:
	pos.x = wPos.x + ddxx;
	pos.z = wPos.z + ddzz;

	float zdr = zwrad(ang,ddz);
	float ydr = ywrad(ddz);

	// this displaces entire snake to move in circle:
	pos.x = pos.x + zdr*cos(ang);
	pos.z = pos.z + zdr*sin(ang);
	pos.y += ydr;

	aPos = vec4(pos,1.0);
	gl_Position  =  MVP * aPos;
	vEyeSpacePos =   MV * aPos;
	UV = vertexUV; 
}

